/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import org.jmolecules.bytebuddy.PluginUtils;
import org.jmolecules.ddd.annotation.Factory;
import org.jmolecules.ddd.annotation.Repository;
import org.jmolecules.ddd.annotation.Service;
import org.jmolecules.event.annotation.DomainEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

public class JMoleculesSpringPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(JMoleculesSpringPlugin.class);
    private static final Map<Class<?>, Class<? extends Annotation>> MAPPINGS;
    private static final Set<Class<?>> TRIGGERS;
    private static final Map<Class<? extends Annotation>, Class<? extends Annotation>> METHOD_ANNOTATIONS;
    private static final Set<String> TYPES_TO_SKIP;

    public boolean matches(TypeDescription type) {
        if (TYPES_TO_SKIP.stream().anyMatch(it -> type.getPackage().getName().startsWith((String)it))) {
            return false;
        }
        return TRIGGERS.stream().anyMatch(it -> it.isAnnotation() ? PluginUtils.isAnnotatedWith(type, it) : type.isAssignableTo(it));
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription type, ClassFileLocator classFileLocator) {
        builder = PluginUtils.mapAnnotationOrInterfaces("jMolecules Spring", builder, type, MAPPINGS);
        for (Map.Entry<Class<? extends Annotation>, Class<? extends Annotation>> entry : METHOD_ANNOTATIONS.entrySet()) {
            Class<? extends Annotation> target = entry.getValue();
            builder = builder.method(JMoleculesSpringPlugin.hasAnnotatedMethod(type, entry.getKey(), target)).intercept((Implementation)SuperMethodCall.INSTANCE).annotateMethod(new AnnotationDescription[]{PluginUtils.getAnnotation(target)});
        }
        return builder;
    }

    public void close() throws IOException {
    }

    private static ElementMatcher<? super MethodDescription> hasAnnotatedMethod(TypeDescription type, Class<? extends Annotation> source, Class<? extends Annotation> target) {
        return method -> {
            if (!method.getDeclaringType().equals(type)) {
                return false;
            }
            if (TYPES_TO_SKIP.stream().anyMatch(it -> method.getDeclaringType().getTypeName().startsWith((String)it))) {
                return false;
            }
            AnnotationList annotations = method.getDeclaredAnnotations();
            String signature = JMoleculesSpringPlugin.toLog(method);
            if (annotations.isAnnotationPresent(target)) {
                log.debug("jMolecules Spring - {} - Already annotated with @{}.", (Object)signature, (Object)PluginUtils.abbreviate(target));
                return false;
            }
            if (!annotations.isAnnotationPresent(source)) {
                log.debug("jMolecules Spring - {} - Annotation {} not found.", (Object)signature, (Object)PluginUtils.abbreviate(source));
                return false;
            }
            log.info("jMolecules Spring - {} - Adding @{}.", (Object)signature, (Object)PluginUtils.abbreviate(target));
            return true;
        };
    }

    private static String toLog(MethodDescription method) {
        TypeDefinition type = method.getDeclaringType();
        String parameterTypes = method.getParameters().asTypeList().asErasures().stream().map(TypeDescription::getSimpleName).collect(Collectors.joining(", "));
        return PluginUtils.abbreviate(type).concat(".").concat(method.getName()).concat("(").concat(parameterTypes).concat(")");
    }

    static {
        HashMap<Class<org.springframework.stereotype.Repository>, Class<Repository>> types = new HashMap<Class<org.springframework.stereotype.Repository>, Class<Repository>>();
        types.put(Service.class, org.springframework.stereotype.Service.class);
        types.put(Repository.class, org.springframework.stereotype.Repository.class);
        types.put(Factory.class, Component.class);
        types.put(org.springframework.stereotype.Service.class, Service.class);
        types.put(org.springframework.stereotype.Repository.class, Repository.class);
        MAPPINGS = Collections.unmodifiableMap(types);
        HashSet triggers = new HashSet(MAPPINGS.keySet());
        triggers.add(Component.class);
        TRIGGERS = Collections.unmodifiableSet(triggers);
        HashSet<String> toSkip = new HashSet<String>();
        toSkip.add("java.");
        toSkip.add("javax.");
        TYPES_TO_SKIP = Collections.unmodifiableSet(toSkip);
        HashMap<Class, Class> methods = new HashMap<Class, Class>();
        methods.put(DomainEventHandler.class, EventListener.class);
        methods.put(EventListener.class, DomainEventHandler.class);
        METHOD_ANNOTATIONS = Collections.unmodifiableMap(methods);
    }
}

