/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.bytebuddy;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.jmolecules.bytebuddy.ClassWorld;
import org.springframework.core.Constants;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class Jpa {
    private final String basePackage;
    private final Provider provider;

    Class<?> getAssociationAttributeConverterBaseType() {
        return this.basePackage.startsWith("javax") ? this.loadClass("org.jmolecules.spring.jpa.JpaAssociationAttributeConverter") : this.loadClass("org.jmolecules.spring.jpa.JakartaPersistenceAssociationAttributeConverter");
    }

    <T> T getCascadeTypeAll() {
        Class<? extends Annotation> annotation = this.loadClass("CascadeType");
        Constants constants = new Constants(annotation);
        return (T)constants.asObject("ALL");
    }

    <T> T getFetchTypeEager() {
        Class<? extends Annotation> fetchTypeType = this.loadClass("FetchType");
        return (T)Enum.valueOf(fetchTypeType, "EAGER");
    }

    <T> T getFetchTypeLazy() {
        Class<? extends Annotation> fetchTypeType = this.loadClass("FetchType");
        return (T)Enum.valueOf(fetchTypeType, "LAZY");
    }

    boolean isHibernate() {
        return Provider.HIBERNATE.equals((Object)this.provider);
    }

    <T extends Annotation> Class<T> getAnnotation(String name) {
        return this.loadClass(name);
    }

    <T> Class<T> getType(String name) {
        return this.loadClass(name);
    }

    public static Optional<Jpa> getJavaPersistence(ClassWorld world) {
        Provider provider;
        Assert.notNull((Object)world, (String)"ClassWorld must not be null!");
        Provider provider2 = provider = world.isAvailable("org.hibernate.Hibernate") ? Provider.HIBERNATE : Provider.GENERIC;
        if (world.isAvailable("javax.persistence.Entity")) {
            return Optional.of(new Jpa("javax.persistence", provider));
        }
        if (world.isAvailable("jakarta.persistence.Entity")) {
            return Optional.of(new Jpa("jakarta.persistence", provider));
        }
        return Optional.empty();
    }

    private Class<? extends Annotation> loadClass(String name) {
        Assert.hasText((String)name, (String)"Type must not be null or empty!");
        name = name.contains(".") ? name : this.basePackage.concat(".").concat(name);
        return ClassUtils.resolveClassName((String)name, (ClassLoader)Jpa.class.getClassLoader());
    }

    public Jpa(String basePackage, Provider provider) {
        this.basePackage = basePackage;
        this.provider = provider;
    }

    private static enum Provider {
        HIBERNATE,
        GENERIC;

    }
}

