/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.jmolecules.ddd.types.Association;
import org.jmolecules.ddd.types.Identifier;
import org.springframework.util.Assert;

class AssociationDeserializer
extends StdDeserializer<Association<?, ?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 2278790059349867093L;
    private final BeanProperty property;

    AssociationDeserializer() {
        this(null);
    }

    AssociationDeserializer(BeanProperty property) {
        super(Association.class);
        this.property = property;
    }

    public Association<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Assert.state((this.property != null ? 1 : 0) != 0, (String)"Can only deserialize Association properties.");
        JavaType[] typeParameters = this.property.getType().findTypeParameters(Association.class);
        JsonDeserializer deserializer = ctxt.findRootValueDeserializer(typeParameters[1]);
        Identifier deserialize = (Identifier)deserializer.deserialize(p, ctxt);
        return Association.forId((Identifier)deserialize);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        return new AssociationDeserializer(property);
    }
}

