/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.jmolecules.ddd.types.Identifier;
import org.jmolecules.ddd.types.ValueObject;
import org.jmolecules.jackson.AnnotationDetector;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;

class SingleValueWrappingTypeDeserializerModifier
extends BeanDeserializerModifier {
    private static final AnnotationDetector DETECTOR = AnnotationDetector.getAnnotationDetector();

    SingleValueWrappingTypeDeserializerModifier() {
    }

    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription descriptor, JsonDeserializer<?> deserializer) {
        List properties = descriptor.findProperties();
        if (properties.size() != 1) {
            return super.modifyDeserializer(config, descriptor, deserializer);
        }
        Class type = descriptor.getBeanClass();
        if (!(DETECTOR.hasAnnotation(type, org.jmolecules.ddd.annotation.ValueObject.class) || ValueObject.class.isAssignableFrom(type) || Identifier.class.isAssignableFrom(type))) {
            return super.modifyDeserializer(config, descriptor, deserializer);
        }
        BeanPropertyDefinition definition = (BeanPropertyDefinition)properties.get(0);
        Method method = SingleValueWrappingTypeDeserializerModifier.findFactoryMethodOn(type, definition.getRawPrimaryType());
        if (method != null) {
            ReflectionUtils.makeAccessible((Method)method);
            ThrowingFunction instantiator = it -> method.invoke(null, it);
            return new InstantiatorDeserializer(descriptor.getType(), instantiator, definition.getPrimaryType());
        }
        Constructor<?> findConstructor = SingleValueWrappingTypeDeserializerModifier.findConstructor(type, definition.getRawPrimaryType());
        if (findConstructor != null) {
            ReflectionUtils.makeAccessible(findConstructor);
            ThrowingFunction instantiator = it -> BeanUtils.instantiateClass((Constructor)findConstructor, (Object[])new Object[]{it});
            return new InstantiatorDeserializer(descriptor.getType(), instantiator, definition.getPrimaryType());
        }
        return super.modifyDeserializer(config, descriptor, deserializer);
    }

    private static Method findFactoryMethodOn(Class<?> type, Class<?> parameterType) {
        try {
            Method method = type.getDeclaredMethod("of", parameterType);
            return Modifier.isStatic(method.getModifiers()) ? method : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Constructor<?> findConstructor(Class<?> type, Class<?> parameterType) {
        try {
            return type.getDeclaredConstructor(parameterType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class InstantiatorDeserializer
    extends StdDeserializer<Object> {
        private static final long serialVersionUID = -874251080013013301L;
        private final ThrowingFunction instantiator;
        private final JavaType parameterType;
        private final JavaType targetType;

        public InstantiatorDeserializer(JavaType target, ThrowingFunction instantiator, JavaType parameterType) {
            super(Object.class);
            this.targetType = target;
            this.instantiator = instantiator;
            this.parameterType = parameterType;
        }

        public Object deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            JsonDeserializer deserializer = context.findNonContextualValueDeserializer(this.parameterType);
            Object nested = deserializer.deserialize(parser, context);
            try {
                return this.instantiator.apply(nested);
            }
            catch (Exception o_O) {
                throw new JsonParseException(parser, String.format("Failed to instantiate %s!", this.targetType), (Throwable)o_O);
            }
        }
    }

    private static interface ThrowingFunction {
        public Object apply(Object var1) throws Exception;
    }
}

