/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import org.jmolecules.ddd.types.Identifier;
import org.jmolecules.ddd.types.ValueObject;
import org.springframework.core.annotation.AnnotatedElementUtils;

class SingleValueWrappingTypeSerializerModifier
extends BeanSerializerModifier {
    SingleValueWrappingTypeSerializerModifier() {
    }

    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription description, JsonSerializer<?> serializer) {
        List properties = description.findProperties();
        if (properties.size() != 1) {
            return super.modifySerializer(config, description, serializer);
        }
        Class type = description.getBeanClass();
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)type, org.jmolecules.ddd.annotation.ValueObject.class) || ValueObject.class.isAssignableFrom(type) || Identifier.class.isAssignableFrom(type)) {
            return new SingleAttributeSerializer(((BeanPropertyDefinition)properties.get(0)).getAccessor());
        }
        return super.modifySerializer(config, description, serializer);
    }

    private static class SingleAttributeSerializer
    extends StdSerializer<Object> {
        private static final long serialVersionUID = 3242761376607559434L;
        private final AnnotatedMember member;

        public SingleAttributeSerializer(AnnotatedMember member) {
            super(Object.class);
            this.member = member;
        }

        public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            Object nested = this.member.getValue(value);
            provider.findValueSerializer(nested.getClass()).serialize(nested, gen, provider);
        }
    }
}

