/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.jackson3;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.springframework.core.annotation.AnnotatedElementUtils;

abstract class AnnotationDetector {
    AnnotationDetector() {
    }

    public static AnnotationDetector getAnnotationDetector() {
        if (AnnotationDetector.isPresent("org.springframework.core.annotation.AnnotatedElementUtils")) {
            return new SpringAnnotationDetector();
        }
        return new SimpleAnnotationDetector();
    }

    abstract boolean hasAnnotation(AnnotatedElement var1, Class<? extends Annotation> var2);

    private static boolean isPresent(String type) {
        try {
            Class.forName(type);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static class SpringAnnotationDetector
    extends AnnotationDetector {
        private SpringAnnotationDetector() {
        }

        @Override
        public boolean hasAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationType) {
            return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)element, annotationType);
        }
    }

    private static class SimpleAnnotationDetector
    extends AnnotationDetector {
        private SimpleAnnotationDetector() {
        }

        @Override
        public boolean hasAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationType) {
            return element.getAnnotation(annotationType) != null;
        }
    }
}

