/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.jackson3;

import org.jmolecules.ddd.types.Association;
import org.jmolecules.ddd.types.Identifier;
import org.springframework.util.Assert;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.std.StdDeserializer;

class AssociationDeserializer
extends StdDeserializer<Association<?, ?>> {
    private final BeanProperty property;

    AssociationDeserializer() {
        this(null);
    }

    AssociationDeserializer(BeanProperty property) {
        super(Association.class);
        this.property = property;
    }

    public Association<?, ?> deserialize(JsonParser p, DeserializationContext ctxt) {
        Assert.state((this.property != null ? 1 : 0) != 0, (String)"Can only deserialize Association properties.");
        JavaType[] typeParameters = this.property.getType().findTypeParameters(Association.class);
        ValueDeserializer deserializer = ctxt.findRootValueDeserializer(typeParameters[1]);
        Identifier deserialize = (Identifier)deserializer.deserialize(p, ctxt);
        return Association.forId((Identifier)deserialize);
    }

    public AssociationDeserializer createContextual(DeserializationContext ctxt, BeanProperty property) {
        return new AssociationDeserializer(property);
    }
}

