/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.jackson3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.jmolecules.ddd.types.Identifier;
import org.jmolecules.ddd.types.ValueObject;
import org.jmolecules.jackson3.AnnotationDetector;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.ValueDeserializerModifier;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.introspect.BeanPropertyDefinition;

class SingleValueWrappingTypeDeserializerModifier
extends ValueDeserializerModifier {
    private static final long serialVersionUID = 5297887920996219863L;
    private static final AnnotationDetector DETECTOR = AnnotationDetector.getAnnotationDetector();

    SingleValueWrappingTypeDeserializerModifier() {
    }

    public ValueDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription.Supplier supplier, ValueDeserializer<?> deserializer) {
        BeanDescription descriptor = supplier.get();
        List properties = descriptor.findProperties();
        if (properties.size() != 1) {
            return super.modifyDeserializer(config, supplier, deserializer);
        }
        Class type = descriptor.getBeanClass();
        if (!(DETECTOR.hasAnnotation(type, org.jmolecules.ddd.annotation.ValueObject.class) || ValueObject.class.isAssignableFrom(type) || Identifier.class.isAssignableFrom(type))) {
            return super.modifyDeserializer(config, supplier, deserializer);
        }
        BeanPropertyDefinition definition = (BeanPropertyDefinition)properties.get(0);
        Method method = SingleValueWrappingTypeDeserializerModifier.findFactoryMethodOn(type, definition.getRawPrimaryType());
        if (method != null) {
            ReflectionUtils.makeAccessible((Method)method);
            ThrowingFunction instantiator = it -> method.invoke(null, it);
            return new InstantiatorDeserializer(descriptor.getType(), instantiator, definition.getPrimaryType());
        }
        Constructor<?> findConstructor = SingleValueWrappingTypeDeserializerModifier.findConstructor(type, definition.getRawPrimaryType());
        if (findConstructor != null) {
            ReflectionUtils.makeAccessible(findConstructor);
            ThrowingFunction instantiator = it -> BeanUtils.instantiateClass((Constructor)findConstructor, (Object[])new Object[]{it});
            return new InstantiatorDeserializer(descriptor.getType(), instantiator, definition.getPrimaryType());
        }
        return super.modifyDeserializer(config, supplier, deserializer);
    }

    private static Method findFactoryMethodOn(Class<?> type, Class<?> parameterType) {
        try {
            Method method = type.getDeclaredMethod("of", parameterType);
            return Modifier.isStatic(method.getModifiers()) ? method : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Constructor<?> findConstructor(Class<?> type, Class<?> parameterType) {
        try {
            return type.getDeclaredConstructor(parameterType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static interface ThrowingFunction {
        public Object apply(Object var1) throws Exception;
    }

    private static class InstantiatorDeserializer
    extends StdDeserializer<Object> {
        private final ThrowingFunction instantiator;
        private final JavaType parameterType;
        private final JavaType targetType;

        public InstantiatorDeserializer(JavaType target, ThrowingFunction instantiator, JavaType parameterType) {
            super(Object.class);
            this.targetType = target;
            this.instantiator = instantiator;
            this.parameterType = parameterType;
        }

        public Object deserialize(JsonParser parser, DeserializationContext context) {
            ValueDeserializer deserializer = context.findNonContextualValueDeserializer(this.parameterType);
            Object nested = deserializer.deserialize(parser, context);
            try {
                return this.instantiator.apply(nested);
            }
            catch (Exception o_O) {
                RuntimeException exception = new RuntimeException(String.format("Failed to instantiate %s!", this.targetType), o_O);
                throw JacksonException.wrapWithPath((Throwable)exception, (Object)parser.currentValue(), (String)parser.currentName());
            }
        }
    }
}

