/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.jackson3;

import java.lang.reflect.AnnotatedElement;
import java.util.List;
import org.jmolecules.ddd.types.Identifier;
import org.jmolecules.ddd.types.ValueObject;
import org.springframework.core.annotation.AnnotatedElementUtils;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.databind.ser.ValueSerializerModifier;
import tools.jackson.databind.ser.std.StdSerializer;

class SingleValueWrappingTypeSerializerModifier
extends ValueSerializerModifier {
    private static final long serialVersionUID = -7923324296771766248L;

    SingleValueWrappingTypeSerializerModifier() {
    }

    public ValueSerializer<?> modifySerializer(SerializationConfig config, BeanDescription.Supplier supplier, ValueSerializer<?> serializer) {
        BeanDescription description = supplier.get();
        List properties = description.findProperties();
        if (properties.size() != 1) {
            return super.modifySerializer(config, supplier, serializer);
        }
        Class type = description.getBeanClass();
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)type, org.jmolecules.ddd.annotation.ValueObject.class) || ValueObject.class.isAssignableFrom(type) || Identifier.class.isAssignableFrom(type)) {
            return new SingleAttributeSerializer(((BeanPropertyDefinition)properties.get(0)).getAccessor());
        }
        return super.modifySerializer(config, supplier, serializer);
    }

    private static class SingleAttributeSerializer
    extends StdSerializer<Object> {
        private final AnnotatedMember member;

        public SingleAttributeSerializer(AnnotatedMember member) {
            super(Object.class);
            this.member = member;
        }

        public void serialize(Object value, JsonGenerator gen, SerializationContext provider) throws JacksonException {
            Object nested = this.member.getValue(value);
            provider.findValueSerializer(nested.getClass()).serialize(nested, gen, provider);
        }
    }
}

