/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.spring;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jmolecules.ddd.types.Identifier;
import org.springframework.beans.BeanUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public class PrimitivesToIdentifierConverter
implements ConditionalGenericConverter {
    private static final Map<Class<?>, Optional<Instantiator>> CREATORS = new ConcurrentReferenceHashMap();
    private static final Set<Class<?>> DEFAULT_PRIMITIVES = new HashSet<Class>(Arrays.asList(String.class, UUID.class));
    private static final Set<String> DEFAULT_FACTORY_METHOD_NAMES = new HashSet<String>(Arrays.asList("of"));
    private final Supplier<? extends ConversionService> conversionService;
    private Set<Class<?>> primitives;
    private Set<String> factoryMethodNames;
    private final BiFunction<Object, Executable, Object> preparer;

    public PrimitivesToIdentifierConverter(Supplier<? extends ConversionService> conversionService) {
        Assert.notNull(conversionService, (String)"ConversionService must not be null!");
        this.primitives = new HashSet(DEFAULT_PRIMITIVES);
        this.factoryMethodNames = new HashSet<String>(DEFAULT_FACTORY_METHOD_NAMES);
        this.conversionService = conversionService;
        this.preparer = this::prepareSource;
    }

    @NonNull
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.primitives.stream().map(it -> new GenericConverter.ConvertiblePair(it, Identifier.class)).collect(Collectors.toSet());
    }

    public boolean matches(TypeDescriptor source, TypeDescriptor target) {
        Class sourceType = source.getType();
        Class targetType = target.getType();
        return CREATORS.computeIfAbsent(targetType, it -> this.lookupInstantiator(sourceType, (Class<?>)it)).filter(it -> this.conversionService.get().canConvert(sourceType, it.getIdSourceType())).isPresent();
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor target) {
        if (source == null) {
            return null;
        }
        Class type = target.getType();
        Class<?> valueType = source.getClass();
        Instantiator instantiator = (Instantiator)CREATORS.computeIfAbsent(type, it -> this.lookupInstantiator(valueType, (Class<?>)it)).orElseThrow(() -> new IllegalStateException(String.format("No factory method taking a parameter of type %s on %s!", valueType.getSimpleName(), type.getSimpleName())));
        return instantiator.creator.apply(source);
    }

    private Optional<Instantiator> lookupInstantiator(Class<?> source, Class<?> target) {
        Optional<Instantiator> creatorMethod = this.detectCreatorMethod(target, source);
        return creatorMethod.isPresent() ? creatorMethod : this.detectConstructor(target, source);
    }

    private Optional<Instantiator> detectCreatorMethod(Class<?> type, Class<?> parameterType) {
        return this.factoryMethodNames.stream().flatMap(name -> this.primitives.stream().map(primitive -> new Signature((String)name, (Class<?>)primitive))).map(it -> ReflectionUtils.findMethod((Class)type, (String)((Signature)it).name, (Class[])new Class[]{((Signature)it).argumentType})).filter(it -> it != null).peek(ReflectionUtils::makeAccessible).filter(it -> this.isAssignableOrConvertable(it.getParameterTypes()[0], parameterType)).findFirst().map(it -> new Instantiator((Executable)it, param -> ReflectionUtils.invokeMethod((Method)it, (Object)parameterType, (Object[])new Object[]{this.preparer.apply(param, (Executable)it)})));
    }

    private Optional<Instantiator> detectConstructor(Class<?> type, Class<?> parameterType) {
        return Arrays.stream(type.getDeclaredConstructors()).filter(it -> it.getParameterCount() == 1).filter(it -> this.isAssignableOrConvertable(parameterType, it.getParameterTypes()[0])).peek(ReflectionUtils::makeAccessible).findFirst().map(it -> new Instantiator((Executable)it, param -> BeanUtils.instantiateClass((Constructor)it, (Object[])new Object[]{this.preparer.apply(param, (Executable)it)})));
    }

    private boolean isAssignableOrConvertable(Class<?> source, Class<?> target) {
        return source.isAssignableFrom(target) || this.conversionService.get().canConvert(source, target);
    }

    private Object prepareSource(Object value, Executable executable) {
        Class<?> sourceType = executable.getParameterTypes()[0];
        return sourceType.isInstance(value) ? value : this.conversionService.get().convert(value, TypeDescriptor.forObject((Object)value), TypeDescriptor.valueOf(sourceType));
    }

    private static final class Instantiator {
        private final Class<?> idSourceType;
        private final Function<Object, Object> creator;

        public Instantiator(Executable executable, Function<Object, Object> creator) {
            this.idSourceType = executable.getParameterTypes()[0];
            this.creator = creator;
        }

        @Generated
        public Class<?> getIdSourceType() {
            return this.idSourceType;
        }

        @Generated
        public Function<Object, Object> getCreator() {
            return this.creator;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Instantiator)) {
                return false;
            }
            Instantiator other = (Instantiator)o;
            Class<?> this$idSourceType = this.getIdSourceType();
            Class<?> other$idSourceType = other.getIdSourceType();
            if (this$idSourceType == null ? other$idSourceType != null : !this$idSourceType.equals(other$idSourceType)) {
                return false;
            }
            Function<Object, Object> this$creator = this.getCreator();
            Function<Object, Object> other$creator = other.getCreator();
            return !(this$creator == null ? other$creator != null : !this$creator.equals(other$creator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $idSourceType = this.getIdSourceType();
            result = result * 59 + ($idSourceType == null ? 43 : $idSourceType.hashCode());
            Function<Object, Object> $creator = this.getCreator();
            result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PrimitivesToIdentifierConverter.Instantiator(idSourceType=" + this.getIdSourceType() + ", creator=" + this.getCreator() + ")";
        }
    }

    private static final class Signature {
        private final String name;
        private final Class<?> argumentType;

        @Generated
        public Signature(String name, Class<?> argumentType) {
            this.name = name;
            this.argumentType = argumentType;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Class<?> getArgumentType() {
            return this.argumentType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Signature)) {
                return false;
            }
            Signature other = (Signature)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Class<?> this$argumentType = this.getArgumentType();
            Class<?> other$argumentType = other.getArgumentType();
            return !(this$argumentType == null ? other$argumentType != null : !this$argumentType.equals(other$argumentType));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Class<?> $argumentType = this.getArgumentType();
            result = result * 59 + ($argumentType == null ? 43 : $argumentType.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PrimitivesToIdentifierConverter.Signature(name=" + this.getName() + ", argumentType=" + this.getArgumentType() + ")";
        }
    }
}

