/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.spring.jpa;

import java.util.function.Supplier;
import org.jmolecules.ddd.types.AggregateRoot;
import org.jmolecules.ddd.types.Association;
import org.jmolecules.ddd.types.Identifier;
import org.jmolecules.spring.AssociationToPrimitivesConverter;
import org.jmolecules.spring.PrimitivesToAssociationConverter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.Assert;

abstract class AssociationAttributeConverter<T extends AggregateRoot<T, ID>, ID extends Identifier, S> {
    private static ConversionService CONVERSION_SERVICE = DefaultConversionService.getSharedInstance();
    protected static TypeDescriptor OBJECT_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Object.class);
    protected final PrimitivesToAssociationConverter<?> toAssociation;
    protected final AssociationToPrimitivesConverter<?> toPrimitive;
    protected final TypeDescriptor idTypeDescriptor;

    protected AssociationAttributeConverter(Class<ID> itType) {
        Assert.notNull(itType, (String)"Identifier type must not be null!");
        Supplier<ConversionService> conversionService = () -> CONVERSION_SERVICE;
        this.toAssociation = new PrimitivesToAssociationConverter(conversionService);
        this.toPrimitive = new AssociationToPrimitivesConverter(conversionService);
        ResolvableType associationType = ResolvableType.forClassWithGenerics(Association.class, (Class[])new Class[]{Object.class, itType});
        this.idTypeDescriptor = new TypeDescriptor(associationType, null, null);
    }
}

