/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.spring;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.jmolecules.ddd.types.Identifier;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public class IdentifierToPrimitivesConverter
implements ConditionalGenericConverter {
    private static final Map<Class<?>, Optional<Field>> CACHE = new ConcurrentReferenceHashMap();
    private static final List<Class<?>> DEFAULT_PRIMITIVES = Arrays.asList(UUID.class, String.class);
    private final Supplier<? extends ConversionService> conversionService;
    private Set<Class<?>> primitives;

    public IdentifierToPrimitivesConverter(Supplier<? extends ConversionService> conversionService) {
        Assert.notNull(conversionService, (String)"ConversionService must not be null!");
        this.primitives = new HashSet(DEFAULT_PRIMITIVES);
        this.conversionService = conversionService;
    }

    @NonNull
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Set.of(new GenericConverter.ConvertiblePair(Identifier.class, Object.class));
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType.getType().equals(Identifier.class) && targetType.getType().equals(String.class)) {
            return true;
        }
        return CACHE.computeIfAbsent(sourceType.getType(), it -> this.detectAndCacheIdentifierField((Class<?>)it)).filter(it -> this.isAssignableOrConvertable(it.getType(), targetType.getType())).isPresent();
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null || sourceType.equals((Object)targetType)) {
            return source;
        }
        Class<?> type = source.getClass();
        Field idField = (Field)CACHE.computeIfAbsent(type, it -> this.detectAndCacheIdentifierField(type)).orElseThrow(() -> new IllegalStateException("Unable to find identifier field on " + type + "!"));
        Object id = ReflectionUtils.getField((Field)idField, (Object)source);
        if (id == null) {
            throw new IllegalStateException(String.format("No identifier found on instance %s!", source.toString()));
        }
        if (targetType.getType().isInstance(id)) {
            return id;
        }
        return this.conversionService.get().convert(id, TypeDescriptor.forObject((Object)id), targetType);
    }

    private Optional<Field> detectAndCacheIdentifierField(Class<?> source) {
        return CACHE.computeIfAbsent(source, type -> this.detectIdentifierField(source));
    }

    private Optional<Field> detectIdentifierField(Class<?> source) {
        if (source.isInterface() || source.equals(Object.class)) {
            return Optional.empty();
        }
        Optional<Field> result = Arrays.stream(source.getDeclaredFields()).filter(it -> !Modifier.isStatic(it.getModifiers())).filter(it -> this.primitives.contains(it.getType())).peek(ReflectionUtils::makeAccessible).findFirst();
        return result.isPresent() ? result : this.detectIdentifierField(source.getSuperclass());
    }

    private boolean isAssignableOrConvertable(Class<?> source, Class<?> target) {
        return source.isAssignableFrom(target) || this.conversionService.get().canConvert(source, target);
    }
}

