/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.spring;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import org.jmolecules.ddd.types.AggregateRoot;
import org.jmolecules.ddd.types.Association;
import org.jmolecules.ddd.types.Identifier;
import org.jmolecules.spring.PrimitivesToIdentifierConverter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public class PrimitivesToAssociationConverter<T extends AggregateRoot<T, Identifier>>
implements GenericConverter {
    private static final Map<FactoryMethodKey, Method> CACHE = new ConcurrentReferenceHashMap();
    private final PrimitivesToIdentifierConverter delegate;

    public PrimitivesToAssociationConverter(Supplier<? extends ConversionService> conversionService) {
        this(new PrimitivesToIdentifierConverter(conversionService));
    }

    public PrimitivesToAssociationConverter(PrimitivesToIdentifierConverter delegate) {
        Assert.notNull((Object)delegate, (String)"PrimitivesToIdentifierConverter must not be null!");
        this.delegate = delegate;
    }

    @NonNull
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Association.class));
    }

    @Nullable
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        ResolvableType type = targetType.getResolvableType();
        Class identifierType = type.as(Association.class).getGeneric(new int[]{1}).resolve(Identifier.class);
        Identifier id = this.resolveIdentifier(source, type, identifierType);
        if (type.resolve(Object.class).equals(Association.class)) {
            return Association.forId((Identifier)id);
        }
        Class associationType = type.resolve(Association.class);
        FactoryMethodKey key = FactoryMethodKey.of(associationType, identifierType);
        Method method = CACHE.computeIfAbsent(key, it -> it.findFactoryMethod());
        return ReflectionUtils.invokeMethod((Method)method, null, (Object[])new Object[]{id});
    }

    private Identifier resolveIdentifier(Object source, ResolvableType type, Class<?> identifierType) {
        if (Identifier.class.isInstance(source)) {
            return (Identifier)Identifier.class.cast(source);
        }
        TypeDescriptor sourceDescriptor = TypeDescriptor.forObject((Object)source);
        TypeDescriptor identifierDescriptor = TypeDescriptor.valueOf(identifierType);
        return (Identifier)this.delegate.convert(source, sourceDescriptor, identifierDescriptor);
    }

    private static final class FactoryMethodKey {
        private final Class<?> type;
        private final Class<?> parameterType;

        Method findFactoryMethod() {
            Method method = ReflectionUtils.findMethod(this.type, (String)"of", (Class[])new Class[]{this.parameterType});
            ReflectionUtils.makeAccessible((Method)method);
            return method;
        }

        @Generated
        private FactoryMethodKey(Class<?> type, Class<?> parameterType) {
            this.type = type;
            this.parameterType = parameterType;
        }

        @Generated
        public static FactoryMethodKey of(Class<?> type, Class<?> parameterType) {
            return new FactoryMethodKey(type, parameterType);
        }

        @Generated
        public Class<?> getType() {
            return this.type;
        }

        @Generated
        public Class<?> getParameterType() {
            return this.parameterType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FactoryMethodKey)) {
                return false;
            }
            FactoryMethodKey other = (FactoryMethodKey)o;
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Class<?> this$parameterType = this.getParameterType();
            Class<?> other$parameterType = other.getParameterType();
            return !(this$parameterType == null ? other$parameterType != null : !this$parameterType.equals(other$parameterType));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Class<?> $parameterType = this.getParameterType();
            result = result * 59 + ($parameterType == null ? 43 : $parameterType.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PrimitivesToAssociationConverter.FactoryMethodKey(type=" + this.getType() + ", parameterType=" + this.getParameterType() + ")";
        }
    }
}

