/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.spring.config;

import java.util.function.Supplier;
import org.jmolecules.spring.AssociationToPrimitivesConverter;
import org.jmolecules.spring.IdentifierToPrimitivesConverter;
import org.jmolecules.spring.PrimitivesToAssociationConverter;
import org.jmolecules.spring.PrimitivesToIdentifierConverter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class JMoleculesWebAutoConfiguration {
    @Bean
    WebMvcConfigurer jMoleculesWebMvcConfigurer() {
        return new WebMvcConfigurer(){

            public void addFormatters(FormatterRegistry registry) {
                if (!(registry instanceof FormattingConversionService)) {
                    return;
                }
                Supplier<ConversionService> supplier = () -> (FormattingConversionService)registry;
                IdentifierToPrimitivesConverter identifierToPrimitives = new IdentifierToPrimitivesConverter(supplier);
                PrimitivesToIdentifierConverter primitivesToIdentifier = new PrimitivesToIdentifierConverter(supplier);
                registry.addConverter((GenericConverter)identifierToPrimitives);
                registry.addConverter((GenericConverter)primitivesToIdentifier);
                registry.addConverter(new PrimitivesToAssociationConverter(primitivesToIdentifier));
                registry.addConverter(new AssociationToPrimitivesConverter(identifierToPrimitives));
            }
        };
    }
}

