/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.android;

import android.opengl.GLSurfaceView;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import com.jme3.input.JoyInput;
import com.jme3.input.TouchInput;
import com.jme3.input.android.AndroidGestureProcessor;
import com.jme3.input.android.AndroidJoyInput;
import com.jme3.input.android.AndroidTouchInput;
import com.jme3.system.AppSettings;
import java.util.logging.Logger;

public class AndroidInputHandler
implements View.OnTouchListener,
View.OnKeyListener {
    private static final Logger logger = Logger.getLogger(AndroidInputHandler.class.getName());
    protected GLSurfaceView view;
    protected AndroidTouchInput touchInput = new AndroidTouchInput(this);
    protected AndroidJoyInput joyInput = new AndroidJoyInput(this);

    public void setView(View view) {
        if (this.view != null && view != null && this.view.equals(view)) {
            return;
        }
        if (this.view != null) {
            this.removeListeners(this.view);
        }
        this.view = (GLSurfaceView)view;
        if (this.view != null) {
            this.addListeners(this.view);
        }
        this.joyInput.setView((GLSurfaceView)view);
    }

    public View getView() {
        return this.view;
    }

    protected void removeListeners(GLSurfaceView view) {
        view.setOnTouchListener(null);
        view.setOnKeyListener(null);
        this.touchInput.setGestureDetector(null);
        this.touchInput.setScaleDetector(null);
    }

    protected void addListeners(GLSurfaceView view) {
        view.setOnTouchListener((View.OnTouchListener)this);
        view.setOnKeyListener((View.OnKeyListener)this);
        AndroidGestureProcessor gestureHandler = new AndroidGestureProcessor(this.touchInput);
        this.touchInput.setGestureDetector(new GestureDetector(view.getContext(), (GestureDetector.OnGestureListener)gestureHandler));
        this.touchInput.setScaleDetector(new ScaleGestureDetector(view.getContext(), (ScaleGestureDetector.OnScaleGestureListener)gestureHandler));
    }

    public void loadSettings(AppSettings settings) {
        this.touchInput.loadSettings(settings);
    }

    public TouchInput getTouchInput() {
        return this.touchInput;
    }

    public JoyInput getJoyInput() {
        return this.joyInput;
    }

    public boolean onTouch(View view, MotionEvent event) {
        boolean isTouch;
        if (view != this.getView()) {
            return false;
        }
        boolean consumed = false;
        int source = event.getSource();
        boolean bl = isTouch = (source & 0x1002) == 4098;
        if (isTouch && this.touchInput != null) {
            consumed = this.touchInput.onTouch(event);
        }
        return consumed;
    }

    public boolean onKey(View view, int keyCode, KeyEvent event) {
        boolean isTouch;
        if (view != this.getView()) {
            return false;
        }
        boolean consumed = false;
        int source = event.getSource();
        boolean bl = isTouch = (source & 0x1002) == 4098 || (source & 0x101) == 257;
        if (this.touchInput != null) {
            consumed = this.touchInput.onKey(event);
        }
        return consumed;
    }
}

