/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.android;

import android.opengl.GLSurfaceView;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import com.jme3.input.android.AndroidInputHandler;
import com.jme3.input.android.AndroidJoyInput14;
import com.jme3.input.android.AndroidTouchInput14;
import java.util.logging.Logger;

public class AndroidInputHandler14
extends AndroidInputHandler
implements View.OnHoverListener,
View.OnGenericMotionListener {
    private static final Logger logger = Logger.getLogger(AndroidInputHandler14.class.getName());

    public AndroidInputHandler14() {
        this.touchInput = new AndroidTouchInput14(this);
        this.joyInput = new AndroidJoyInput14(this);
    }

    @Override
    protected void removeListeners(GLSurfaceView view) {
        super.removeListeners(view);
        view.setOnHoverListener(null);
        view.setOnGenericMotionListener(null);
    }

    @Override
    protected void addListeners(GLSurfaceView view) {
        super.addListeners(view);
        view.setOnHoverListener((View.OnHoverListener)this);
        view.setOnGenericMotionListener((View.OnGenericMotionListener)this);
    }

    public boolean onHover(View view, MotionEvent event) {
        boolean isTouch;
        if (view != this.getView()) {
            return false;
        }
        boolean consumed = false;
        int source = event.getSource();
        boolean bl = isTouch = (source & 0x1002) == 4098;
        if (isTouch && this.touchInput != null) {
            consumed = ((AndroidTouchInput14)this.touchInput).onHover(event);
        }
        return consumed;
    }

    public boolean onGenericMotion(View view, MotionEvent event) {
        boolean isJoystick;
        if (view != this.getView()) {
            return false;
        }
        boolean consumed = false;
        int source = event.getSource();
        boolean bl = isJoystick = (source & 0x401) == 1025 || (source & 0x1000010) == 0x1000010;
        if (isJoystick && this.joyInput != null) {
            consumed = consumed || ((AndroidJoyInput14)this.joyInput).onGenericMotion(event);
        }
        return consumed;
    }

    @Override
    public boolean onKey(View view, int keyCode, KeyEvent event) {
        boolean isUnknown;
        if (view != this.getView()) {
            return false;
        }
        boolean consumed = false;
        int source = event.getSource();
        boolean isTouch = (source & 0x1002) == 4098 || (source & 0x101) == 257;
        boolean isJoystick = (source & 0x401) == 1025 || (source & 0x1000010) == 0x1000010;
        boolean bl = isUnknown = (source & 0) == 0;
        if (this.touchInput != null && (isTouch || isUnknown && this.touchInput.isSimulateKeyboard())) {
            consumed = this.touchInput.onKey(event);
        }
        if (isJoystick && this.joyInput != null) {
            consumed |= ((AndroidJoyInput14)this.joyInput).onKey(event);
        }
        return consumed;
    }
}

