/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.android;

import com.jme3.input.event.TouchEvent;
import com.jme3.util.RingBuffer;
import java.util.logging.Logger;

public class TouchEventPool {
    private static final Logger logger = Logger.getLogger(TouchEventPool.class.getName());
    private final RingBuffer<TouchEvent> eventPool;
    private final int maxEvents;

    public TouchEventPool(int maxEvents) {
        this.eventPool = new RingBuffer(maxEvents);
        this.maxEvents = maxEvents;
    }

    public void initialize() {
        while (!this.eventPool.isEmpty()) {
            this.eventPool.pop();
        }
        for (int i = 0; i < this.maxEvents; ++i) {
            TouchEvent newEvent = new TouchEvent();
            newEvent.setConsumed();
            this.eventPool.push(newEvent);
        }
    }

    public void destroy() {
        while (!this.eventPool.isEmpty()) {
            this.eventPool.pop();
        }
    }

    public TouchEvent getNextFreeEvent() {
        TouchEvent evt = null;
        for (int curSize = this.eventPool.size(); curSize > 0 && !(evt = this.eventPool.pop()).isConsumed(); --curSize) {
            this.eventPool.push(evt);
            evt = null;
        }
        if (evt == null) {
            logger.warning("eventPool full of unconsumed events");
            evt = new TouchEvent();
        }
        return evt;
    }

    public void storeEvent(TouchEvent event) {
        if (this.eventPool.size() < this.maxEvents) {
            this.eventPool.push(event);
        } else {
            logger.warning("eventPool full");
        }
    }
}

