/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.android;

import android.opengl.GLES20;
import android.opengl.GLES30;
import android.opengl.GLES31;
import com.jme3.renderer.RendererException;
import com.jme3.renderer.opengl.GL;
import com.jme3.renderer.opengl.GL2;
import com.jme3.renderer.opengl.GLES_30;
import com.jme3.renderer.opengl.GLExt;
import com.jme3.renderer.opengl.GLFbo;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class AndroidGL
implements GL,
GL2,
GLES_30,
GLExt,
GLFbo {
    IntBuffer tmpBuff = BufferUtils.createIntBuffer((int)1);
    IntBuffer tmpBuff16 = BufferUtils.createIntBuffer((int)16);

    public void resetStats() {
    }

    private static int getLimitBytes(ByteBuffer buffer) {
        AndroidGL.checkLimit(buffer);
        return buffer.limit();
    }

    private static int getLimitBytes(ShortBuffer buffer) {
        AndroidGL.checkLimit(buffer);
        return buffer.limit() * 2;
    }

    private static int getLimitBytes(IntBuffer buffer) {
        AndroidGL.checkLimit(buffer);
        return buffer.limit() * 4;
    }

    private static int getLimitBytes(FloatBuffer buffer) {
        AndroidGL.checkLimit(buffer);
        return buffer.limit() * 4;
    }

    private static int getLimitCount(Buffer buffer, int elementSize) {
        AndroidGL.checkLimit(buffer);
        return buffer.limit() / elementSize;
    }

    private static void checkLimit(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer.limit() == 0) {
            throw new RendererException("Attempting to upload empty buffer (limit = 0), that's an error");
        }
        if (buffer.remaining() == 0) {
            throw new RendererException("Attempting to upload empty buffer (remaining = 0), that's an error");
        }
    }

    public void glActiveTexture(int texture) {
        GLES20.glActiveTexture((int)texture);
    }

    public void glAttachShader(int program, int shader) {
        GLES20.glAttachShader((int)program, (int)shader);
    }

    public void glBeginQuery(int target, int query) {
        GLES30.glBeginQuery((int)target, (int)query);
    }

    public void glBindBuffer(int target, int buffer) {
        GLES20.glBindBuffer((int)target, (int)buffer);
    }

    public void glBindTexture(int target, int texture) {
        GLES20.glBindTexture((int)target, (int)texture);
    }

    public void glBlendFunc(int sfactor, int dfactor) {
        GLES20.glBlendFunc((int)sfactor, (int)dfactor);
    }

    public void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha) {
        GLES20.glBlendFuncSeparate((int)sfactorRGB, (int)dfactorRGB, (int)sfactorAlpha, (int)dfactorAlpha);
    }

    public void glBufferData(int target, FloatBuffer data, int usage) {
        GLES20.glBufferData((int)target, (int)AndroidGL.getLimitBytes(data), (Buffer)data, (int)usage);
    }

    public void glBufferData(int target, ShortBuffer data, int usage) {
        GLES20.glBufferData((int)target, (int)AndroidGL.getLimitBytes(data), (Buffer)data, (int)usage);
    }

    public void glBufferData(int target, ByteBuffer data, int usage) {
        GLES20.glBufferData((int)target, (int)AndroidGL.getLimitBytes(data), (Buffer)data, (int)usage);
    }

    public void glBufferData(int target, long dataSize, int usage) {
        GLES20.glBufferData((int)target, (int)((int)dataSize), null, (int)usage);
    }

    public void glBufferSubData(int target, long offset, FloatBuffer data) {
        GLES20.glBufferSubData((int)target, (int)((int)offset), (int)AndroidGL.getLimitBytes(data), (Buffer)data);
    }

    public void glBufferSubData(int target, long offset, ShortBuffer data) {
        GLES20.glBufferSubData((int)target, (int)((int)offset), (int)AndroidGL.getLimitBytes(data), (Buffer)data);
    }

    public void glBufferSubData(int target, long offset, ByteBuffer data) {
        GLES20.glBufferSubData((int)target, (int)((int)offset), (int)AndroidGL.getLimitBytes(data), (Buffer)data);
    }

    public void glGetBufferSubData(int target, long offset, ByteBuffer data) {
        throw new UnsupportedOperationException("OpenGL ES 2 does not support glGetBufferSubData");
    }

    public void glClear(int mask) {
        GLES20.glClear((int)mask);
    }

    public void glClearColor(float red, float green, float blue, float alpha) {
        GLES20.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GLES20.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    public void glCompileShader(int shader) {
        GLES20.glCompileShader((int)shader);
    }

    public void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, ByteBuffer data) {
        GLES20.glCompressedTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)0, (int)AndroidGL.getLimitBytes(data), (Buffer)data);
    }

    public void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        GLES20.glCompressedTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)AndroidGL.getLimitBytes(data), (Buffer)data);
    }

    public int glCreateProgram() {
        return GLES20.glCreateProgram();
    }

    public int glCreateShader(int shaderType) {
        return GLES20.glCreateShader((int)shaderType);
    }

    public void glCullFace(int mode) {
        GLES20.glCullFace((int)mode);
    }

    public void glDeleteBuffers(IntBuffer buffers) {
        AndroidGL.checkLimit(buffers);
        GLES20.glDeleteBuffers((int)buffers.limit(), (IntBuffer)buffers);
    }

    public void glDeleteProgram(int program) {
        GLES20.glDeleteProgram((int)program);
    }

    public void glDeleteShader(int shader) {
        GLES20.glDeleteShader((int)shader);
    }

    public void glDeleteTextures(IntBuffer textures) {
        AndroidGL.checkLimit(textures);
        GLES20.glDeleteTextures((int)textures.limit(), (IntBuffer)textures);
    }

    public void glDepthFunc(int func) {
        GLES20.glDepthFunc((int)func);
    }

    public void glDepthMask(boolean flag) {
        GLES20.glDepthMask((boolean)flag);
    }

    public void glDepthRange(double nearVal, double farVal) {
        GLES20.glDepthRangef((float)((float)nearVal), (float)((float)farVal));
    }

    public void glDetachShader(int program, int shader) {
        GLES20.glDetachShader((int)program, (int)shader);
    }

    public void glDisable(int cap) {
        GLES20.glDisable((int)cap);
    }

    public void glDisableVertexAttribArray(int index) {
        GLES20.glDisableVertexAttribArray((int)index);
    }

    public void glDrawArrays(int mode, int first, int count) {
        GLES20.glDrawArrays((int)mode, (int)first, (int)count);
    }

    public void glDrawRangeElements(int mode, int start, int end, int count, int type, long indices) {
        GLES20.glDrawElements((int)mode, (int)count, (int)type, (int)((int)indices));
    }

    public void glEnable(int cap) {
        GLES20.glEnable((int)cap);
    }

    public void glEnableVertexAttribArray(int index) {
        GLES20.glEnableVertexAttribArray((int)index);
    }

    public void glEndQuery(int target) {
        GLES30.glEndQuery((int)target);
    }

    public void glGenBuffers(IntBuffer buffers) {
        AndroidGL.checkLimit(buffers);
        GLES20.glGenBuffers((int)buffers.limit(), (IntBuffer)buffers);
    }

    public void glGenTextures(IntBuffer textures) {
        AndroidGL.checkLimit(textures);
        GLES20.glGenTextures((int)textures.limit(), (IntBuffer)textures);
    }

    public void glGenQueries(int num, IntBuffer buff) {
        GLES30.glGenQueries((int)num, (IntBuffer)buff);
    }

    public int glGetAttribLocation(int program, String name) {
        return GLES20.glGetAttribLocation((int)program, (String)name);
    }

    public void glGetBoolean(int pname, ByteBuffer params) {
        throw new UnsupportedOperationException("Today is not a good day for this");
    }

    public int glGetError() {
        return GLES20.glGetError();
    }

    public void glGetFloat(int parameterId, FloatBuffer storeValues) {
        AndroidGL.checkLimit(storeValues);
        GLES20.glGetFloatv((int)parameterId, (FloatBuffer)storeValues);
    }

    public void glGetInteger(int pname, IntBuffer params) {
        AndroidGL.checkLimit(params);
        GLES20.glGetIntegerv((int)pname, (IntBuffer)params);
    }

    public void glGetProgram(int program, int pname, IntBuffer params) {
        AndroidGL.checkLimit(params);
        GLES20.glGetProgramiv((int)program, (int)pname, (IntBuffer)params);
    }

    public String glGetProgramInfoLog(int program, int maxLength) {
        return GLES20.glGetProgramInfoLog((int)program);
    }

    public long glGetQueryObjectui64(int query, int pname) {
        IntBuffer buff = IntBuffer.allocate(1);
        GLES30.glGetQueryObjectuiv((int)query, (int)pname, (IntBuffer)buff);
        return buff.get(0);
    }

    public int glGetQueryObjectiv(int query, int pname) {
        IntBuffer buff = IntBuffer.allocate(1);
        GLES30.glGetQueryiv((int)query, (int)pname, (IntBuffer)buff);
        return buff.get(0);
    }

    public void glGetShader(int shader, int pname, IntBuffer params) {
        AndroidGL.checkLimit(params);
        GLES20.glGetShaderiv((int)shader, (int)pname, (IntBuffer)params);
    }

    public String glGetShaderInfoLog(int shader, int maxLength) {
        return GLES20.glGetShaderInfoLog((int)shader);
    }

    public String glGetString(int name) {
        return GLES20.glGetString((int)name);
    }

    public int glGetUniformLocation(int program, String name) {
        return GLES20.glGetUniformLocation((int)program, (String)name);
    }

    public boolean glIsEnabled(int cap) {
        return GLES20.glIsEnabled((int)cap);
    }

    public void glLineWidth(float width) {
        GLES20.glLineWidth((float)width);
    }

    public void glLinkProgram(int program) {
        GLES20.glLinkProgram((int)program);
    }

    public void glPixelStorei(int pname, int param) {
        GLES20.glPixelStorei((int)pname, (int)param);
    }

    public void glPolygonOffset(float factor, float units) {
        GLES20.glPolygonOffset((float)factor, (float)units);
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, ByteBuffer data) {
        GLES20.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (Buffer)data);
    }

    public void glScissor(int x, int y, int width, int height) {
        GLES20.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    public void glShaderSource(int shader, String[] string, IntBuffer length) {
        if (string.length != 1) {
            throw new UnsupportedOperationException("Today is not a good day");
        }
        GLES20.glShaderSource((int)shader, (String)string[0]);
    }

    public void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        GLES20.glStencilFuncSeparate((int)face, (int)func, (int)ref, (int)mask);
    }

    public void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        GLES20.glStencilOpSeparate((int)face, (int)sfail, (int)dpfail, (int)dppass);
    }

    public void glTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, ByteBuffer data) {
        GLES20.glTexImage2D((int)target, (int)level, (int)internalFormat, (int)width, (int)height, (int)0, (int)format, (int)type, (Buffer)data);
    }

    public void glTexParameterf(int target, int pname, float param) {
        GLES20.glTexParameterf((int)target, (int)pname, (float)param);
    }

    public void glTexParameteri(int target, int pname, int param) {
        GLES20.glTexParameteri((int)target, (int)pname, (int)param);
    }

    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer data) {
        GLES20.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (Buffer)data);
    }

    public void glUniform1(int location, FloatBuffer value) {
        GLES20.glUniform1fv((int)location, (int)AndroidGL.getLimitCount(value, 1), (FloatBuffer)value);
    }

    public void glUniform1(int location, IntBuffer value) {
        GLES20.glUniform1iv((int)location, (int)AndroidGL.getLimitCount(value, 1), (IntBuffer)value);
    }

    public void glUniform1f(int location, float v0) {
        GLES20.glUniform1f((int)location, (float)v0);
    }

    public void glUniform1i(int location, int v0) {
        GLES20.glUniform1i((int)location, (int)v0);
    }

    public void glUniform2(int location, IntBuffer value) {
        GLES20.glUniform2iv((int)location, (int)AndroidGL.getLimitCount(value, 2), (IntBuffer)value);
    }

    public void glUniform2(int location, FloatBuffer value) {
        GLES20.glUniform2fv((int)location, (int)AndroidGL.getLimitCount(value, 2), (FloatBuffer)value);
    }

    public void glUniform2f(int location, float v0, float v1) {
        GLES20.glUniform2f((int)location, (float)v0, (float)v1);
    }

    public void glUniform3(int location, IntBuffer value) {
        GLES20.glUniform3iv((int)location, (int)AndroidGL.getLimitCount(value, 3), (IntBuffer)value);
    }

    public void glUniform3(int location, FloatBuffer value) {
        GLES20.glUniform3fv((int)location, (int)AndroidGL.getLimitCount(value, 3), (FloatBuffer)value);
    }

    public void glUniform3f(int location, float v0, float v1, float v2) {
        GLES20.glUniform3f((int)location, (float)v0, (float)v1, (float)v2);
    }

    public void glUniform4(int location, FloatBuffer value) {
        GLES20.glUniform4fv((int)location, (int)AndroidGL.getLimitCount(value, 4), (FloatBuffer)value);
    }

    public void glUniform4(int location, IntBuffer value) {
        GLES20.glUniform4iv((int)location, (int)AndroidGL.getLimitCount(value, 4), (IntBuffer)value);
    }

    public void glUniform4f(int location, float v0, float v1, float v2, float v3) {
        GLES20.glUniform4f((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
    }

    public void glUniformMatrix3(int location, boolean transpose, FloatBuffer value) {
        GLES20.glUniformMatrix3fv((int)location, (int)AndroidGL.getLimitCount(value, 9), (boolean)transpose, (FloatBuffer)value);
    }

    public void glUniformMatrix4(int location, boolean transpose, FloatBuffer value) {
        GLES20.glUniformMatrix4fv((int)location, (int)AndroidGL.getLimitCount(value, 16), (boolean)transpose, (FloatBuffer)value);
    }

    public void glUseProgram(int program) {
        GLES20.glUseProgram((int)program);
    }

    public void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        GLES20.glVertexAttribPointer((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (int)((int)pointer));
    }

    public void glViewport(int x, int y, int width, int height) {
        GLES20.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    public void glBlitFramebufferEXT(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        GLES30.glBlitFramebuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
    }

    public void glBufferData(int target, IntBuffer data, int usage) {
        GLES20.glBufferData((int)target, (int)AndroidGL.getLimitBytes(data), (Buffer)data, (int)usage);
    }

    public void glBufferSubData(int target, long offset, IntBuffer data) {
        GLES20.glBufferSubData((int)target, (int)((int)offset), (int)AndroidGL.getLimitBytes(data), (Buffer)data);
    }

    public void glDrawArraysInstancedARB(int mode, int first, int count, int primcount) {
        GLES30.glDrawArraysInstanced((int)mode, (int)first, (int)count, (int)primcount);
    }

    public void glDrawBuffers(IntBuffer bufs) {
        GLES30.glDrawBuffers((int)bufs.limit(), (IntBuffer)bufs);
    }

    public void glDrawElementsInstancedARB(int mode, int indicesCount, int type, long indicesBufferOffset, int primcount) {
        GLES30.glDrawElementsInstanced((int)mode, (int)indicesCount, (int)type, (int)((int)indicesBufferOffset), (int)primcount);
    }

    public void glGetMultisample(int pname, int index, FloatBuffer val) {
        GLES31.glGetMultisamplefv((int)pname, (int)index, (FloatBuffer)val);
    }

    public void glRenderbufferStorageMultisampleEXT(int target, int samples, int internalformat, int width, int height) {
        GLES30.glRenderbufferStorageMultisample((int)target, (int)samples, (int)internalformat, (int)width, (int)height);
    }

    public void glTexImage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedSampleLocations) {
        GLES31.glTexStorage2DMultisample((int)target, (int)samples, (int)internalformat, (int)width, (int)height, (boolean)fixedSampleLocations);
    }

    public void glVertexAttribDivisorARB(int index, int divisor) {
        GLES30.glVertexAttribDivisor((int)index, (int)divisor);
    }

    public void glBindFramebufferEXT(int param1, int param2) {
        GLES20.glBindFramebuffer((int)param1, (int)param2);
    }

    public void glBindRenderbufferEXT(int param1, int param2) {
        GLES20.glBindRenderbuffer((int)param1, (int)param2);
    }

    public int glCheckFramebufferStatusEXT(int param1) {
        return GLES20.glCheckFramebufferStatus((int)param1);
    }

    public void glDeleteFramebuffersEXT(IntBuffer param1) {
        AndroidGL.checkLimit(param1);
        GLES20.glDeleteFramebuffers((int)param1.limit(), (IntBuffer)param1);
    }

    public void glDeleteRenderbuffersEXT(IntBuffer param1) {
        AndroidGL.checkLimit(param1);
        GLES20.glDeleteRenderbuffers((int)param1.limit(), (IntBuffer)param1);
    }

    public void glFramebufferRenderbufferEXT(int param1, int param2, int param3, int param4) {
        GLES20.glFramebufferRenderbuffer((int)param1, (int)param2, (int)param3, (int)param4);
    }

    public void glFramebufferTexture2DEXT(int param1, int param2, int param3, int param4, int param5) {
        GLES20.glFramebufferTexture2D((int)param1, (int)param2, (int)param3, (int)param4, (int)param5);
    }

    public void glGenFramebuffersEXT(IntBuffer param1) {
        AndroidGL.checkLimit(param1);
        GLES20.glGenFramebuffers((int)param1.limit(), (IntBuffer)param1);
    }

    public void glGenRenderbuffersEXT(IntBuffer param1) {
        AndroidGL.checkLimit(param1);
        GLES20.glGenRenderbuffers((int)param1.limit(), (IntBuffer)param1);
    }

    public void glGenerateMipmapEXT(int param1) {
        GLES20.glGenerateMipmap((int)param1);
    }

    public void glRenderbufferStorageEXT(int param1, int param2, int param3, int param4) {
        GLES20.glRenderbufferStorage((int)param1, (int)param2, (int)param3, (int)param4);
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, long offset) {
        GLES20.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, null);
    }

    public int glClientWaitSync(Object sync, int flags, long timeout) {
        throw new UnsupportedOperationException("OpenGL ES 2 does not support sync fences");
    }

    public void glDeleteSync(Object sync) {
        throw new UnsupportedOperationException("OpenGL ES 2 does not support sync fences");
    }

    public Object glFenceSync(int condition, int flags) {
        throw new UnsupportedOperationException("OpenGL ES 2 does not support sync fences");
    }

    public void glBlendEquationSeparate(int colorMode, int alphaMode) {
        GLES20.glBlendEquationSeparate((int)colorMode, (int)alphaMode);
    }

    public void glFramebufferTextureLayerEXT(int target, int attachment, int texture, int level, int layer) {
        GLES30.glFramebufferTextureLayer((int)target, (int)attachment, (int)texture, (int)level, (int)layer);
    }

    public void glAlphaFunc(int func, float ref) {
    }

    public void glPointSize(float size) {
    }

    public void glPolygonMode(int face, int mode) {
    }

    public void glDrawBuffer(int mode) {
        int nBuffers = mode - 36064 + 1;
        if (nBuffers <= 0 || nBuffers > 16) {
            throw new IllegalArgumentException("Draw buffer outside range: " + Integer.toHexString(mode));
        }
        this.tmpBuff16.clear();
        for (int i = 0; i < nBuffers - 1; ++i) {
            this.tmpBuff16.put(0);
        }
        this.tmpBuff16.put(mode);
        this.tmpBuff16.flip();
        this.glDrawBuffers(this.tmpBuff16);
    }

    public void glReadBuffer(int mode) {
        GLES30.glReadBuffer((int)mode);
    }

    public void glCompressedTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, ByteBuffer data) {
        GLES30.glCompressedTexImage3D((int)target, (int)level, (int)internalFormat, (int)width, (int)height, (int)depth, (int)border, (int)AndroidGL.getLimitBytes(data), (Buffer)data);
    }

    public void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        GLES30.glCompressedTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)AndroidGL.getLimitBytes(data), (Buffer)data);
    }

    public void glTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, ByteBuffer data) {
        GLES30.glTexImage3D((int)target, (int)level, (int)internalFormat, (int)width, (int)height, (int)depth, (int)border, (int)format, (int)type, (Buffer)data);
    }

    public void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer data) {
        GLES30.glTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (Buffer)data);
    }

    public void glBindVertexArray(int array) {
        GLES30.glBindVertexArray((int)array);
    }

    public void glDeleteVertexArrays(IntBuffer arrays) {
        GLES30.glDeleteVertexArrays((int)arrays.limit(), (IntBuffer)arrays);
    }

    public void glGenVertexArrays(IntBuffer arrays) {
        GLES30.glGenVertexArrays((int)arrays.limit(), (IntBuffer)arrays);
    }
}

