/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.android;

import android.app.AlertDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.android.AndroidAL;
import com.jme3.audio.android.AndroidALC;
import com.jme3.audio.android.AndroidEFX;
import com.jme3.audio.openal.AL;
import com.jme3.audio.openal.ALAudioRenderer;
import com.jme3.audio.openal.ALC;
import com.jme3.audio.openal.EFX;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.JmeSystemDelegate;
import com.jme3.system.Platform;
import com.jme3.system.android.OGLESContext;
import com.jme3.util.AndroidScreenshots;
import com.jme3.util.res.Resources;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class JmeAndroidSystem
extends JmeSystemDelegate {
    private static View view;
    private static String audioRendererType;

    public JmeAndroidSystem() {
        this.setErrorMessageHandler(message -> {
            String finalMsg = message;
            String finalTitle = "Error in application";
            Context context = JmeAndroidSystem.getView().getContext();
            view.getHandler().post(() -> {
                AlertDialog dialog = new AlertDialog.Builder(context).setTitle((CharSequence)finalTitle).setMessage((CharSequence)finalMsg).create();
                dialog.show();
            });
        });
    }

    public URL getPlatformAssetConfigURL() {
        return Resources.getResource((String)"com/jme3/asset/Android.cfg");
    }

    public void writeImageFile(OutputStream outStream, String format, ByteBuffer imageData, int width, int height) throws IOException {
        Bitmap.CompressFormat compressFormat;
        Bitmap bitmapImage = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        AndroidScreenshots.convertScreenShot(imageData, bitmapImage);
        if (format.equals("png")) {
            compressFormat = Bitmap.CompressFormat.PNG;
        } else if (format.equals("jpg")) {
            compressFormat = Bitmap.CompressFormat.JPEG;
        } else {
            throw new UnsupportedOperationException("Only 'png' and 'jpg' formats are supported on Android");
        }
        bitmapImage.compress(compressFormat, 95, outStream);
        bitmapImage.recycle();
    }

    public JmeContext newContext(AppSettings settings, JmeContext.Type contextType) {
        if (settings.getAudioRenderer().equals("MediaPlayer")) {
            audioRendererType = "MediaPlayer";
        } else if (settings.getAudioRenderer().equals("OpenAL_SOFT")) {
            audioRendererType = "OpenAL_SOFT";
        } else {
            this.logger.log(Level.INFO, "AudioRenderer not set. Defaulting to OpenAL Soft");
            audioRendererType = "OpenAL_SOFT";
        }
        this.initialize(settings);
        OGLESContext ctx = new OGLESContext();
        ctx.setSettings(settings);
        return ctx;
    }

    public AudioRenderer newAudioRenderer(AppSettings settings) {
        AndroidALC alc = new AndroidALC();
        AndroidAL al = new AndroidAL();
        AndroidEFX efx = new AndroidEFX();
        return new ALAudioRenderer((AL)al, (ALC)alc, (EFX)efx);
    }

    public void initialize(AppSettings settings) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        System.setProperty("org.xml.sax.driver", "org.xmlpull.v1.sax2.Driver");
        this.logger.log(Level.INFO, this.getBuildInfo());
    }

    public Platform getPlatform() {
        String arch = System.getProperty("os.arch").toLowerCase();
        if (arch.contains("arm")) {
            if (arch.contains("v5")) {
                return Platform.Android_ARM5;
            }
            if (arch.contains("v6")) {
                return Platform.Android_ARM6;
            }
            if (arch.contains("v7")) {
                return Platform.Android_ARM7;
            }
            if (arch.contains("v8")) {
                return Platform.Android_ARM8;
            }
            return Platform.Android_ARM5;
        }
        if (arch.contains("aarch")) {
            return Platform.Android_ARM8;
        }
        return Platform.Android_Other;
    }

    public synchronized File getStorageFolder(JmeSystem.StorageFolderType type) {
        File storageFolder = null;
        switch (type) {
            case Internal: {
                storageFolder = (File)this.storageFolders.get(type);
                if (storageFolder != null) break;
                storageFolder = view.getContext().getDir("", 0);
                this.storageFolders.put(type, storageFolder);
                break;
            }
            case External: {
                storageFolder = (File)this.storageFolders.get(type);
                if (storageFolder != null) break;
                String state = Environment.getExternalStorageState();
                this.logger.log(Level.FINE, "ExternalStorageState: {0}", state);
                if (!state.equals("mounted")) break;
                storageFolder = view.getContext().getExternalFilesDir(null);
                this.storageFolders.put(type, storageFolder);
                break;
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            if (storageFolder != null) {
                this.logger.log(Level.FINE, "Base Storage Folder Path: {0}", storageFolder.getAbsolutePath());
            } else {
                this.logger.log(Level.FINE, "Base Storage Folder not found!");
            }
        }
        return storageFolder;
    }

    public static void setView(View view) {
        JmeAndroidSystem.view = view;
    }

    public static View getView() {
        return view;
    }

    public static String getAudioRendererType() {
        return audioRendererType;
    }

    public void showSoftKeyboard(final boolean show) {
        view.getHandler().post(new Runnable(){

            @Override
            public void run() {
                InputMethodManager manager = (InputMethodManager)view.getContext().getSystemService("input_method");
                if (show) {
                    manager.showSoftInput(view, 0);
                } else {
                    manager.hideSoftInputFromWindow(view.getWindowToken(), 0);
                }
            }
        });
    }

    static {
        audioRendererType = "OpenAL_SOFT";
        try {
            System.loadLibrary("bulletjme");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }
}

