/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.android;

import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.pm.ConfigurationInfo;
import android.graphics.Rect;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.EditText;
import android.widget.FrameLayout;
import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.SoftTextDialogInput;
import com.jme3.input.TouchInput;
import com.jme3.input.android.AndroidInputHandler;
import com.jme3.input.android.AndroidInputHandler14;
import com.jme3.input.controls.SoftTextDialogInputListener;
import com.jme3.input.dummy.DummyKeyInput;
import com.jme3.input.dummy.DummyMouseInput;
import com.jme3.opencl.Context;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.android.AndroidGL;
import com.jme3.renderer.opengl.GL;
import com.jme3.renderer.opengl.GL2;
import com.jme3.renderer.opengl.GLDebug;
import com.jme3.renderer.opengl.GLES_30;
import com.jme3.renderer.opengl.GLExt;
import com.jme3.renderer.opengl.GLFbo;
import com.jme3.renderer.opengl.GLRenderer;
import com.jme3.renderer.opengl.GLTracer;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.NanoTimer;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import com.jme3.system.android.AndroidConfigChooser;
import com.jme3.system.android.JmeAndroidSystem;
import com.jme3.util.PrimitiveAllocator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class OGLESContext
implements JmeContext,
GLSurfaceView.Renderer,
SoftTextDialogInput {
    private static final Logger logger = Logger.getLogger(OGLESContext.class.getName());
    protected final AtomicBoolean created = new AtomicBoolean(false);
    protected final AtomicBoolean renderable = new AtomicBoolean(false);
    protected final AtomicBoolean needClose = new AtomicBoolean(false);
    protected AppSettings settings = new AppSettings(true);
    protected GLRenderer renderer;
    protected Timer timer;
    protected SystemListener listener;
    protected boolean autoFlush = true;
    protected AndroidInputHandler androidInput;
    protected long minFrameDuration = 0L;
    protected long lastUpdateTime = 0L;

    public JmeContext.Type getType() {
        return JmeContext.Type.Display;
    }

    public GLSurfaceView createView(android.content.Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ConfigurationInfo info = am.getDeviceConfigurationInfo();
        if (Build.VERSION.SDK_INT < 14) {
            if (info.reqGlEsVersion < 131072) {
                throw new UnsupportedOperationException("OpenGL ES 2.0 or better is not supported on this device");
            }
        } else if (Build.VERSION.SDK_INT < 9) {
            throw new UnsupportedOperationException("jME3 requires Android 2.3 or later");
        }
        GLSurfaceView view = new GLSurfaceView(context);
        logger.log(Level.INFO, "Android Build Version: {0}", Build.VERSION.SDK_INT);
        if (this.androidInput == null) {
            if (Build.VERSION.SDK_INT >= 14) {
                this.androidInput = new AndroidInputHandler14();
            } else if (Build.VERSION.SDK_INT >= 9) {
                this.androidInput = new AndroidInputHandler();
            }
        }
        this.androidInput.setView((View)view);
        this.androidInput.loadSettings(this.settings);
        view.setEGLContextClientVersion(info.reqGlEsVersion >> 16);
        view.setFocusableInTouchMode(true);
        view.setFocusable(true);
        int curAlphaBits = this.settings.getAlphaBits();
        logger.log(Level.FINE, "curAlphaBits: {0}", curAlphaBits);
        if (curAlphaBits >= 8) {
            logger.log(Level.FINE, "Pixel Format: TRANSLUCENT");
            view.getHolder().setFormat(-3);
            view.setZOrderOnTop(true);
        } else if (curAlphaBits >= 1) {
            logger.log(Level.FINE, "Pixel Format: TRANSPARENT");
            view.getHolder().setFormat(-2);
        } else {
            logger.log(Level.FINE, "Pixel Format: OPAQUE");
            view.getHolder().setFormat(-1);
        }
        AndroidConfigChooser configChooser = new AndroidConfigChooser(this.settings);
        view.setEGLConfigChooser((GLSurfaceView.EGLConfigChooser)configChooser);
        view.setRenderer((GLSurfaceView.Renderer)this);
        if (Build.VERSION.SDK_INT >= 11) {
            view.setPreserveEGLContextOnPause(true);
        }
        return view;
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig cfg) {
        if (this.created.get() && this.renderer != null) {
            this.renderer.resetGLObjects();
        } else if (!this.created.get()) {
            logger.fine("GL Surface created, initializing JME3 renderer");
            this.initInThread();
        } else {
            logger.warning("GL Surface already created");
        }
    }

    protected void initInThread() {
        this.created.set(true);
        logger.fine("OGLESContext create");
        logger.log(Level.FINE, "Running on thread: {0}", Thread.currentThread().getName());
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable thrown) {
                OGLESContext.this.listener.handleError("Exception thrown in " + thread.toString(), thrown);
            }
        });
        this.timer = new NanoTimer();
        AndroidGL gl = new AndroidGL();
        if (this.settings.getBoolean("GraphicsDebug")) {
            gl = (GL)GLDebug.createProxy((GL)gl, (Object)gl, (Class[])new Class[]{GL.class, GL2.class, GLES_30.class, GLFbo.class, GLExt.class});
        }
        if (this.settings.getBoolean("GraphicsTrace")) {
            gl = (GL)GLTracer.createGlesTracer((Object)gl, (Class[])new Class[]{GL.class, GLES_30.class, GLFbo.class, GLExt.class});
        }
        this.renderer = new GLRenderer((GL)gl, (GLExt)gl, (GLFbo)gl);
        this.renderer.initialize();
        JmeSystem.setSoftTextDialogInput((SoftTextDialogInput)this);
        this.needClose.set(false);
    }

    protected void deinitInThread() {
        if (this.renderable.get()) {
            this.created.set(false);
            if (this.renderer != null) {
                this.renderer.cleanup();
            }
            this.listener.destroy();
            this.listener = null;
            this.renderer = null;
            this.timer = null;
            logger.fine("Display destroyed.");
            this.renderable.set(false);
        }
    }

    public void setSettings(AppSettings settings) {
        this.settings.copyFrom(settings);
        if (this.androidInput != null) {
            this.androidInput.loadSettings(settings);
        }
        if (settings.getFrameRate() > 0) {
            this.minFrameDuration = (long)(1000.0 / (double)settings.getFrameRate());
            logger.log(Level.FINE, "Setting min tpf: {0}ms", this.minFrameDuration);
        } else {
            this.minFrameDuration = 0L;
        }
    }

    public SystemListener getSystemListener() {
        return this.listener;
    }

    public void setSystemListener(SystemListener listener) {
        this.listener = listener;
    }

    public AppSettings getSettings() {
        return this.settings;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public MouseInput getMouseInput() {
        return new DummyMouseInput();
    }

    public KeyInput getKeyInput() {
        return new DummyKeyInput();
    }

    public JoyInput getJoyInput() {
        return this.androidInput.getJoyInput();
    }

    public TouchInput getTouchInput() {
        return this.androidInput.getTouchInput();
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTitle(String title) {
    }

    public boolean isCreated() {
        return this.created.get();
    }

    public void setAutoFlushFrames(boolean enabled) {
        this.autoFlush = enabled;
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "GL Surface changed, width: {0} height: {1}", new Object[]{width, height});
        }
        this.settings.setResolution(width, height);
        this.androidInput.loadSettings(this.settings);
        if (this.renderable.get()) {
            logger.log(Level.FINE, "App already initialized, calling reshape");
            this.listener.reshape(width, height);
        }
    }

    public void onDrawFrame(GL10 gl) {
        if (this.needClose.get()) {
            this.deinitInThread();
            return;
        }
        if (!this.renderable.get()) {
            if (this.created.get()) {
                logger.fine("GL Surface is setup, initializing application");
                this.listener.initialize();
                this.renderable.set(true);
            }
        } else {
            long updateDelta;
            if (!this.created.get()) {
                throw new IllegalStateException("onDrawFrame without create");
            }
            this.listener.update();
            if (this.autoFlush) {
                this.renderer.postFrame();
            }
            if ((updateDelta = System.currentTimeMillis() - this.lastUpdateTime) < this.minFrameDuration) {
                try {
                    Thread.sleep(this.minFrameDuration - updateDelta);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }

    public boolean isRenderable() {
        return this.renderable.get();
    }

    public void create(boolean waitFor) {
        if (waitFor) {
            this.waitFor(true);
        }
    }

    public void create() {
        this.create(false);
    }

    public void restart() {
    }

    public void destroy(boolean waitFor) {
        this.needClose.set(true);
        if (waitFor) {
            this.waitFor(false);
        }
    }

    public void destroy() {
        this.destroy(true);
    }

    protected void waitFor(boolean createdVal) {
        while (this.renderable.get() != createdVal) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void requestDialog(final int id, final String title, final String initialValue, final SoftTextDialogInputListener listener) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "requestDialog: title: {0}, initialValue: {1}", new Object[]{title, initialValue});
        }
        final View view = JmeAndroidSystem.getView();
        view.getHandler().post(new Runnable(){

            @Override
            public void run() {
                FrameLayout layoutTextDialogInput = new FrameLayout(view.getContext());
                final EditText editTextDialogInput = new EditText(view.getContext());
                editTextDialogInput.setWidth(-1);
                editTextDialogInput.setHeight(-1);
                editTextDialogInput.setPadding(20, 20, 20, 20);
                editTextDialogInput.setGravity(7);
                editTextDialogInput.setText((CharSequence)initialValue);
                switch (id) {
                    case 0: {
                        editTextDialogInput.setInputType(1);
                        break;
                    }
                    case 1: {
                        editTextDialogInput.setInputType(12290);
                        break;
                    }
                    case 2: {
                        editTextDialogInput.setInputType(3);
                        break;
                    }
                }
                layoutTextDialogInput.addView((View)editTextDialogInput);
                AlertDialog dialogTextInput = new AlertDialog.Builder(view.getContext()).setTitle((CharSequence)title).setView((View)layoutTextDialogInput).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        listener.onSoftText(0, editTextDialogInput.getText().toString());
                    }
                }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        listener.onSoftText(1, editTextDialogInput.getText().toString());
                    }
                }).create();
                dialogTextInput.show();
            }
        });
    }

    public Context getOpenCLContext() {
        logger.warning("OpenCL is not yet supported on android");
        return null;
    }

    public int getFramebufferHeight() {
        Rect rect = this.getSurfaceFrame();
        int result = rect.height();
        return result;
    }

    public int getFramebufferWidth() {
        Rect rect = this.getSurfaceFrame();
        int result = rect.width();
        return result;
    }

    public int getWindowXPosition() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public int getWindowYPosition() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    private Rect getSurfaceFrame() {
        SurfaceView view = (SurfaceView)this.androidInput.getView();
        SurfaceHolder holder = view.getHolder();
        Rect result = holder.getSurfaceFrame();
        return result;
    }

    static {
        String implementation = "com.jme3.BufferAllocatorImplementation";
        if (System.getProperty("com.jme3.BufferAllocatorImplementation") == null) {
            System.setProperty("com.jme3.BufferAllocatorImplementation", PrimitiveAllocator.class.getName());
        }
    }
}

