/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.TextureKey;
import com.jme3.texture.Image;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class AndroidBufferImageLoader
implements AssetLoader {
    private final byte[] tempData = new byte[16384];

    private static void convertARGBtoABGR(int[] src, int srcOff, int[] dst, int dstOff, int length) {
        for (int i = 0; i < length; ++i) {
            int abgr;
            int argb = src[srcOff + i];
            int a = argb & 0xFF000000;
            int b = (argb & 0xFF) << 16;
            int g = argb & 0xFF00;
            int r = (argb & 0xFF0000) >> 16;
            dst[dstOff + i] = abgr = a | b | g | r;
        }
    }

    public Object load(AssetInfo assetInfo) throws IOException {
        int bpp;
        Image.Format format;
        Bitmap bitmap;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferQualityOverSpeed = false;
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        options.inTempStorage = this.tempData;
        options.inScaled = false;
        options.inDither = false;
        options.inInputShareable = true;
        options.inPurgeable = true;
        options.inSampleSize = 1;
        options.inPremultiplied = false;
        try (BufferedInputStream bin = new BufferedInputStream(assetInfo.openStream());){
            bitmap = BitmapFactory.decodeStream((InputStream)bin, null, (BitmapFactory.Options)options);
            if (bitmap == null) {
                throw new IOException("Failed to load image: " + assetInfo.getKey().getName());
            }
        }
        switch (bitmap.getConfig()) {
            case ALPHA_8: {
                format = Image.Format.Alpha8;
                bpp = 1;
                break;
            }
            case ARGB_8888: {
                format = Image.Format.RGBA8;
                bpp = 4;
                break;
            }
            case RGB_565: {
                format = Image.Format.RGB565;
                bpp = 2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized Android bitmap format: " + bitmap.getConfig());
            }
        }
        TextureKey texKey = (TextureKey)assetInfo.getKey();
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        ByteBuffer data = BufferUtils.createByteBuffer((int)(bitmap.getWidth() * bitmap.getHeight() * bpp));
        if (format == Image.Format.RGBA8) {
            int[] pixelData = new int[width * height];
            bitmap.getPixels(pixelData, 0, width, 0, 0, width, height);
            if (texKey.isFlipY()) {
                int[] sln = new int[width];
                for (int y1 = 0; y1 < height / 2; ++y1) {
                    int y2 = height - y1 - 1;
                    AndroidBufferImageLoader.convertARGBtoABGR(pixelData, y1 * width, sln, 0, width);
                    AndroidBufferImageLoader.convertARGBtoABGR(pixelData, y2 * width, pixelData, y1 * width, width);
                    System.arraycopy(sln, 0, pixelData, y2 * width, width);
                }
            } else {
                AndroidBufferImageLoader.convertARGBtoABGR(pixelData, 0, pixelData, 0, pixelData.length);
            }
            data.asIntBuffer().put(pixelData);
        } else {
            if (texKey.isFlipY()) {
                Matrix flipMat = new Matrix();
                flipMat.preScale(1.0f, -1.0f);
                Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)flipMat, (boolean)false);
                bitmap.recycle();
                bitmap = newBitmap;
                if (bitmap == null) {
                    throw new IOException("Failed to flip image: " + texKey);
                }
            }
            bitmap.copyPixelsToBuffer((Buffer)data);
        }
        data.flip();
        bitmap.recycle();
        Image image = new Image(format, width, height, data, ColorSpace.sRGB);
        return image;
    }
}

