/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import android.util.Log;
import com.jme3.util.JmeFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class AndroidLogHandler
extends Handler {
    private static final Formatter JME_FORMATTER = new JmeFormatter(){
        String lineSeperator = System.getProperty("line.separator");

        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append(record.getLevel().getLocalizedName()).append(" ");
            sb.append(this.formatMessage(record)).append(this.lineSeperator);
            if (record.getThrown() != null) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sb.append(sw.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return sb.toString();
        }
    };

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        int level = AndroidLogHandler.getAndroidLevel(record.getLevel());
        String tag = record.getLoggerName();
        try {
            String message = JME_FORMATTER.format(record);
            Log.println((int)level, (String)tag, (String)message);
        }
        catch (RuntimeException e) {
            Log.e((String)"AndroidHandler", (String)"Error logging message.", (Throwable)e);
        }
    }

    static int getAndroidLevel(Level level) {
        int value = level.intValue();
        if (value >= 1000) {
            return 6;
        }
        if (value >= 900) {
            return 5;
        }
        if (value >= 800) {
            return 4;
        }
        return 3;
    }

    public static String loggerNameToTag(String loggerName) {
        if (loggerName == null) {
            return "null";
        }
        int length = loggerName.length();
        int lastPeriod = loggerName.lastIndexOf(".");
        if (lastPeriod == -1) {
            return loggerName;
        }
        return loggerName.substring(lastPeriod + 1);
    }
}

