/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class RingBuffer<T>
implements Iterable<T> {
    private T[] buffer;
    private int count = 0;
    private int indexOut = 0;
    private int indexIn = 0;

    public RingBuffer(int capacity) {
        this.buffer = new Object[capacity];
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int size() {
        return this.count;
    }

    public void push(T item) {
        if (this.count == this.buffer.length) {
            throw new RuntimeException("Ring buffer overflow");
        }
        this.buffer[this.indexIn] = item;
        this.indexIn = (this.indexIn + 1) % this.buffer.length;
        ++this.count;
    }

    public T pop() {
        if (this.isEmpty()) {
            throw new RuntimeException("Ring buffer underflow");
        }
        T item = this.buffer[this.indexOut];
        this.buffer[this.indexOut] = null;
        --this.count;
        this.indexOut = (this.indexOut + 1) % this.buffer.length;
        return item;
    }

    @Override
    public Iterator<T> iterator() {
        return new RingBufferIterator();
    }

    private class RingBufferIterator
    implements Iterator<T> {
        private int i = 0;

        private RingBufferIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < RingBuffer.this.count;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return RingBuffer.this.buffer[this.i++];
        }
    }
}

