/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.view.surfaceview;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ConfigurationInfo;
import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.jme3.app.LegacyApplication;
import com.jme3.audio.AudioRenderer;
import com.jme3.input.JoyInput;
import com.jme3.input.android.AndroidSensorJoyInput;
import com.jme3.system.AppSettings;
import com.jme3.system.SystemListener;
import com.jme3.system.android.JmeAndroidSystem;
import com.jme3.system.android.OGLESContext;
import com.jme3.view.surfaceview.OnExceptionThrown;
import com.jme3.view.surfaceview.OnLayoutDrawn;
import com.jme3.view.surfaceview.OnRendererCompleted;
import com.jme3.view.surfaceview.OnRendererStarted;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmeSurfaceView
extends RelativeLayout
implements SystemListener,
DialogInterface.OnClickListener,
LifecycleEventObserver {
    private static final Logger jmeSurfaceViewLogger = Logger.getLogger(JmeSurfaceView.class.getName());
    protected String audioRendererType = "OpenAL_SOFT";
    private LegacyApplication legacyApplication;
    private AppSettings appSettings;
    private int eglBitsPerPixel = 24;
    private int eglAlphaBits = 0;
    private int eglDepthBits = 16;
    private int eglSamples = 0;
    private int eglStencilBits = 0;
    private int frameRate = -1;
    private boolean emulateKeyBoard = true;
    private boolean emulateMouse = true;
    private boolean useJoyStickEvents = true;
    private boolean isGLThreadPaused;
    private GLSurfaceView glSurfaceView;
    private OGLESContext oglesContext;
    private ConfigurationInfo configurationInfo;
    private OnRendererCompleted onRendererCompleted;
    private OnRendererStarted onRendererStarted;
    private OnExceptionThrown onExceptionThrown;
    private OnLayoutDrawn onLayoutDrawn;
    private Handler handler = new Handler();
    private RendererThread rendererThread = new RendererThread();
    private StringWriter crashLogWriter = new StringWriter(150);
    private boolean showErrorDialog = true;
    private boolean bindAppState = true;
    private boolean showEscExitPrompt = true;
    private boolean exitOnEscPressed = true;
    private DestructionPolicy destructionPolicy = DestructionPolicy.DESTROY_WHEN_FINISH;
    private String crashLog = "";
    private String glEsVersion = "";

    public JmeSurfaceView(@NonNull Context context) {
        super(context);
        this.bindAppStateToActivityLifeCycle(this.bindAppState);
    }

    public JmeSurfaceView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.bindAppStateToActivityLifeCycle(this.bindAppState);
    }

    public JmeSurfaceView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.bindAppStateToActivityLifeCycle(this.bindAppState);
    }

    public JmeSurfaceView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.bindAppStateToActivityLifeCycle(this.bindAppState);
    }

    public void startRenderer(int delayMillis) {
        delayMillis = Math.max(0, delayMillis);
        this.configurationInfo = ((ActivityManager)this.getContext().getSystemService("activity")).getDeviceConfigurationInfo();
        this.glEsVersion = "GL_ES Version : " + this.configurationInfo.getGlEsVersion();
        if (this.legacyApplication == null) {
            throw new IllegalStateException("Cannot build a SurfaceView for a null app, make sure to use setLegacyApplication() to pass in your app !");
        }
        this.appSettings = new AppSettings(true);
        this.appSettings.setAudioRenderer(this.audioRendererType);
        this.appSettings.setResolution(this.getLayoutParams().width, this.getLayoutParams().height);
        this.appSettings.setAlphaBits(this.eglAlphaBits);
        this.appSettings.setDepthBits(this.eglDepthBits);
        this.appSettings.setSamples(this.eglSamples);
        this.appSettings.setStencilBits(this.eglStencilBits);
        this.appSettings.setBitsPerPixel(this.eglBitsPerPixel);
        this.appSettings.setEmulateKeyboard(this.emulateKeyBoard);
        this.appSettings.setEmulateMouse(this.emulateMouse);
        this.appSettings.setUseJoysticks(this.useJoyStickEvents);
        if (GameState.getLegacyApplication() != null) {
            this.legacyApplication = GameState.getLegacyApplication();
            jmeSurfaceViewLogger.log(Level.INFO, "Old game state has been assigned as the current game state, skipping the first update");
        } else {
            this.legacyApplication.setSettings(this.appSettings);
            jmeSurfaceViewLogger.log(Level.INFO, "Starting a new Game State");
            this.legacyApplication.start();
            if (this.onRendererStarted != null) {
                this.onRendererStarted.onRenderStart(this.legacyApplication, (View)this);
            }
        }
        this.oglesContext = (OGLESContext)this.legacyApplication.getContext();
        this.glSurfaceView = this.oglesContext.createView(this.getContext());
        JmeAndroidSystem.setView((View)this);
        this.oglesContext.setSystemListener(this);
        this.glSurfaceView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(this.getLayoutParams().width, this.getLayoutParams().height));
        if (GameState.getLegacyApplication() != null) {
            this.addGlSurfaceView();
        } else {
            this.handler.postDelayed((Runnable)this.rendererThread, (long)delayMillis);
        }
    }

    private void removeGLSurfaceView() {
        ((Activity)this.getContext()).runOnUiThread(() -> {
            if (this.glSurfaceView != null) {
                this.removeView((View)this.glSurfaceView);
            }
        });
    }

    public void handleError(String errorMsg, Throwable throwable) {
        throwable.printStackTrace();
        this.showErrorDialog(throwable, throwable.getClass().getName());
        if (this.onExceptionThrown != null) {
            this.onExceptionThrown.onExceptionThrown(throwable);
        }
    }

    public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
        switch (event) {
            case ON_DESTROY: {
                if (this.destructionPolicy != DestructionPolicy.DESTROY_WHEN_FINISH) break;
                this.legacyApplication.stop(!this.isGLThreadPaused());
                break;
            }
            case ON_PAUSE: {
                this.loseFocus();
                break;
            }
            case ON_RESUME: {
                this.gainFocus();
                break;
            }
            case ON_STOP: {
                jmeSurfaceViewLogger.log(Level.INFO, "Context stops, but game is still running");
            }
        }
    }

    public void initialize() {
        if (this.legacyApplication == null) {
            return;
        }
        this.legacyApplication.initialize();
        jmeSurfaceViewLogger.log(Level.INFO, "JmeGame started in GLThread Asynchronously.......");
    }

    public void reshape(int width, int height) {
        if (this.legacyApplication == null) {
            return;
        }
        this.legacyApplication.reshape(width, height);
        jmeSurfaceViewLogger.log(Level.INFO, "Requested reshaping from the system listener");
    }

    public void rescale(float x, float y) {
        if (this.legacyApplication == null) {
            return;
        }
        this.legacyApplication.rescale(x, y);
        jmeSurfaceViewLogger.log(Level.INFO, "Requested rescaling from the system listener");
    }

    public void update() {
        if (this.legacyApplication == null || this.glSurfaceView == null) {
            return;
        }
        this.legacyApplication.update();
        if (!GameState.isFirstUpdatePassed()) {
            ((Activity)this.getContext()).runOnUiThread(() -> {
                jmeSurfaceViewLogger.log(Level.INFO, "User delay finishes with 0 errors");
                if (this.onRendererCompleted != null) {
                    this.onRendererCompleted.onRenderCompletion(this.legacyApplication, this.legacyApplication.getContext().getSettings());
                }
            });
            GameState.setFirstUpdatePassed(true);
        }
    }

    public void requestClose(boolean esc) {
        if (this.legacyApplication == null || !this.isExitOnEscPressed()) {
            return;
        }
        if (this.isShowEscExitPrompt()) {
            AlertDialog alertDialog = new AlertDialog.Builder(this.getContext()).create();
            alertDialog.setTitle((CharSequence)"Exit Prompt");
            alertDialog.setMessage((CharSequence)"Are you sure you want to quit ?");
            alertDialog.setCancelable(false);
            alertDialog.setButton(-2, (CharSequence)"No", (dialogInterface, i) -> alertDialog.dismiss());
            alertDialog.setButton(-1, (CharSequence)"Yes", (dialogInterface, i) -> this.legacyApplication.requestClose(esc));
            alertDialog.show();
        } else {
            this.legacyApplication.requestClose(esc);
        }
    }

    public void gainFocus() {
        if (this.legacyApplication == null || this.glSurfaceView == null) {
            return;
        }
        this.glSurfaceView.onResume();
        AudioRenderer audioRenderer = this.legacyApplication.getAudioRenderer();
        if (audioRenderer != null) {
            audioRenderer.resumeAll();
        }
        if (this.legacyApplication.getContext() != null) {
            JoyInput joyInput = this.legacyApplication.getContext().getJoyInput();
            if (joyInput != null && joyInput instanceof AndroidSensorJoyInput) {
                AndroidSensorJoyInput androidJoyInput = (AndroidSensorJoyInput)joyInput;
                androidJoyInput.resumeSensors();
            }
            this.legacyApplication.gainFocus();
        }
        this.setGLThreadPaused(false);
        jmeSurfaceViewLogger.log(Level.INFO, "Game returns from the idle mode");
    }

    public void loseFocus() {
        JoyInput joyInput;
        if (this.legacyApplication == null || this.glSurfaceView == null) {
            return;
        }
        this.glSurfaceView.onPause();
        this.legacyApplication.loseFocus();
        AudioRenderer audioRenderer = this.legacyApplication.getAudioRenderer();
        if (audioRenderer != null) {
            audioRenderer.pauseAll();
        }
        if (this.legacyApplication.getContext() != null && (joyInput = this.legacyApplication.getContext().getJoyInput()) != null && joyInput instanceof AndroidSensorJoyInput) {
            AndroidSensorJoyInput androidJoyInput = (AndroidSensorJoyInput)joyInput;
            androidJoyInput.pauseSensors();
        }
        this.setGLThreadPaused(true);
        jmeSurfaceViewLogger.log(Level.INFO, "Game goes idle");
    }

    public void destroy() {
        if (this.legacyApplication == null) {
            return;
        }
        this.removeGLSurfaceView();
        this.legacyApplication.destroy();
        this.legacyApplication = null;
        this.appSettings = null;
        this.oglesContext = null;
        this.configurationInfo = null;
        this.crashLogWriter = null;
        this.crashLog = null;
        this.rendererThread = null;
        this.destructionPolicy = null;
        this.audioRendererType = null;
        this.handler = null;
        this.glEsVersion = null;
        this.onRendererStarted = null;
        this.onRendererCompleted = null;
        this.onExceptionThrown = null;
        this.onLayoutDrawn = null;
        GameState.setLegacyApplication(null);
        GameState.setFirstUpdatePassed(false);
        jmeSurfaceViewLogger.log(Level.INFO, "Context and Game have been destructed");
    }

    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -2: {
                dialog.dismiss();
                ((Activity)this.getContext()).finish();
                break;
            }
            case -1: {
                dialog.dismiss();
                break;
            }
            case -3: {
                ClipboardManager clipboardManager = (ClipboardManager)this.getContext().getSystemService("clipboard");
                ClipData clipData = ClipData.newPlainText((CharSequence)"Crash Log", (CharSequence)this.crashLog);
                clipboardManager.setPrimaryClip(clipData);
                Toast.makeText((Context)this.getContext(), (CharSequence)"Crash Log copied to clipboard", (int)0).show();
            }
        }
    }

    protected void addGlSurfaceView() {
        this.addView((View)this.glSurfaceView);
        if (this.onLayoutDrawn != null) {
            this.onLayoutDrawn.onLayoutDrawn(this.legacyApplication, (View)this);
        }
        if (this.destructionPolicy == DestructionPolicy.KEEP_WHEN_FINISH) {
            GameState.setLegacyApplication(this.legacyApplication);
        } else {
            GameState.setLegacyApplication(null);
        }
    }

    protected void showErrorDialog(Throwable throwable, String title) {
        if (!this.isShowErrorDialog()) {
            return;
        }
        ((Activity)this.getContext()).runOnUiThread(() -> {
            throwable.printStackTrace(new PrintWriter(this.crashLogWriter));
            this.crashLog = this.glEsVersion + "\n" + this.crashLogWriter.toString();
            AlertDialog alertDialog = new AlertDialog.Builder(this.getContext()).create();
            alertDialog.setTitle((CharSequence)(this.glEsVersion + ", " + title));
            alertDialog.setMessage((CharSequence)this.crashLog);
            alertDialog.setCancelable(false);
            alertDialog.setButton(-2, (CharSequence)"Exit", (DialogInterface.OnClickListener)this);
            alertDialog.setButton(-1, (CharSequence)"Dismiss", (DialogInterface.OnClickListener)this);
            alertDialog.setButton(-3, (CharSequence)"Copy crash log", (DialogInterface.OnClickListener)this);
            alertDialog.show();
        });
    }

    public void bindAppStateToActivityLifeCycle(boolean condition) {
        this.bindAppState = condition;
        if (condition) {
            if (this.getContext() instanceof LifecycleOwner) {
                ((LifecycleOwner)this.getContext()).getLifecycle().addObserver((LifecycleObserver)this);
            }
        } else if (this.getContext() instanceof LifecycleOwner) {
            ((LifecycleOwner)this.getContext()).getLifecycle().removeObserver((LifecycleObserver)this);
        }
    }

    public DestructionPolicy getDestructionPolicy() {
        return this.destructionPolicy;
    }

    public void setDestructionPolicy(DestructionPolicy destructionPolicy) {
        this.destructionPolicy = destructionPolicy;
    }

    public boolean isAppStateBoundToActivityLifeCycle() {
        return this.bindAppState;
    }

    public boolean isShowEscExitPrompt() {
        return this.showEscExitPrompt;
    }

    public void setShowEscExitPrompt(boolean showEscExitPrompt) {
        this.showEscExitPrompt = showEscExitPrompt;
    }

    public boolean isExitOnEscPressed() {
        return this.exitOnEscPressed;
    }

    public void setExitOnEscPressed(boolean exitOnEscPressed) {
        this.exitOnEscPressed = exitOnEscPressed;
    }

    public LegacyApplication getLegacyApplication() {
        return this.legacyApplication;
    }

    public void setLegacyApplication(@NonNull LegacyApplication legacyApplication) {
        this.legacyApplication = legacyApplication;
    }

    public AppSettings getAppSettings() {
        return this.appSettings;
    }

    public void setAppSettings(@NonNull AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public int getEglBitsPerPixel() {
        return this.eglBitsPerPixel;
    }

    public void setEglBitsPerPixel(int eglBitsPerPixel) {
        this.eglBitsPerPixel = eglBitsPerPixel;
    }

    public int getEglAlphaBits() {
        return this.eglAlphaBits;
    }

    public void setEglAlphaBits(int eglAlphaBits) {
        this.eglAlphaBits = eglAlphaBits;
    }

    public int getEglDepthBits() {
        return this.eglDepthBits;
    }

    public void setEglDepthBits(int eglDepthBits) {
        this.eglDepthBits = eglDepthBits;
    }

    public int getEglSamples() {
        return this.eglSamples;
    }

    public void setEglSamples(int eglSamples) {
        this.eglSamples = eglSamples;
    }

    public int getEglStencilBits() {
        return this.eglStencilBits;
    }

    public void setEglStencilBits(int eglStencilBits) {
        this.eglStencilBits = eglStencilBits;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int frameRate) {
        this.frameRate = frameRate;
    }

    public String getAudioRendererType() {
        return this.audioRendererType;
    }

    public void setAudioRendererType(String audioRendererType) {
        this.audioRendererType = audioRendererType;
    }

    public boolean isEmulateKeyBoard() {
        return this.emulateKeyBoard;
    }

    public void setEmulateKeyBoard(boolean emulateKeyBoard) {
        this.emulateKeyBoard = emulateKeyBoard;
    }

    public boolean isEmulateMouse() {
        return this.emulateMouse;
    }

    public void setEmulateMouse(boolean emulateMouse) {
        this.emulateMouse = emulateMouse;
    }

    public boolean isUseJoyStickEvents() {
        return this.useJoyStickEvents;
    }

    public void setUseJoyStickEvents(boolean useJoyStickEvents) {
        this.useJoyStickEvents = useJoyStickEvents;
    }

    public boolean isGLThreadPaused() {
        return this.isGLThreadPaused;
    }

    protected void setGLThreadPaused(boolean GLThreadPaused) {
        this.isGLThreadPaused = GLThreadPaused;
    }

    public void setOnRendererCompleted(OnRendererCompleted onRendererCompleted) {
        this.onRendererCompleted = onRendererCompleted;
    }

    public void setOnExceptionThrown(OnExceptionThrown onExceptionThrown) {
        this.onExceptionThrown = onExceptionThrown;
    }

    public void setOnRendererStarted(OnRendererStarted onRendererStarted) {
        this.onRendererStarted = onRendererStarted;
    }

    public void setOnLayoutDrawn(OnLayoutDrawn onLayoutDrawn) {
        this.onLayoutDrawn = onLayoutDrawn;
    }

    public String getGlEsVersion() {
        return this.configurationInfo.getGlEsVersion();
    }

    public boolean isShowErrorDialog() {
        return this.showErrorDialog;
    }

    public void setShowErrorDialog(boolean showErrorDialog) {
        this.showErrorDialog = showErrorDialog;
    }

    private class RendererThread
    implements Runnable {
        private RendererThread() {
        }

        @Override
        public void run() {
            JmeSurfaceView.this.addGlSurfaceView();
            jmeSurfaceViewLogger.log(Level.INFO, "JmeSurfaceView's joined the UI thread");
        }
    }

    public static enum DestructionPolicy {
        DESTROY_WHEN_FINISH,
        KEEP_WHEN_FINISH;

    }

    protected static final class GameState {
        private static LegacyApplication legacyApplication;
        private static boolean firstUpdatePassed;

        private GameState() {
        }

        protected static LegacyApplication getLegacyApplication() {
            return legacyApplication;
        }

        protected static void setLegacyApplication(LegacyApplication legacyApplication) {
            GameState.legacyApplication = legacyApplication;
        }

        protected static boolean isFirstUpdatePassed() {
            return firstUpdatePassed;
        }

        protected static void setFirstUpdatePassed(boolean firstUpdatePassed) {
            GameState.firstUpdatePassed = firstUpdatePassed;
        }

        static {
            firstUpdatePassed = false;
        }
    }
}

