/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.jme3.app.Application;
import com.jme3.app.LegacyApplication;
import com.jme3.audio.AudioRenderer;
import com.jme3.input.JoyInput;
import com.jme3.input.android.AndroidSensorJoyInput;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.TouchListener;
import com.jme3.input.controls.TouchTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.input.event.TouchEvent;
import com.jme3.system.AppSettings;
import com.jme3.system.SystemListener;
import com.jme3.system.android.JmeAndroidSystem;
import com.jme3.system.android.OGLESContext;
import com.jme3.util.AndroidLogHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class AndroidHarness
extends Activity
implements TouchListener,
DialogInterface.OnClickListener,
SystemListener {
    protected static final Logger logger = Logger.getLogger(AndroidHarness.class.getName());
    protected String appClass = "jme3test.android.Test";
    protected LegacyApplication app = null;
    protected int eglBitsPerPixel = 24;
    protected int eglAlphaBits = 0;
    protected int eglDepthBits = 16;
    protected int eglSamples = 0;
    protected int eglStencilBits = 0;
    protected int frameRate = -1;
    protected String audioRendererType = "OpenAL_SOFT";
    protected boolean joystickEventsEnabled = false;
    protected boolean keyEventsEnabled = true;
    protected boolean mouseEventsEnabled = true;
    protected boolean mouseEventsInvertX = false;
    protected boolean mouseEventsInvertY = false;
    protected boolean finishOnAppStop = true;
    protected boolean handleExitHook = true;
    protected String exitDialogTitle = "Do you want to exit?";
    protected String exitDialogMessage = "Use your home key to bring this app into the background or exit to terminate it.";
    protected boolean screenFullScreen = true;
    protected boolean screenShowTitle = true;
    protected int splashPicID = 0;
    protected OGLESContext ctx;
    protected GLSurfaceView view = null;
    protected boolean isGLThreadPaused = true;
    protected ImageView splashImageView = null;
    protected FrameLayout frameLayout = null;
    private final String ESCAPE_EVENT = "TouchEscape";
    private boolean firstDrawFrame = true;
    private boolean inConfigChange = false;

    public Object onRetainNonConfigurationInstance() {
        logger.log(Level.FINE, "onRetainNonConfigurationInstance");
        DataObject data = new DataObject();
        data.app = this.app;
        this.inConfigChange = true;
        return data;
    }

    public void onCreate(Bundle savedInstanceState) {
        this.initializeLogHandler();
        logger.fine("onCreate");
        super.onCreate(savedInstanceState);
        if (this.screenFullScreen) {
            this.requestWindowFeature(1);
            this.getWindow().setFlags(1024, 1024);
        } else if (!this.screenShowTitle) {
            this.requestWindowFeature(1);
        }
        DataObject data = (DataObject)this.getLastNonConfigurationInstance();
        if (data != null) {
            logger.log(Level.FINE, "Using Retained App");
            this.app = data.app;
        } else {
            WindowManager wind = this.getWindowManager();
            Display disp = wind.getDefaultDisplay();
            Log.d((String)"AndroidHarness", (String)("Resolution from Window, width:" + disp.getWidth() + ", height: " + disp.getHeight()));
            logger.log(Level.FINE, "Creating settings");
            AppSettings settings = new AppSettings(true);
            settings.setEmulateMouse(this.mouseEventsEnabled);
            settings.setEmulateMouseFlipAxis(this.mouseEventsInvertX, this.mouseEventsInvertY);
            settings.setUseJoysticks(this.joystickEventsEnabled);
            settings.setEmulateKeyboard(this.keyEventsEnabled);
            settings.setBitsPerPixel(this.eglBitsPerPixel);
            settings.setAlphaBits(this.eglAlphaBits);
            settings.setDepthBits(this.eglDepthBits);
            settings.setSamples(this.eglSamples);
            settings.setStencilBits(this.eglStencilBits);
            settings.setResolution(disp.getWidth(), disp.getHeight());
            settings.setAudioRenderer(this.audioRendererType);
            settings.setFrameRate(this.frameRate);
            try {
                if (this.app == null) {
                    Class<?> clazz = Class.forName(this.appClass);
                    this.app = (LegacyApplication)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                this.app.setSettings(settings);
                this.app.start();
            }
            catch (Exception ex) {
                this.handleError("Class " + this.appClass + " init failed", ex);
                this.setContentView((View)new TextView((Context)this));
            }
        }
        this.ctx = (OGLESContext)this.app.getContext();
        this.view = this.ctx.createView((Context)this);
        JmeAndroidSystem.setView((View)this.view);
        this.ctx.setSystemListener(this);
        this.layoutDisplay();
    }

    protected void onRestart() {
        logger.fine("onRestart");
        super.onRestart();
        if (this.app != null) {
            this.app.restart();
        }
    }

    protected void onStart() {
        logger.fine("onStart");
        super.onStart();
    }

    protected void onResume() {
        logger.fine("onResume");
        super.onResume();
        this.gainFocus();
    }

    protected void onPause() {
        logger.fine("onPause");
        this.loseFocus();
        super.onPause();
    }

    protected void onStop() {
        logger.fine("onStop");
        super.onStop();
    }

    protected void onDestroy() {
        logger.fine("onDestroy");
        DataObject data = (DataObject)this.getLastNonConfigurationInstance();
        if (data != null || this.inConfigChange) {
            logger.fine("In Config Change, not stopping app.");
        } else if (this.app != null) {
            this.app.stop(!this.isGLThreadPaused);
        }
        this.setContentView((View)new TextView((Context)this));
        this.ctx = null;
        this.app = null;
        this.view = null;
        JmeAndroidSystem.setView(null);
        super.onDestroy();
    }

    public Application getJmeApplication() {
        return this.app;
    }

    public void handleError(String errorMsg, Throwable t) {
        String stackTrace = "";
        String title = "Error";
        if (t != null) {
            StringWriter sw = new StringWriter(100);
            t.printStackTrace(new PrintWriter(sw));
            stackTrace = sw.toString();
            title = t.toString();
        }
        final String finalTitle = title;
        final String finalMsg = (errorMsg != null ? errorMsg : "Uncaught Exception") + "\n" + stackTrace;
        logger.log(Level.SEVERE, finalMsg);
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog dialog = new AlertDialog.Builder((Context)AndroidHarness.this).setTitle((CharSequence)finalTitle).setPositiveButton((CharSequence)"Kill", (DialogInterface.OnClickListener)AndroidHarness.this).setMessage((CharSequence)finalMsg).create();
                dialog.show();
            }
        });
    }

    public void onClick(DialogInterface dialog, int whichButton) {
        if (whichButton != -2) {
            if (this.app != null) {
                this.app.stop(true);
            }
            this.app = null;
            this.finish();
        }
    }

    public void onTouch(String name, TouchEvent evt, float tpf) {
        if (name.equals("TouchEscape")) {
            switch (evt.getType()) {
                case KEY_UP: {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            AlertDialog dialog = new AlertDialog.Builder((Context)AndroidHarness.this).setTitle((CharSequence)AndroidHarness.this.exitDialogTitle).setPositiveButton((CharSequence)"Yes", (DialogInterface.OnClickListener)AndroidHarness.this).setNegativeButton((CharSequence)"No", (DialogInterface.OnClickListener)AndroidHarness.this).setMessage((CharSequence)AndroidHarness.this.exitDialogMessage).create();
                            dialog.show();
                        }
                    });
                    break;
                }
            }
        }
    }

    public void layoutDisplay() {
        logger.log(Level.FINE, "Splash Screen Picture Resource ID: {0}", this.splashPicID);
        if (this.view == null) {
            logger.log(Level.FINE, "view is null!");
        }
        if (this.splashPicID != 0) {
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1, 17);
            this.frameLayout = new FrameLayout((Context)this);
            this.splashImageView = new ImageView((Context)this);
            Drawable drawable = this.getResources().getDrawable(this.splashPicID);
            if (drawable instanceof NinePatchDrawable) {
                this.splashImageView.setBackgroundDrawable(drawable);
            } else {
                this.splashImageView.setImageResource(this.splashPicID);
            }
            if (this.view.getParent() != null) {
                ((ViewGroup)this.view.getParent()).removeView((View)this.view);
            }
            this.frameLayout.addView((View)this.view);
            if (this.splashImageView.getParent() != null) {
                ((ViewGroup)this.splashImageView.getParent()).removeView((View)this.splashImageView);
            }
            this.frameLayout.addView((View)this.splashImageView, (ViewGroup.LayoutParams)lp);
            this.setContentView((View)this.frameLayout);
            logger.log(Level.FINE, "Splash Screen Created");
        } else {
            logger.log(Level.FINE, "Splash Screen Skipped.");
            this.setContentView((View)this.view);
        }
    }

    public void removeSplashScreen() {
        logger.log(Level.FINE, "Splash Screen Picture Resource ID: {0}", this.splashPicID);
        if (this.splashPicID != 0) {
            if (this.frameLayout != null) {
                if (this.splashImageView != null) {
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            AndroidHarness.this.splashImageView.setVisibility(4);
                            AndroidHarness.this.frameLayout.removeView((View)AndroidHarness.this.splashImageView);
                        }
                    });
                } else {
                    logger.log(Level.FINE, "splashImageView is null");
                }
            } else {
                logger.log(Level.FINE, "frameLayout is null");
            }
        }
    }

    protected void initializeLogHandler() {
        Logger log = LogManager.getLogManager().getLogger("");
        for (Handler handler : log.getHandlers()) {
            if (log.getLevel() != null && log.getLevel().intValue() <= Level.FINE.intValue()) {
                Log.v((String)"AndroidHarness", (String)("Removing Handler class: " + handler.getClass().getName()));
            }
            log.removeHandler(handler);
        }
        AndroidLogHandler handler = new AndroidLogHandler();
        log.addHandler(handler);
        handler.setLevel(Level.ALL);
    }

    public void initialize() {
        this.app.initialize();
        if (this.handleExitHook) {
            if (this.app.getInputManager().hasMapping("SIMPLEAPP_Exit")) {
                this.app.getInputManager().deleteMapping("SIMPLEAPP_Exit");
            }
            this.app.getInputManager().addMapping("TouchEscape", new Trigger[]{new TouchTrigger(4)});
            this.app.getInputManager().addListener((InputListener)this, new String[]{"TouchEscape"});
        }
    }

    public void reshape(int width, int height) {
        this.app.reshape(width, height);
    }

    public void rescale(float x, float y) {
        this.app.rescale(x, y);
    }

    public void update() {
        this.app.update();
        if (this.firstDrawFrame) {
            this.removeSplashScreen();
            this.firstDrawFrame = false;
        }
    }

    public void requestClose(boolean esc) {
        this.app.requestClose(esc);
    }

    public void destroy() {
        if (this.app != null) {
            this.app.destroy();
        }
        if (this.finishOnAppStop) {
            this.finish();
        }
    }

    public void gainFocus() {
        logger.fine("gainFocus");
        if (this.view != null) {
            this.view.onResume();
        }
        if (this.app != null) {
            JoyInput joyInput;
            AudioRenderer audioRenderer = this.app.getAudioRenderer();
            if (audioRenderer != null) {
                audioRenderer.resumeAll();
            }
            if (this.app.getContext() != null && (joyInput = this.app.getContext().getJoyInput()) != null && joyInput instanceof AndroidSensorJoyInput) {
                AndroidSensorJoyInput androidJoyInput = (AndroidSensorJoyInput)joyInput;
                androidJoyInput.resumeSensors();
            }
        }
        this.isGLThreadPaused = false;
        if (this.app != null) {
            this.app.gainFocus();
        }
    }

    public void loseFocus() {
        logger.fine("loseFocus");
        if (this.app != null) {
            this.app.loseFocus();
        }
        if (this.view != null) {
            this.view.onPause();
        }
        if (this.app != null) {
            JoyInput joyInput;
            AudioRenderer audioRenderer = this.app.getAudioRenderer();
            if (audioRenderer != null) {
                audioRenderer.pauseAll();
            }
            if (this.app.getContext() != null && (joyInput = this.app.getContext().getJoyInput()) != null && joyInput instanceof AndroidSensorJoyInput) {
                AndroidSensorJoyInput androidJoyInput = (AndroidSensorJoyInput)joyInput;
                androidJoyInput.pauseSensors();
            }
        }
        this.isGLThreadPaused = true;
    }

    private class DataObject {
        protected LegacyApplication app = null;

        private DataObject() {
        }
    }
}

