/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import android.graphics.Bitmap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MjpegFileWriter {
    private static final Logger logger = Logger.getLogger(MjpegFileWriter.class.getName());
    int width = 0;
    int height = 0;
    double framerate = 0.0;
    int numFrames = 0;
    File aviFile = null;
    FileOutputStream aviOutput = null;
    FileChannel aviChannel = null;
    long riffOffset = 0L;
    long aviMovieOffset = 0L;
    AVIIndexList indexlist = null;

    public MjpegFileWriter(File aviFile, int width, int height, double framerate) throws Exception {
        this(aviFile, width, height, framerate, 0);
    }

    public MjpegFileWriter(File aviFile, int width, int height, double framerate, int numFrames) throws Exception {
        this.aviFile = aviFile;
        this.width = width;
        this.height = height;
        this.framerate = framerate;
        this.numFrames = numFrames;
        this.aviOutput = new FileOutputStream(aviFile);
        this.aviChannel = this.aviOutput.getChannel();
        RIFFHeader rh = new RIFFHeader();
        this.aviOutput.write(rh.toBytes());
        this.aviOutput.write(new AVIMainHeader().toBytes());
        this.aviOutput.write(new AVIStreamList().toBytes());
        this.aviOutput.write(new AVIStreamHeader().toBytes());
        this.aviOutput.write(new AVIStreamFormat().toBytes());
        this.aviOutput.write(new AVIJunk().toBytes());
        this.aviMovieOffset = this.aviChannel.position();
        this.aviOutput.write(new AVIMovieList().toBytes());
        this.indexlist = new AVIIndexList();
    }

    public void addImage(Bitmap image) throws Exception {
        this.addImage(image, 0.8f);
    }

    public void addImage(Bitmap image, float quality) throws Exception {
        this.addImage(this.writeImageToBytes(image, quality));
    }

    public void addImage(byte[] imagedata) throws Exception {
        byte[] fcc = new byte[]{48, 48, 100, 98};
        int useLength = imagedata.length;
        long position = this.aviChannel.position();
        int extra = (useLength + (int)position) % 4;
        if (extra > 0) {
            useLength += extra;
        }
        this.indexlist.addAVIIndex((int)position, useLength);
        this.aviOutput.write(fcc);
        this.aviOutput.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(useLength)));
        this.aviOutput.write(imagedata);
        if (extra > 0) {
            for (int i = 0; i < extra; ++i) {
                this.aviOutput.write(0);
            }
        }
        imagedata = null;
        ++this.numFrames;
    }

    public void finishAVI() throws Exception {
        logger.log(Level.INFO, "finishAVI");
        byte[] indexlistBytes = this.indexlist.toBytes();
        this.aviOutput.write(indexlistBytes);
        this.aviOutput.close();
        int fileSize = (int)this.aviFile.length();
        logger.log(Level.INFO, "fileSize: {0}", fileSize);
        int listSize = (int)((long)(fileSize - 8) - this.aviMovieOffset - (long)indexlistBytes.length);
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "listSize: {0}", listSize);
            logger.log(Level.INFO, "aviFile canWrite: {0}", this.aviFile.canWrite());
            logger.log(Level.INFO, "aviFile AbsolutePath: {0}", this.aviFile.getAbsolutePath());
            logger.log(Level.INFO, "aviFile numFrames: {0}", this.numFrames);
        }
        RandomAccessFile raf = new RandomAccessFile(this.aviFile, "rw");
        raf.write(new RIFFHeader(fileSize).toBytes());
        raf.write(new AVIMainHeader().toBytes());
        raf.write(new AVIStreamList().toBytes());
        raf.write(new AVIStreamHeader().toBytes());
        raf.write(new AVIStreamFormat().toBytes());
        raf.write(new AVIJunk().toBytes());
        raf.write(new AVIMovieList(listSize).toBytes());
        raf.close();
    }

    public static int swapInt(int v) {
        return v >>> 24 | v << 24 | v << 8 & 0xFF0000 | v >> 8 & 0xFF00;
    }

    public static short swapShort(short v) {
        return (short)(v >>> 8 | v << 8);
    }

    public static byte[] intBytes(int i) {
        byte[] b = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
        return b;
    }

    public static byte[] shortBytes(short i) {
        byte[] b = new byte[]{(byte)(i >>> 8), (byte)(i & 0xFF)};
        return b;
    }

    public byte[] writeImageToBytes(Bitmap image, float quality) throws Exception {
        Bitmap bi;
        if (image.getConfig() == Bitmap.Config.RGB_565) {
            bi = image;
        } else {
            bi = image.copy(Bitmap.Config.RGB_565, false);
            if (bi == null) {
                throw new IllegalStateException("Could not convert Bitmap to RGB_565");
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bi.compress(Bitmap.CompressFormat.JPEG, (int)(quality * 100.0f), (OutputStream)baos);
        baos.close();
        return baos.toByteArray();
    }

    private class AVIIndexList {
        public byte[] fcc = new byte[]{105, 100, 120, 49};
        public int cb = 0;
        public List<AVIIndex> ind = new ArrayList<AVIIndex>();

        public void addAVIIndex(AVIIndex ai) {
            this.ind.add(ai);
        }

        public void addAVIIndex(int dwOffset, int dwSize) {
            this.ind.add(new AVIIndex(dwOffset, dwSize));
        }

        public byte[] toBytes() throws Exception {
            this.cb = 16 * this.ind.size();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.cb)));
            for (int i = 0; i < this.ind.size(); ++i) {
                AVIIndex in = this.ind.get(i);
                baos.write(in.toBytes());
            }
            baos.close();
            return baos.toByteArray();
        }
    }

    private class RIFFHeader {
        public byte[] fcc = new byte[]{82, 73, 70, 70};
        public int fileSize = 0;
        public byte[] fcc2 = new byte[]{65, 86, 73, 32};
        public byte[] fcc3 = new byte[]{76, 73, 83, 84};
        public int listSize = 200;
        public byte[] fcc4 = new byte[]{104, 100, 114, 108};

        public RIFFHeader() {
        }

        public RIFFHeader(int fileSize) {
            this.fileSize = fileSize;
        }

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.fileSize)));
            baos.write(this.fcc2);
            baos.write(this.fcc3);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.listSize)));
            baos.write(this.fcc4);
            baos.close();
            return baos.toByteArray();
        }
    }

    private class AVIMainHeader {
        public byte[] fcc = new byte[]{97, 118, 105, 104};
        public int cb = 56;
        public int dwMicroSecPerFrame = 0;
        public int dwMaxBytesPerSec = 10000000;
        public int dwPaddingGranularity = 0;
        public int dwFlags = 65552;
        public int dwTotalFrames = 0;
        public int dwInitialFrames = 0;
        public int dwStreams = 1;
        public int dwSuggestedBufferSize = 0;
        public int dwWidth = 0;
        public int dwHeight = 0;
        public int[] dwReserved = new int[4];

        public AVIMainHeader() {
            this.dwMicroSecPerFrame = (int)(1.0 / MjpegFileWriter.this.framerate * 1000000.0);
            this.dwWidth = MjpegFileWriter.this.width;
            this.dwHeight = MjpegFileWriter.this.height;
            this.dwTotalFrames = MjpegFileWriter.this.numFrames;
        }

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.cb)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwMicroSecPerFrame)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwMaxBytesPerSec)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwPaddingGranularity)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwFlags)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwTotalFrames)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwInitialFrames)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwStreams)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwSuggestedBufferSize)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwWidth)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwHeight)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwReserved[0])));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwReserved[1])));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwReserved[2])));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwReserved[3])));
            baos.close();
            return baos.toByteArray();
        }
    }

    private class AVIStreamList {
        public byte[] fcc = new byte[]{76, 73, 83, 84};
        public int size = 124;
        public byte[] fcc2 = new byte[]{115, 116, 114, 108};

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.size)));
            baos.write(this.fcc2);
            baos.close();
            return baos.toByteArray();
        }
    }

    private class AVIStreamHeader {
        public byte[] fcc = new byte[]{115, 116, 114, 104};
        public int cb = 64;
        public byte[] fccType = new byte[]{118, 105, 100, 115};
        public byte[] fccHandler = new byte[]{77, 74, 80, 71};
        public int dwFlags = 0;
        public short wPriority = 0;
        public short wLanguage = 0;
        public int dwInitialFrames = 0;
        public int dwScale = 0;
        public int dwRate = 1000000;
        public int dwStart = 0;
        public int dwLength = 0;
        public int dwSuggestedBufferSize = 0;
        public int dwQuality = -1;
        public int dwSampleSize = 0;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        public AVIStreamHeader() {
            this.dwScale = (int)(1.0 / MjpegFileWriter.this.framerate * 1000000.0);
            this.dwLength = MjpegFileWriter.this.numFrames;
        }

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.cb)));
            baos.write(this.fccType);
            baos.write(this.fccHandler);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwFlags)));
            baos.write(MjpegFileWriter.shortBytes(MjpegFileWriter.swapShort(this.wPriority)));
            baos.write(MjpegFileWriter.shortBytes(MjpegFileWriter.swapShort(this.wLanguage)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwInitialFrames)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwScale)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwRate)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwStart)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwLength)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwSuggestedBufferSize)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwQuality)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwSampleSize)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.left)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.top)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.right)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.bottom)));
            baos.close();
            return baos.toByteArray();
        }
    }

    private class AVIStreamFormat {
        public byte[] fcc = new byte[]{115, 116, 114, 102};
        public int cb = 40;
        public int biSize = 40;
        public int biWidth = 0;
        public int biHeight = 0;
        public short biPlanes = 1;
        public short biBitCount = (short)24;
        public byte[] biCompression = new byte[]{77, 74, 80, 71};
        public int biSizeImage = 0;
        public int biXPelsPerMeter = 0;
        public int biYPelsPerMeter = 0;
        public int biClrUsed = 0;
        public int biClrImportant = 0;

        public AVIStreamFormat() {
            this.biWidth = MjpegFileWriter.this.width;
            this.biHeight = MjpegFileWriter.this.height;
            this.biSizeImage = MjpegFileWriter.this.width * MjpegFileWriter.this.height;
        }

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.cb)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biSize)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biWidth)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biHeight)));
            baos.write(MjpegFileWriter.shortBytes(MjpegFileWriter.swapShort(this.biPlanes)));
            baos.write(MjpegFileWriter.shortBytes(MjpegFileWriter.swapShort(this.biBitCount)));
            baos.write(this.biCompression);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biSizeImage)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biXPelsPerMeter)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biYPelsPerMeter)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biClrUsed)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biClrImportant)));
            baos.close();
            return baos.toByteArray();
        }
    }

    private class AVIJunk {
        public byte[] fcc = new byte[]{74, 85, 78, 75};
        public int size = 1808;
        public byte[] data = new byte[this.size];

        public AVIJunk() {
            Arrays.fill(this.data, (byte)0);
        }

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.size)));
            baos.write(this.data);
            baos.close();
            return baos.toByteArray();
        }
    }

    private class AVIMovieList {
        public byte[] fcc = new byte[]{76, 73, 83, 84};
        public int listSize = 0;
        public byte[] fcc2 = new byte[]{109, 111, 118, 105};

        public AVIMovieList() {
        }

        public AVIMovieList(int listSize) {
            this.listSize = listSize;
        }

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.listSize)));
            baos.write(this.fcc2);
            baos.close();
            return baos.toByteArray();
        }
    }

    private class AVIIndex {
        public byte[] fcc = new byte[]{48, 48, 100, 98};
        public int dwFlags = 16;
        public int dwOffset = 0;
        public int dwSize = 0;

        public AVIIndex(int dwOffset, int dwSize) {
            this.dwOffset = dwOffset;
            this.dwSize = dwSize;
        }

        public byte[] toBytes() throws Exception {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwFlags)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwOffset)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwSize)));
            baos.close();
            return baos.toByteArray();
        }
    }
}

