/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset.plugins;

import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import com.jme3.system.android.JmeAndroidSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class AndroidLocator
implements AssetLocator {
    private static final Logger logger = Logger.getLogger(AndroidLocator.class.getName());
    private String rootPath = "";

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public AssetInfo locate(AssetManager manager, AssetKey key) {
        String assetPath = this.rootPath + key.getName();
        if ((assetPath = assetPath.replace("//", "/")).startsWith("/")) {
            assetPath = assetPath.substring(1);
        }
        Resources androidResources = JmeAndroidSystem.getView().getContext().getResources();
        String androidPackageName = JmeAndroidSystem.getView().getContext().getPackageName();
        try {
            InputStream in = androidResources.getAssets().open(assetPath);
            if (in != null) {
                return new AndroidAssetInfo(manager, key, assetPath, in, 0);
            }
        }
        catch (IOException in) {
            // empty catch block
        }
        String resourceName = this.getResourceName(assetPath);
        int resourceId = androidResources.getIdentifier(resourceName, "drawable", androidPackageName);
        if (resourceId == 0) {
            resourceId = androidResources.getIdentifier(resourceName, "mipmap", androidPackageName);
        }
        if (resourceId == 0) {
            return null;
        }
        try {
            InputStream in = androidResources.openRawResource(resourceId);
            if (in != null) {
                return new AndroidAssetInfo(manager, key, assetPath, in, resourceId);
            }
        }
        catch (Resources.NotFoundException ex) {
            return null;
        }
        return null;
    }

    private String getResourceName(String name) {
        int idx = name.lastIndexOf(46);
        if (idx <= 0 || idx == name.length() - 1) {
            return name;
        }
        return name.substring(0, idx).toLowerCase();
    }

    public class AndroidAssetInfo
    extends AssetInfo {
        private InputStream in;
        private final String assetPath;
        private int resourceId;

        AndroidAssetInfo(AssetManager assetManager, AssetKey<?> key, String assetPath, InputStream in, int resourceId) {
            super(assetManager, key);
            this.assetPath = assetPath;
            this.in = in;
            this.resourceId = resourceId;
        }

        public InputStream openStream() {
            if (this.in != null) {
                InputStream in2 = this.in;
                this.in = null;
                return in2;
            }
            Resources androidResources = JmeAndroidSystem.getView().getContext().getResources();
            if (this.resourceId == 0) {
                try {
                    return androidResources.getAssets().open(this.assetPath);
                }
                catch (IOException ex) {
                    throw new AssetLoadException("Failed to open asset " + this.assetPath, (Throwable)ex);
                }
            }
            try {
                return androidResources.openRawResource(this.resourceId);
            }
            catch (Resources.NotFoundException ex) {
                throw new AssetLoadException("Failed to open asset " + this.assetPath, (Throwable)ex);
            }
        }

        public AssetFileDescriptor openFileDescriptor() {
            Resources androidResources = JmeAndroidSystem.getView().getContext().getResources();
            if (this.resourceId == 0) {
                try {
                    return androidResources.getAssets().openFd(this.assetPath);
                }
                catch (IOException ex) {
                    throw new AssetLoadException("Failed to open asset " + this.assetPath, (Throwable)ex);
                }
            }
            try {
                return androidResources.openRawResourceFd(this.resourceId);
            }
            catch (Resources.NotFoundException ex) {
                throw new AssetLoadException("Failed to open asset " + this.assetPath, (Throwable)ex);
            }
        }
    }
}

