/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.android;

import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import com.jme3.input.android.AndroidTouchInput;
import com.jme3.input.event.InputEvent;
import com.jme3.input.event.TouchEvent;
import java.util.logging.Logger;

public class AndroidGestureProcessor
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
ScaleGestureDetector.OnScaleGestureListener {
    private static final Logger logger = Logger.getLogger(AndroidGestureProcessor.class.getName());
    private AndroidTouchInput touchInput;
    float gestureDownX = -1.0f;
    float gestureDownY = -1.0f;
    float scaleStartX = -1.0f;
    float scaleStartY = -1.0f;

    public AndroidGestureProcessor(AndroidTouchInput touchInput) {
        this.touchInput = touchInput;
    }

    public boolean onDown(MotionEvent event) {
        this.gestureDownX = this.touchInput.getJmeX(event.getX());
        this.gestureDownY = this.touchInput.invertY(this.touchInput.getJmeY(event.getY()));
        return true;
    }

    public boolean onSingleTapUp(MotionEvent event) {
        return true;
    }

    public void onShowPress(MotionEvent event) {
        float jmeX = this.touchInput.getJmeX(event.getX());
        float jmeY = this.touchInput.invertY(this.touchInput.getJmeY(event.getY()));
        TouchEvent touchEvent = this.touchInput.getFreeTouchEvent();
        touchEvent.set(TouchEvent.Type.SHOWPRESS, jmeX, jmeY, 0.0f, 0.0f);
        touchEvent.setPointerId(this.touchInput.getPointerId(event));
        touchEvent.setTime(event.getEventTime());
        touchEvent.setPressure(event.getPressure());
        this.touchInput.addEvent((InputEvent)touchEvent);
    }

    public void onLongPress(MotionEvent event) {
        float jmeX = this.touchInput.getJmeX(event.getX());
        float jmeY = this.touchInput.invertY(this.touchInput.getJmeY(event.getY()));
        TouchEvent touchEvent = this.touchInput.getFreeTouchEvent();
        touchEvent.set(TouchEvent.Type.LONGPRESSED, jmeX, jmeY, 0.0f, 0.0f);
        touchEvent.setPointerId(this.touchInput.getPointerId(event));
        touchEvent.setTime(event.getEventTime());
        touchEvent.setPressure(event.getPressure());
        this.touchInput.addEvent((InputEvent)touchEvent);
    }

    public boolean onScroll(MotionEvent startEvent, MotionEvent endEvent, float distX, float distY) {
        if (!this.touchInput.getScaleDetector().isInProgress()) {
            float jmeX = this.touchInput.getJmeX(endEvent.getX());
            float jmeY = this.touchInput.invertY(this.touchInput.getJmeY(endEvent.getY()));
            TouchEvent touchEvent = this.touchInput.getFreeTouchEvent();
            touchEvent.set(TouchEvent.Type.SCROLL, jmeX, jmeY, this.touchInput.getJmeX(-distX), this.touchInput.getJmeY(distY));
            touchEvent.setPointerId(this.touchInput.getPointerId(endEvent));
            touchEvent.setTime(endEvent.getEventTime());
            touchEvent.setPressure(endEvent.getPressure());
            this.touchInput.addEvent((InputEvent)touchEvent);
        }
        return true;
    }

    public boolean onFling(MotionEvent startEvent, MotionEvent endEvent, float velocityX, float velocityY) {
        float jmeX = this.touchInput.getJmeX(startEvent.getX());
        float jmeY = this.touchInput.invertY(this.touchInput.getJmeY(startEvent.getY()));
        TouchEvent touchEvent = this.touchInput.getFreeTouchEvent();
        touchEvent.set(TouchEvent.Type.FLING, jmeX, jmeY, velocityX, velocityY);
        touchEvent.setPointerId(this.touchInput.getPointerId(endEvent));
        touchEvent.setTime(endEvent.getEventTime());
        touchEvent.setPressure(endEvent.getPressure());
        this.touchInput.addEvent((InputEvent)touchEvent);
        return true;
    }

    public boolean onSingleTapConfirmed(MotionEvent event) {
        float jmeX = this.touchInput.getJmeX(event.getX());
        float jmeY = this.touchInput.invertY(this.touchInput.getJmeY(event.getY()));
        TouchEvent touchEvent = this.touchInput.getFreeTouchEvent();
        touchEvent.set(TouchEvent.Type.TAP, jmeX, jmeY, 0.0f, 0.0f);
        touchEvent.setPointerId(this.touchInput.getPointerId(event));
        touchEvent.setTime(event.getEventTime());
        touchEvent.setPressure(event.getPressure());
        this.touchInput.addEvent((InputEvent)touchEvent);
        return true;
    }

    public boolean onDoubleTap(MotionEvent event) {
        float jmeX = this.touchInput.getJmeX(event.getX());
        float jmeY = this.touchInput.invertY(this.touchInput.getJmeY(event.getY()));
        TouchEvent touchEvent = this.touchInput.getFreeTouchEvent();
        touchEvent.set(TouchEvent.Type.DOUBLETAP, jmeX, jmeY, 0.0f, 0.0f);
        touchEvent.setPointerId(this.touchInput.getPointerId(event));
        touchEvent.setTime(event.getEventTime());
        touchEvent.setPressure(event.getPressure());
        this.touchInput.addEvent((InputEvent)touchEvent);
        return true;
    }

    public boolean onDoubleTapEvent(MotionEvent event) {
        if (this.touchInput.getAction(event) == 1) {
            TouchEvent touchEvent = this.touchInput.getFreeTouchEvent();
            touchEvent.set(TouchEvent.Type.DOUBLETAP, event.getX(), this.touchInput.invertY(event.getY()), 0.0f, 0.0f);
            touchEvent.setPointerId(this.touchInput.getPointerId(event));
            touchEvent.setTime(event.getEventTime());
            touchEvent.setPressure(event.getPressure());
            this.touchInput.addEvent((InputEvent)touchEvent);
        }
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
        this.scaleStartX = this.gestureDownX;
        this.scaleStartY = this.gestureDownY;
        TouchEvent touchEvent = this.touchInput.getFreeTouchEvent();
        touchEvent.set(TouchEvent.Type.SCALE_START, this.scaleStartX, this.scaleStartY, 0.0f, 0.0f);
        touchEvent.setPointerId(0);
        touchEvent.setTime(scaleGestureDetector.getEventTime());
        touchEvent.setScaleSpan(scaleGestureDetector.getCurrentSpan());
        touchEvent.setDeltaScaleSpan(0.0f);
        touchEvent.setScaleFactor(scaleGestureDetector.getScaleFactor());
        touchEvent.setScaleSpanInProgress(this.touchInput.getScaleDetector().isInProgress());
        this.touchInput.addEvent((InputEvent)touchEvent);
        return true;
    }

    public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
        this.scaleStartX = this.gestureDownX;
        this.scaleStartY = this.gestureDownY;
        TouchEvent touchEvent = this.touchInput.getFreeTouchEvent();
        touchEvent.set(TouchEvent.Type.SCALE_MOVE, this.scaleStartX, this.scaleStartY, 0.0f, 0.0f);
        touchEvent.setPointerId(0);
        touchEvent.setTime(scaleGestureDetector.getEventTime());
        touchEvent.setScaleSpan(scaleGestureDetector.getCurrentSpan());
        touchEvent.setDeltaScaleSpan(scaleGestureDetector.getCurrentSpan() - scaleGestureDetector.getPreviousSpan());
        touchEvent.setScaleFactor(scaleGestureDetector.getScaleFactor());
        touchEvent.setScaleSpanInProgress(this.touchInput.getScaleDetector().isInProgress());
        this.touchInput.addEvent((InputEvent)touchEvent);
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
        this.scaleStartX = this.gestureDownX;
        this.scaleStartY = this.gestureDownY;
        TouchEvent touchEvent = this.touchInput.getFreeTouchEvent();
        touchEvent.set(TouchEvent.Type.SCALE_END, this.scaleStartX, this.scaleStartY, 0.0f, 0.0f);
        touchEvent.setPointerId(0);
        touchEvent.setTime(scaleGestureDetector.getEventTime());
        touchEvent.setScaleSpan(scaleGestureDetector.getCurrentSpan());
        touchEvent.setDeltaScaleSpan(scaleGestureDetector.getCurrentSpan() - scaleGestureDetector.getPreviousSpan());
        touchEvent.setScaleFactor(scaleGestureDetector.getScaleFactor());
        touchEvent.setScaleSpanInProgress(this.touchInput.getScaleDetector().isInProgress());
        this.touchInput.addEvent((InputEvent)touchEvent);
    }
}

