/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.android;

import android.opengl.GLSurfaceView;
import android.os.Vibrator;
import com.jme3.input.InputManager;
import com.jme3.input.JoyInput;
import com.jme3.input.Joystick;
import com.jme3.input.RawInputListener;
import com.jme3.input.android.AndroidInputHandler;
import com.jme3.input.android.AndroidSensorJoyInput;
import com.jme3.input.event.InputEvent;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import com.jme3.system.AppSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AndroidJoyInput
implements JoyInput {
    private static final Logger logger = Logger.getLogger(AndroidJoyInput.class.getName());
    public static boolean disableSensors = false;
    protected AndroidInputHandler inputHandler;
    protected List<Joystick> joystickList = new ArrayList<Joystick>();
    private boolean initialized = false;
    private RawInputListener listener = null;
    private ConcurrentLinkedQueue<InputEvent> eventQueue = new ConcurrentLinkedQueue();
    private AndroidSensorJoyInput sensorJoyInput;
    private Vibrator vibrator = null;
    private boolean vibratorActive = false;
    private long maxRumbleTime = 250L;

    public AndroidJoyInput(AndroidInputHandler inputHandler) {
        this.inputHandler = inputHandler;
        this.sensorJoyInput = new AndroidSensorJoyInput(this);
    }

    public void setView(GLSurfaceView view) {
        if (view == null) {
            this.vibrator = null;
        } else {
            this.vibrator = (Vibrator)view.getContext().getSystemService("vibrator");
            if (this.vibrator == null) {
                logger.log(Level.FINE, "Vibrator Service not found.");
            }
        }
        if (this.sensorJoyInput != null) {
            this.sensorJoyInput.setView(view);
        }
    }

    public void loadSettings(AppSettings settings) {
    }

    public void addEvent(InputEvent event) {
        this.eventQueue.add(event);
    }

    public void pauseJoysticks() {
        if (this.sensorJoyInput != null) {
            this.sensorJoyInput.pauseSensors();
        }
        if (this.vibrator != null && this.vibratorActive) {
            this.vibrator.cancel();
        }
    }

    public void resumeJoysticks() {
        if (this.sensorJoyInput != null) {
            this.sensorJoyInput.resumeSensors();
        }
    }

    public void initialize() {
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void destroy() {
        this.initialized = false;
        if (this.sensorJoyInput != null) {
            this.sensorJoyInput.destroy();
        }
        this.setView(null);
    }

    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
    }

    public long getInputTimeNanos() {
        return System.nanoTime();
    }

    public void setJoyRumble(int joyId, float amount) {
        if (this.vibrator != null) {
            long rumbleOnDur = (long)(amount * (float)this.maxRumbleTime);
            long rumbleOffDur = this.maxRumbleTime - rumbleOnDur;
            long[] rumblePattern = new long[]{0L, rumbleOnDur, rumbleOffDur};
            boolean rumbleRepeatFrom = false;
            if (rumbleOnDur > 0L) {
                this.vibrator.vibrate(rumblePattern, 0);
                this.vibratorActive = true;
            } else {
                this.vibrator.cancel();
                this.vibratorActive = false;
            }
        }
    }

    public Joystick[] loadJoysticks(InputManager inputManager) {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "loading joysticks for {0}", this.getClass().getName());
        }
        if (!disableSensors) {
            this.joystickList.add(this.sensorJoyInput.loadJoystick(this.joystickList.size(), inputManager));
        }
        return this.joystickList.toArray(new Joystick[this.joystickList.size()]);
    }

    public void update() {
        if (this.sensorJoyInput != null) {
            this.sensorJoyInput.update();
        }
        if (this.listener != null) {
            InputEvent inputEvent;
            while ((inputEvent = this.eventQueue.poll()) != null) {
                if (inputEvent instanceof JoyAxisEvent) {
                    this.listener.onJoyAxisEvent((JoyAxisEvent)inputEvent);
                    continue;
                }
                if (!(inputEvent instanceof JoyButtonEvent)) continue;
                this.listener.onJoyButtonEvent((JoyButtonEvent)inputEvent);
            }
        }
    }
}

