/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.android;

import android.view.InputDevice;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.jme3.input.AbstractJoystick;
import com.jme3.input.DefaultJoystickAxis;
import com.jme3.input.DefaultJoystickButton;
import com.jme3.input.InputManager;
import com.jme3.input.JoyInput;
import com.jme3.input.Joystick;
import com.jme3.input.JoystickAxis;
import com.jme3.input.JoystickButton;
import com.jme3.input.JoystickCompatibilityMappings;
import com.jme3.input.android.AndroidJoyInput;
import com.jme3.input.event.InputEvent;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AndroidJoystickJoyInput14 {
    private static final Logger logger = Logger.getLogger(AndroidJoystickJoyInput14.class.getName());
    private AndroidJoyInput joyInput;
    private Map<Integer, AndroidJoystick> joystickIndex = new HashMap<Integer, AndroidJoystick>();
    private static int[] AndroidGamepadButtons = new int[]{19, 20, 21, 22, 23, 106, 107, 96, 97, 99, 100, 102, 103, 104, 105, 108, 109, 110};

    public AndroidJoystickJoyInput14(AndroidJoyInput joyInput) {
        this.joyInput = joyInput;
    }

    public void pauseJoysticks() {
    }

    public void resumeJoysticks() {
    }

    public void destroy() {
    }

    public List<Joystick> loadJoysticks(int joyId, InputManager inputManager) {
        int[] deviceIds;
        logger.log(Level.INFO, "loading Joystick devices");
        ArrayList<Joystick> joysticks = new ArrayList<Joystick>();
        joysticks.clear();
        this.joystickIndex.clear();
        ArrayList<Integer> gameControllerDeviceIds = new ArrayList<Integer>();
        for (int deviceId : deviceIds = InputDevice.getDeviceIds()) {
            InputDevice dev = InputDevice.getDevice((int)deviceId);
            int sources = dev.getSources();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "deviceId[{0}] sources: {1}", new Object[]{deviceId, sources});
            }
            if ((sources & 0x401) != 1025 && (sources & 0x1000010) != 0x1000010 || gameControllerDeviceIds.contains(deviceId)) continue;
            gameControllerDeviceIds.add(deviceId);
            logger.log(Level.FINE, "Attempting to create joystick for device: {0}", dev);
            AndroidJoystick joystick = new AndroidJoystick(inputManager, this.joyInput, dev, joyId + joysticks.size(), dev.getName());
            this.joystickIndex.put(deviceId, joystick);
            joysticks.add((Joystick)joystick);
            List motionRanges = dev.getMotionRanges();
            for (InputDevice.MotionRange motionRange : motionRanges) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "motion range: {0}", motionRange);
                    logger.log(Level.INFO, "axis: {0}", motionRange.getAxis());
                }
                JoystickAxis axis = joystick.addAxis(motionRange);
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.log(Level.INFO, "added axis: {0}", axis);
            }
            for (Object keyCode : (Object)AndroidGamepadButtons) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "button[{0}]: {1}", new Object[]{(int)keyCode, KeyCharacterMap.deviceHasKey((int)keyCode)});
                }
                if (!KeyCharacterMap.deviceHasKey((int)keyCode)) continue;
                logger.log(Level.INFO, "button[{0}] exists somewhere", (int)keyCode);
                JoystickButton button = joystick.addButton((int)keyCode);
                logger.log(Level.INFO, "added button: {0}", button);
            }
        }
        return joysticks;
    }

    public boolean onGenericMotion(MotionEvent event) {
        boolean consumed = false;
        event.getDeviceId();
        event.getSource();
        AndroidJoystick joystick = this.joystickIndex.get(event.getDeviceId());
        if (joystick != null) {
            for (int androidAxis : joystick.getAndroidAxes()) {
                JoystickAxis axis;
                String axisName = MotionEvent.axisToString((int)androidAxis);
                float rawValue = event.getAxisValue(androidAxis);
                float value = JoystickCompatibilityMappings.remapAxisRange((JoystickAxis)joystick.getAxis(androidAxis), (float)rawValue);
                int action = event.getAction();
                if (action != 2 || (axis = joystick.getAxis(androidAxis)) == null) continue;
                JoyAxisEvent axisEvent = new JoyAxisEvent(axis, value, rawValue);
                this.joyInput.addEvent((InputEvent)axisEvent);
                consumed = true;
            }
        }
        return consumed;
    }

    public boolean onKey(KeyEvent event) {
        boolean consumed = false;
        event.getDeviceId();
        event.getSource();
        AndroidJoystick joystick = this.joystickIndex.get(event.getDeviceId());
        if (joystick != null) {
            boolean pressed;
            JoystickButton button = joystick.getButton(event.getKeyCode());
            boolean bl = pressed = event.getAction() == 0;
            if (button != null) {
                JoyButtonEvent buttonEvent = new JoyButtonEvent(button, pressed);
                this.joyInput.addEvent((InputEvent)buttonEvent);
                consumed = true;
            } else {
                JoystickButton newButton = joystick.addButton(event.getKeyCode());
                JoyButtonEvent buttonEvent = new JoyButtonEvent(newButton, pressed);
                this.joyInput.addEvent((InputEvent)buttonEvent);
                consumed = true;
            }
        }
        return consumed;
    }

    protected class AndroidJoystick
    extends AbstractJoystick {
        private JoystickAxis nullAxis;
        private InputDevice device;
        private JoystickAxis xAxis;
        private JoystickAxis yAxis;
        private JoystickAxis povX;
        private JoystickAxis povY;
        private Map<Integer, JoystickAxis> axisIndex;
        private Map<Integer, JoystickButton> buttonIndex;

        public AndroidJoystick(InputManager inputManager, JoyInput joyInput, InputDevice device, int joyId, String name) {
            super(inputManager, joyInput, joyId, name);
            this.axisIndex = new HashMap<Integer, JoystickAxis>();
            this.buttonIndex = new HashMap<Integer, JoystickButton>();
            this.device = device;
            this.xAxis = this.nullAxis = new DefaultJoystickAxis(this.getInputManager(), (Joystick)this, -1, "Null", "null", false, false, 0.0f);
            this.yAxis = this.nullAxis;
            this.povX = this.nullAxis;
            this.povY = this.nullAxis;
        }

        protected JoystickAxis getAxis(int androidAxis) {
            return this.axisIndex.get(androidAxis);
        }

        protected Set<Integer> getAndroidAxes() {
            return this.axisIndex.keySet();
        }

        protected JoystickButton getButton(int keyCode) {
            return this.buttonIndex.get(keyCode);
        }

        protected JoystickButton addButton(int keyCode) {
            String name = KeyEvent.keyCodeToString((int)keyCode);
            String original = KeyEvent.keyCodeToString((int)keyCode);
            if (keyCode == 100) {
                original = "0";
            } else if (keyCode == 97) {
                original = "1";
            } else if (keyCode == 96) {
                original = "2";
            } else if (keyCode == 99) {
                original = "3";
            } else if (keyCode == 102) {
                original = "4";
            } else if (keyCode == 103) {
                original = "5";
            } else if (keyCode == 104) {
                original = "6";
            } else if (keyCode == 105) {
                original = "7";
            } else if (keyCode == 109) {
                original = "8";
            } else if (keyCode == 108) {
                original = "9";
            } else if (keyCode == 106) {
                original = "10";
            } else if (keyCode == 107) {
                original = "11";
            }
            String logicalId = JoystickCompatibilityMappings.remapButton((String)this.getName(), (String)original);
            if (logger.isLoggable(Level.FINE) && !Objects.equals(logicalId, original)) {
                logger.log(Level.FINE, "Remapped: {0} to: {1}", new Object[]{original, logicalId});
            }
            DefaultJoystickButton button = new DefaultJoystickButton(this.getInputManager(), (Joystick)this, this.getButtonCount(), name, logicalId);
            this.addButton((JoystickButton)button);
            this.buttonIndex.put(keyCode, (JoystickButton)button);
            return button;
        }

        protected JoystickAxis addAxis(InputDevice.MotionRange motionRange) {
            String name = MotionEvent.axisToString((int)motionRange.getAxis());
            String original = MotionEvent.axisToString((int)motionRange.getAxis());
            if (motionRange.getAxis() == 0) {
                original = "x";
            } else if (motionRange.getAxis() == 1) {
                original = "y";
            } else if (motionRange.getAxis() == 11) {
                original = "z";
            } else if (motionRange.getAxis() == 14) {
                original = "rz";
            } else if (motionRange.getAxis() == 15) {
                original = "pov_x";
            } else if (motionRange.getAxis() == 16) {
                original = "pov_y";
            }
            String logicalId = JoystickCompatibilityMappings.remapAxis((String)this.getName(), (String)original);
            if (logger.isLoggable(Level.FINE) && !Objects.equals(logicalId, original)) {
                logger.log(Level.FINE, "Remapped: {0} to: {1}", new Object[]{original, logicalId});
            }
            DefaultJoystickAxis axis = new DefaultJoystickAxis(this.getInputManager(), (Joystick)this, this.getAxisCount(), name, logicalId, true, true, motionRange.getFlat());
            if (motionRange.getAxis() == 0) {
                this.xAxis = axis;
            }
            if (motionRange.getAxis() == 1) {
                this.yAxis = axis;
            }
            if (motionRange.getAxis() == 15) {
                this.povX = axis;
            }
            if (motionRange.getAxis() == 16) {
                this.povY = axis;
            }
            this.addAxis((JoystickAxis)axis);
            this.axisIndex.put(motionRange.getAxis(), (JoystickAxis)axis);
            return axis;
        }

        public JoystickAxis getXAxis() {
            return this.xAxis;
        }

        public JoystickAxis getYAxis() {
            return this.yAxis;
        }

        public JoystickAxis getPovXAxis() {
            return this.povX;
        }

        public JoystickAxis getPovYAxis() {
            return this.povY;
        }

        public int getXAxisIndex() {
            return this.xAxis.getAxisId();
        }

        public int getYAxisIndex() {
            return this.yAxis.getAxisId();
        }
    }
}

