/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.android;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.opengl.GLSurfaceView;
import android.view.WindowManager;
import com.jme3.input.AbstractJoystick;
import com.jme3.input.DefaultJoystickAxis;
import com.jme3.input.InputManager;
import com.jme3.input.JoyInput;
import com.jme3.input.Joystick;
import com.jme3.input.JoystickAxis;
import com.jme3.input.SensorJoystickAxis;
import com.jme3.input.android.AndroidJoyInput;
import com.jme3.input.event.InputEvent;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.util.IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AndroidSensorJoyInput
implements SensorEventListener {
    private static final Logger logger = Logger.getLogger(AndroidSensorJoyInput.class.getName());
    private AndroidJoyInput joyInput;
    private SensorManager sensorManager = null;
    private WindowManager windowManager = null;
    private IntMap<SensorData> sensors = new IntMap();
    private int lastRotation = 0;
    private boolean loaded = false;

    public AndroidSensorJoyInput(AndroidJoyInput joyInput) {
        this.joyInput = joyInput;
    }

    public void setView(GLSurfaceView view) {
        this.pauseSensors();
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
        if (view == null) {
            this.windowManager = null;
            this.sensorManager = null;
        } else {
            this.windowManager = (WindowManager)view.getContext().getSystemService("window");
            this.sensorManager = (SensorManager)view.getContext().getSystemService("sensor");
        }
    }

    private SensorData initSensor(int sensorType) {
        boolean success = false;
        SensorData sensorData = (SensorData)this.sensors.get(sensorType);
        if (sensorData != null) {
            this.unRegisterListener(sensorType);
        } else {
            sensorData = new SensorData(sensorType, null);
            this.sensors.put(sensorType, (Object)sensorData);
        }
        sensorData.androidSensorType = sensorType;
        sensorData.sensor = this.sensorManager.getDefaultSensor(sensorType);
        if (sensorData.sensor != null) {
            logger.log(Level.FINE, "Sensor Type {0} found.", sensorType);
            success = this.registerListener(sensorType);
        } else {
            logger.log(Level.FINE, "Sensor Type {0} not found.", sensorType);
        }
        if (success) {
            return sensorData;
        }
        return null;
    }

    private boolean registerListener(int sensorType) {
        SensorData sensorData = (SensorData)this.sensors.get(sensorType);
        if (sensorData != null) {
            if (sensorData.enabled) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Sensor Already Active: SensorType: {0}, active: {1}", new Object[]{sensorType, sensorData.enabled});
                }
                return true;
            }
            sensorData.haveData = false;
            if (sensorData.sensor != null) {
                if (this.sensorManager.registerListener((SensorEventListener)this, sensorData.sensor, sensorData.androidSensorSpeed)) {
                    sensorData.enabled = true;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "SensorType: {0}, enabled: {1}", new Object[]{sensorType, sensorData.enabled});
                    }
                    return true;
                }
                sensorData.enabled = false;
                logger.log(Level.FINE, "Sensor Type {0} activation failed.", sensorType);
            }
        }
        return false;
    }

    private void unRegisterListener(int sensorType) {
        SensorData sensorData = (SensorData)this.sensors.get(sensorType);
        if (sensorData != null) {
            if (sensorData.sensor != null) {
                this.sensorManager.unregisterListener((SensorEventListener)this, sensorData.sensor);
            }
            sensorData.enabled = false;
            sensorData.haveData = false;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "SensorType: {0} deactivated, active: {1}", new Object[]{sensorType, sensorData.enabled});
            }
        }
    }

    public void pauseSensors() {
        for (IntMap.Entry entry : this.sensors) {
            if (entry.getKey() == 3) continue;
            this.unRegisterListener(entry.getKey());
        }
    }

    public void resumeSensors() {
        for (IntMap.Entry entry : this.sensors) {
            if (entry.getKey() == 3) continue;
            this.registerListener(entry.getKey());
        }
    }

    private boolean remapCoordinates(float[] inR, float[] outR) {
        int xDir = 1;
        int yDir = 2;
        int curRotation = this.getScreenRotation();
        if (this.lastRotation != curRotation) {
            logger.log(Level.FINE, "Device Rotation changed to: {0}", curRotation);
        }
        this.lastRotation = curRotation;
        switch (this.getScreenRotation()) {
            case 0: {
                xDir = 1;
                yDir = 2;
                break;
            }
            case 1: {
                xDir = 2;
                yDir = 129;
                break;
            }
            case 2: {
                xDir = 129;
                yDir = 130;
                break;
            }
            case 3: {
                xDir = 130;
                yDir = 1;
                break;
            }
        }
        return SensorManager.remapCoordinateSystem((float[])inR, (int)xDir, (int)yDir, (float[])outR);
    }

    private int getScreenRotation() {
        return this.windowManager.getDefaultDisplay().getRotation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateOrientation() {
        float[] curInclinationMat = new float[16];
        float[] curRotationMat = new float[16];
        float[] rotatedRotationMat = new float[16];
        float[] accValues = new float[3];
        float[] magValues = new float[3];
        float[] orderedOrientation = new float[3];
        SensorData sensorData = (SensorData)this.sensors.get(1);
        if (sensorData == null || !sensorData.enabled || !sensorData.haveData) {
            return false;
        }
        if (sensorData.sensorAccuracy == 0) {
            return false;
        }
        Object object = sensorData.valuesLock;
        synchronized (object) {
            accValues[0] = sensorData.lastValues[0];
            accValues[1] = sensorData.lastValues[1];
            accValues[2] = sensorData.lastValues[2];
        }
        sensorData = (SensorData)this.sensors.get(2);
        if (sensorData == null || !sensorData.enabled || !sensorData.haveData) {
            return false;
        }
        if (sensorData.sensorAccuracy == 0) {
            return false;
        }
        object = sensorData.valuesLock;
        synchronized (object) {
            magValues[0] = sensorData.lastValues[0];
            magValues[1] = sensorData.lastValues[1];
            magValues[2] = sensorData.lastValues[2];
        }
        if (SensorManager.getRotationMatrix((float[])curRotationMat, (float[])curInclinationMat, (float[])accValues, (float[])magValues)) {
            float[] orientValues = new float[3];
            if (this.remapCoordinates(curRotationMat, rotatedRotationMat)) {
                SensorManager.getOrientation((float[])rotatedRotationMat, (float[])orientValues);
                orderedOrientation[0] = orientValues[1];
                orderedOrientation[1] = orientValues[2];
                orderedOrientation[2] = orientValues[0];
                sensorData = (SensorData)this.sensors.get(3);
                if (sensorData != null && sensorData.axes.size() > 0) {
                    for (int i = 0; i < orderedOrientation.length; ++i) {
                        AndroidSensorJoystickAxis axis = sensorData.axes.get(i);
                        if (axis == null) continue;
                        axis.setCurRawValue(orderedOrientation[i]);
                        if (!sensorData.haveData) {
                            sensorData.haveData = true;
                            continue;
                        }
                        if (!axis.isChanged()) continue;
                        this.joyInput.addEvent((InputEvent)new JoyAxisEvent((JoystickAxis)axis, axis.getJoystickAxisValue(), axis.getJoystickAxisValue()));
                    }
                } else if (sensorData != null && !sensorData.haveData) {
                    sensorData.haveData = true;
                }
                return true;
            }
            logger.log(Level.FINE, "remapCoordinateSystem failed");
        } else {
            logger.log(Level.FINE, "getRotationMatrix returned false");
        }
        return false;
    }

    public Joystick loadJoystick(int joyId, InputManager inputManager) {
        AndroidSensorJoystick joystick = new AndroidSensorJoystick(inputManager, this.joyInput, joyId, "AndroidSensorsJoystick");
        List availSensors = this.sensorManager.getSensorList(-1);
        if (logger.isLoggable(Level.FINE)) {
            for (Sensor sensor : availSensors) {
                logger.log(Level.FINE, "{0} Sensor is available, Type: {1}, Vendor: {2}, Version: {3}", new Object[]{sensor.getName(), sensor.getType(), sensor.getVendor(), sensor.getVersion()});
            }
        }
        SensorData sensorData = new SensorData(3, null);
        sensorData.lastValues = new float[3];
        this.sensors.put(3, (Object)sensorData);
        AndroidSensorJoystickAxis axis = joystick.addAxis("Orientation_X", "Orientation_X", joystick.getAxisCount(), 1.5707964f);
        joystick.setYAxis((JoystickAxis)axis);
        sensorData.axes.add(axis);
        axis = joystick.addAxis("Orientation_Y", "Orientation_Y", joystick.getAxisCount(), 1.5707964f);
        joystick.setXAxis((JoystickAxis)axis);
        sensorData.axes.add(axis);
        axis = joystick.addAxis("Orientation_Z", "Orientation_Z", joystick.getAxisCount(), 1.5707964f);
        sensorData.axes.add(axis);
        sensorData = this.initSensor(2);
        if (sensorData != null) {
            sensorData.lastValues = new float[3];
            this.sensors.put(2, (Object)sensorData);
        }
        if ((sensorData = this.initSensor(1)) != null) {
            sensorData.lastValues = new float[3];
            this.sensors.put(1, (Object)sensorData);
        }
        this.loaded = true;
        return joystick;
    }

    public void update() {
        if (!this.loaded) {
            return;
        }
        this.updateOrientation();
    }

    public void destroy() {
        logger.log(Level.FINE, "Doing Destroy.");
        this.pauseSensors();
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
        this.sensors.clear();
        this.loaded = false;
        this.sensorManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSensorChanged(SensorEvent se) {
        if (!this.loaded) {
            return;
        }
        int sensorType = se.sensor.getType();
        SensorData sensorData = (SensorData)this.sensors.get(sensorType);
        if (sensorData != null) {
            // empty if block
        }
        if (sensorData != null && sensorData.sensor.equals(se.sensor) && sensorData.enabled) {
            int i;
            if (sensorData.sensorAccuracy == 0) {
                return;
            }
            Object object = sensorData.valuesLock;
            synchronized (object) {
                for (i = 0; i < sensorData.lastValues.length; ++i) {
                    sensorData.lastValues[i] = se.values[i];
                }
            }
            if (sensorData.axes.size() > 0) {
                for (i = 0; i < se.values.length; ++i) {
                    AndroidSensorJoystickAxis axis = sensorData.axes.get(i);
                    if (axis == null) continue;
                    axis.setCurRawValue(se.values[i]);
                    if (!sensorData.haveData) {
                        sensorData.haveData = true;
                        continue;
                    }
                    if (!axis.isChanged()) continue;
                    JoyAxisEvent event = new JoyAxisEvent((JoystickAxis)axis, axis.getJoystickAxisValue(), axis.getJoystickAxisValue());
                    this.joyInput.addEvent((InputEvent)event);
                }
            } else if (!sensorData.haveData) {
                sensorData.haveData = true;
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int i) {
        int sensorType = sensor.getType();
        SensorData sensorData = (SensorData)this.sensors.get(sensorType);
        if (sensorData != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "onAccuracyChanged for {0}: accuracy: {1}", new Object[]{sensor.getName(), i});
                logger.log(Level.FINE, "MaxRange: {0}, Resolution: {1}", new Object[]{Float.valueOf(sensor.getMaximumRange()), Float.valueOf(sensor.getResolution())});
            }
            sensorData.sensorAccuracy = i;
        }
    }

    private class SensorData {
        int androidSensorType = -1;
        int androidSensorSpeed = 1;
        Sensor sensor = null;
        int sensorAccuracy = -1;
        float[] lastValues;
        final Object valuesLock = new Object();
        ArrayList<AndroidSensorJoystickAxis> axes = new ArrayList();
        boolean enabled = false;
        boolean haveData = false;

        public SensorData(int androidSensorType, Sensor sensor) {
            this.androidSensorType = androidSensorType;
            this.sensor = sensor;
        }
    }

    public class AndroidSensorJoystickAxis
    extends DefaultJoystickAxis
    implements SensorJoystickAxis {
        float zeroRawValue;
        float curRawValue;
        float lastRawValue;
        boolean hasChanged;
        float maxRawValue;
        boolean enabled;

        public AndroidSensorJoystickAxis(InputManager inputManager, Joystick parent, int axisIndex, String name, String logicalId, boolean isAnalog, boolean isRelative, float deadZone, float maxRawValue) {
            super(inputManager, parent, axisIndex, name, logicalId, isAnalog, isRelative, deadZone);
            this.zeroRawValue = 0.0f;
            this.curRawValue = 0.0f;
            this.lastRawValue = 0.0f;
            this.hasChanged = false;
            this.maxRawValue = 1.5707964f;
            this.enabled = true;
            this.maxRawValue = maxRawValue;
        }

        public float getMaxRawValue() {
            return this.maxRawValue;
        }

        public void setMaxRawValue(float maxRawValue) {
            this.maxRawValue = maxRawValue;
        }

        protected float getLastRawValue() {
            return this.lastRawValue;
        }

        protected void setCurRawValue(float rawValue) {
            this.curRawValue = rawValue;
            if (Math.abs(this.curRawValue - this.lastRawValue) > this.getDeadZone()) {
                this.hasChanged = true;
                this.lastRawValue = this.curRawValue;
            } else {
                this.hasChanged = false;
            }
        }

        protected float getJoystickAxisValue() {
            return (this.lastRawValue - this.zeroRawValue) / this.maxRawValue;
        }

        protected boolean isChanged() {
            return this.hasChanged;
        }

        public void calibrateCenter() {
            this.zeroRawValue = this.lastRawValue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Calibrating axis {0} to {1}", new Object[]{this.getName(), Float.valueOf(this.zeroRawValue)});
            }
        }
    }

    protected class AndroidSensorJoystick
    extends AbstractJoystick {
        private JoystickAxis nullAxis;
        private JoystickAxis xAxis;
        private JoystickAxis yAxis;
        private JoystickAxis povX;
        private JoystickAxis povY;

        public AndroidSensorJoystick(InputManager inputManager, JoyInput joyInput, int joyId, String name) {
            super(inputManager, joyInput, joyId, name);
            this.xAxis = this.nullAxis = new DefaultJoystickAxis(this.getInputManager(), (Joystick)this, -1, "Null", "null", false, false, 0.0f);
            this.yAxis = this.nullAxis;
            this.povX = this.nullAxis;
            this.povY = this.nullAxis;
        }

        protected AndroidSensorJoystickAxis addAxis(String axisName, String logicalName, int axisNum, float maxRawValue) {
            AndroidSensorJoystickAxis axis = new AndroidSensorJoystickAxis(this.getInputManager(), (Joystick)this, axisNum, axisName, logicalName, true, false, 0.01f, maxRawValue);
            super.addAxis((JoystickAxis)axis);
            return axis;
        }

        protected void setXAxis(JoystickAxis axis) {
            this.xAxis = axis;
        }

        protected void setYAxis(JoystickAxis axis) {
            this.yAxis = axis;
        }

        public JoystickAxis getXAxis() {
            return this.xAxis;
        }

        public JoystickAxis getYAxis() {
            return this.yAxis;
        }

        public JoystickAxis getPovXAxis() {
            return this.povX;
        }

        public JoystickAxis getPovYAxis() {
            return this.povY;
        }
    }
}

