/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.android;

import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import com.jme3.input.RawInputListener;
import com.jme3.input.TouchInput;
import com.jme3.input.android.AndroidInputHandler;
import com.jme3.input.android.AndroidKeyMapping;
import com.jme3.input.android.TouchEventPool;
import com.jme3.input.event.InputEvent;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.input.event.TouchEvent;
import com.jme3.math.Vector2f;
import com.jme3.system.AppSettings;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AndroidTouchInput
implements TouchInput {
    private static final Logger logger = Logger.getLogger(AndroidTouchInput.class.getName());
    private boolean mouseEventsEnabled = true;
    private boolean mouseEventsInvertX = false;
    private boolean mouseEventsInvertY = false;
    private boolean keyboardEventsEnabled = false;
    protected int numPointers = 0;
    private final HashMap<Integer, Vector2f> lastPositions = new HashMap();
    private final ConcurrentLinkedQueue<InputEvent> inputEventQueue = new ConcurrentLinkedQueue();
    private static final int MAX_TOUCH_EVENTS = 1024;
    private final TouchEventPool touchEventPool = new TouchEventPool(1024);
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private boolean initialized = false;
    private RawInputListener listener = null;
    private GestureDetector gestureDetector;
    private ScaleGestureDetector scaleDetector;
    protected AndroidInputHandler androidInput;

    public AndroidTouchInput(AndroidInputHandler androidInput) {
        this.androidInput = androidInput;
    }

    public GestureDetector getGestureDetector() {
        return this.gestureDetector;
    }

    public void setGestureDetector(GestureDetector gestureDetector) {
        this.gestureDetector = gestureDetector;
    }

    public ScaleGestureDetector getScaleDetector() {
        return this.scaleDetector;
    }

    public void setScaleDetector(ScaleGestureDetector scaleDetector) {
        this.scaleDetector = scaleDetector;
    }

    public float invertX(float origX) {
        return this.getJmeX(this.androidInput.getView().getWidth()) - origX;
    }

    public float invertY(float origY) {
        return this.getJmeY(this.androidInput.getView().getHeight()) - origY;
    }

    public float getJmeX(float origX) {
        return origX * this.scaleX;
    }

    public float getJmeY(float origY) {
        return origY * this.scaleY;
    }

    public void loadSettings(AppSettings settings) {
        this.keyboardEventsEnabled = settings.isEmulateKeyboard();
        this.mouseEventsEnabled = settings.isEmulateMouse();
        this.mouseEventsInvertX = settings.isEmulateMouseFlipX();
        this.mouseEventsInvertY = settings.isEmulateMouseFlipY();
        if (this.androidInput.getView().getWidth() != 0 && this.androidInput.getView().getHeight() != 0) {
            this.scaleX = (float)settings.getWidth() / (float)this.androidInput.getView().getWidth();
            this.scaleY = (float)settings.getHeight() / (float)this.androidInput.getView().getHeight();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Setting input scaling, scaleX: {0}, scaleY: {1}", new Object[]{Float.valueOf(this.scaleX), Float.valueOf(this.scaleY)});
        }
    }

    protected int getPointerIndex(MotionEvent event) {
        return (event.getAction() & 0xFF00) >> 8;
    }

    protected int getPointerId(MotionEvent event) {
        return event.getPointerId(this.getPointerIndex(event));
    }

    protected int getAction(MotionEvent event) {
        return event.getAction() & 0xFF;
    }

    public boolean onTouch(MotionEvent event) {
        if (!this.isInitialized()) {
            return false;
        }
        boolean bWasHandled = false;
        TouchEvent touch = null;
        this.getAction(event);
        int pointerIndex = this.getPointerIndex(event);
        int pointerId = this.getPointerId(event);
        Vector2f lastPos = this.lastPositions.get(pointerId);
        this.numPointers = event.getPointerCount();
        switch (this.getAction(event)) {
            case 0: 
            case 5: {
                float jmeX = this.getJmeX(event.getX(pointerIndex));
                float jmeY = this.invertY(this.getJmeY(event.getY(pointerIndex)));
                touch = this.getFreeTouchEvent();
                touch.set(TouchEvent.Type.DOWN, jmeX, jmeY, 0.0f, 0.0f);
                touch.setPointerId(pointerId);
                touch.setTime(event.getEventTime());
                touch.setPressure(event.getPressure(pointerIndex));
                lastPos = new Vector2f(jmeX, jmeY);
                this.lastPositions.put(pointerId, lastPos);
                this.addEvent((InputEvent)touch);
                this.addEvent(this.generateMouseEvent(touch));
                bWasHandled = true;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                float jmeX = this.getJmeX(event.getX(pointerIndex));
                float jmeY = this.invertY(this.getJmeY(event.getY(pointerIndex)));
                touch = this.getFreeTouchEvent();
                touch.set(TouchEvent.Type.UP, jmeX, jmeY, 0.0f, 0.0f);
                touch.setPointerId(pointerId);
                touch.setTime(event.getEventTime());
                touch.setPressure(event.getPressure(pointerIndex));
                this.lastPositions.remove(pointerId);
                this.addEvent((InputEvent)touch);
                this.addEvent(this.generateMouseEvent(touch));
                bWasHandled = true;
                break;
            }
            case 2: {
                for (int p = 0; p < event.getPointerCount(); ++p) {
                    float jmeX = this.getJmeX(event.getX(p));
                    float jmeY = this.invertY(this.getJmeY(event.getY(p)));
                    lastPos = this.lastPositions.get(event.getPointerId(p));
                    if (lastPos == null) {
                        lastPos = new Vector2f(jmeX, jmeY);
                        this.lastPositions.put(event.getPointerId(p), lastPos);
                    }
                    float dX = jmeX - lastPos.x;
                    float dY = jmeY - lastPos.y;
                    if (dX == 0.0f && dY == 0.0f) continue;
                    touch = this.getFreeTouchEvent();
                    touch.set(TouchEvent.Type.MOVE, jmeX, jmeY, dX, dY);
                    touch.setPointerId(event.getPointerId(p));
                    touch.setTime(event.getEventTime());
                    touch.setPressure(event.getPressure(p));
                    lastPos.set(jmeX, jmeY);
                    this.addEvent((InputEvent)touch);
                    this.addEvent(this.generateMouseEvent(touch));
                    bWasHandled = true;
                }
                break;
            }
        }
        if (this.gestureDetector != null) {
            this.gestureDetector.onTouchEvent(event);
        }
        if (this.scaleDetector != null) {
            this.scaleDetector.onTouchEvent(event);
        }
        return bWasHandled;
    }

    public InputEvent generateMouseEvent(TouchEvent event) {
        int newDY;
        int newY;
        int newDX;
        int newX;
        MouseButtonEvent inputEvent = null;
        if (!this.isSimulateMouse() || this.numPointers > 1) {
            return null;
        }
        if (this.isMouseEventsInvertX()) {
            newX = (int)this.invertX(event.getX());
            newDX = (int)event.getDeltaX() * -1;
        } else {
            newX = (int)event.getX();
            newDX = (int)event.getDeltaX();
        }
        if (this.isMouseEventsInvertY()) {
            newY = (int)this.invertY(event.getY());
            newDY = (int)event.getDeltaY() * -1;
        } else {
            newY = (int)event.getY();
            newDY = (int)event.getDeltaY();
        }
        switch (event.getType()) {
            case DOWN: {
                inputEvent = new MouseButtonEvent(0, true, newX, newY);
                inputEvent.setTime(event.getTime());
                break;
            }
            case UP: {
                inputEvent = new MouseButtonEvent(0, false, newX, newY);
                inputEvent.setTime(event.getTime());
                break;
            }
            case HOVER_MOVE: 
            case MOVE: {
                inputEvent = new MouseMotionEvent(newX, newY, newDX, newDY, (int)event.getScaleSpan(), (int)event.getDeltaScaleSpan());
                inputEvent.setTime(event.getTime());
            }
        }
        return inputEvent;
    }

    public boolean onKey(KeyEvent event) {
        if (!this.isInitialized()) {
            return false;
        }
        if (event.getAction() == 0) {
            TouchEvent evt = new TouchEvent();
            evt.set(TouchEvent.Type.KEY_DOWN);
            evt.setKeyCode(event.getKeyCode());
            evt.setCharacters(event.getCharacters());
            evt.setTime(event.getEventTime());
            this.addEvent((InputEvent)evt);
        } else if (event.getAction() == 1) {
            TouchEvent evt = new TouchEvent();
            evt.set(TouchEvent.Type.KEY_UP);
            evt.setKeyCode(event.getKeyCode());
            evt.setCharacters(event.getCharacters());
            evt.setTime(event.getEventTime());
            this.addEvent((InputEvent)evt);
        }
        if (this.isSimulateKeyboard()) {
            char unicodeChar = (char)event.getUnicodeChar();
            int jmeKeyCode = AndroidKeyMapping.getJmeKey(event.getKeyCode());
            boolean pressed = event.getAction() == 0;
            boolean repeating = pressed && event.getRepeatCount() > 0;
            KeyInputEvent kie = new KeyInputEvent(jmeKeyCode, unicodeChar, pressed, repeating);
            kie.setTime(event.getEventTime());
            this.addEvent((InputEvent)kie);
        }
        return event.getKeyCode() != 24 && event.getKeyCode() != 25 && event.getKeyCode() != 82;
    }

    public void initialize() {
        this.touchEventPool.initialize();
        this.initialized = true;
    }

    public void destroy() {
        this.initialized = false;
        this.touchEventPool.destroy();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
    }

    public long getInputTimeNanos() {
        return System.nanoTime();
    }

    public void update() {
        if (this.listener != null) {
            InputEvent inputEvent;
            while ((inputEvent = this.inputEventQueue.poll()) != null) {
                if (inputEvent instanceof TouchEvent) {
                    this.listener.onTouchEvent((TouchEvent)inputEvent);
                    continue;
                }
                if (inputEvent instanceof MouseButtonEvent) {
                    this.listener.onMouseButtonEvent((MouseButtonEvent)inputEvent);
                    continue;
                }
                if (inputEvent instanceof MouseMotionEvent) {
                    this.listener.onMouseMotionEvent((MouseMotionEvent)inputEvent);
                    continue;
                }
                if (!(inputEvent instanceof KeyInputEvent)) continue;
                this.listener.onKeyEvent((KeyInputEvent)inputEvent);
            }
        }
    }

    public TouchEvent getFreeTouchEvent() {
        return this.touchEventPool.getNextFreeEvent();
    }

    public void addEvent(InputEvent event) {
        if (event == null) {
            return;
        }
        this.inputEventQueue.add(event);
        if (event instanceof TouchEvent) {
            this.touchEventPool.storeEvent((TouchEvent)event);
        }
    }

    public void setSimulateMouse(boolean simulate) {
        this.mouseEventsEnabled = simulate;
    }

    public boolean isSimulateMouse() {
        return this.mouseEventsEnabled;
    }

    public boolean isMouseEventsInvertX() {
        return this.mouseEventsInvertX;
    }

    public boolean isMouseEventsInvertY() {
        return this.mouseEventsInvertY;
    }

    public void setSimulateKeyboard(boolean simulate) {
        this.keyboardEventsEnabled = simulate;
    }

    public boolean isSimulateKeyboard() {
        return this.keyboardEventsEnabled;
    }

    public void setOmitHistoricEvents(boolean dontSendHistory) {
    }
}

