/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.android;

import android.view.MotionEvent;
import com.jme3.input.android.AndroidInputHandler;
import com.jme3.input.android.AndroidTouchInput;
import com.jme3.input.event.InputEvent;
import com.jme3.input.event.TouchEvent;
import com.jme3.math.Vector2f;
import java.util.HashMap;
import java.util.logging.Logger;

public class AndroidTouchInput14
extends AndroidTouchInput {
    private static final Logger logger = Logger.getLogger(AndroidTouchInput14.class.getName());
    private final HashMap<Integer, Vector2f> lastHoverPositions = new HashMap();

    public AndroidTouchInput14(AndroidInputHandler androidInput) {
        super(androidInput);
    }

    public boolean onHover(MotionEvent event) {
        boolean consumed = false;
        int action = this.getAction(event);
        int pointerId = this.getPointerId(event);
        int pointerIndex = this.getPointerIndex(event);
        Vector2f lastPos = this.lastHoverPositions.get(pointerId);
        this.numPointers = event.getPointerCount();
        switch (action) {
            case 9: {
                float jmeX = this.getJmeX(event.getX(pointerIndex));
                float jmeY = this.invertY(this.getJmeY(event.getY(pointerIndex)));
                TouchEvent touchEvent = this.getFreeTouchEvent();
                touchEvent.set(TouchEvent.Type.HOVER_START, jmeX, jmeY, 0.0f, 0.0f);
                touchEvent.setPointerId(pointerId);
                touchEvent.setTime(event.getEventTime());
                touchEvent.setPressure(event.getPressure(pointerIndex));
                lastPos = new Vector2f(jmeX, jmeY);
                this.lastHoverPositions.put(pointerId, lastPos);
                this.addEvent((InputEvent)touchEvent);
                consumed = true;
                break;
            }
            case 7: {
                for (int p = 0; p < event.getPointerCount(); ++p) {
                    float jmeX = this.getJmeX(event.getX(p));
                    float jmeY = this.invertY(this.getJmeY(event.getY(p)));
                    lastPos = this.lastHoverPositions.get(event.getPointerId(p));
                    if (lastPos == null) {
                        lastPos = new Vector2f(jmeX, jmeY);
                        this.lastHoverPositions.put(event.getPointerId(p), lastPos);
                    }
                    float dX = jmeX - lastPos.x;
                    float dY = jmeY - lastPos.y;
                    if (dX == 0.0f && dY == 0.0f) continue;
                    TouchEvent touchEvent = this.getFreeTouchEvent();
                    touchEvent.set(TouchEvent.Type.HOVER_MOVE, jmeX, jmeY, dX, dY);
                    touchEvent.setPointerId(event.getPointerId(p));
                    touchEvent.setTime(event.getEventTime());
                    touchEvent.setPressure(event.getPressure(p));
                    lastPos.set(jmeX, jmeY);
                    this.addEvent((InputEvent)touchEvent);
                }
                consumed = true;
                break;
            }
            case 10: {
                float jmeX = this.getJmeX(event.getX(pointerIndex));
                float jmeY = this.invertY(this.getJmeY(event.getY(pointerIndex)));
                TouchEvent touchEvent = this.getFreeTouchEvent();
                touchEvent.set(TouchEvent.Type.HOVER_END, jmeX, jmeY, 0.0f, 0.0f);
                touchEvent.setPointerId(pointerId);
                touchEvent.setTime(event.getEventTime());
                touchEvent.setPressure(event.getPressure(pointerIndex));
                this.lastHoverPositions.remove(pointerId);
                this.addEvent((InputEvent)touchEvent);
                consumed = true;
                break;
            }
            default: {
                consumed = false;
            }
        }
        return consumed;
    }
}

