/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.android;

import android.opengl.GLES20;
import android.opengl.GLU;
import com.jme3.renderer.RendererException;
import javax.microedition.khronos.egl.EGL10;

public class RendererUtil {
    public static boolean ENABLE_ERROR_CHECKING = true;

    private RendererUtil() {
    }

    public static void checkGLErrorForced() {
        int error = GLES20.glGetError();
        if (error != 0) {
            String message = GLU.gluErrorString((int)error);
            if (message == null) {
                throw new RendererException("An unknown OpenGL error has occurred.");
            }
            throw new RendererException("An OpenGL error has occurred: " + message);
        }
    }

    public static void checkEGLError(EGL10 egl) {
        int error = egl.eglGetError();
        if (error != 12288) {
            String errorMessage;
            switch (error) {
                case 12289: {
                    errorMessage = "EGL is not initialized, or could not be initialized, for the specified EGL display connection. ";
                    break;
                }
                case 12290: {
                    errorMessage = "EGL cannot access a requested resource (for example a context is bound in another thread). ";
                    break;
                }
                case 12291: {
                    errorMessage = "EGL failed to allocate resources for the requested operation.";
                    break;
                }
                case 12292: {
                    errorMessage = "An unrecognized attribute or attribute value was passed in the attribute list. ";
                    break;
                }
                case 12294: {
                    errorMessage = "An EGLContext argument does not name a valid EGL rendering context. ";
                    break;
                }
                case 12293: {
                    errorMessage = "An EGLConfig argument does not name a valid EGL frame buffer configuration. ";
                    break;
                }
                case 12295: {
                    errorMessage = "The current surface of the calling thread is a window, pixel buffer or pixmap that is no longer valid. ";
                    break;
                }
                case 12296: {
                    errorMessage = "An EGLDisplay argument does not name a valid EGL display connection. ";
                    break;
                }
                case 12301: {
                    errorMessage = "An EGLSurface argument does not name a valid surface (window, pixel buffer or pixmap) configured for GL rendering. ";
                    break;
                }
                case 12297: {
                    errorMessage = "Arguments are inconsistent (for example, a valid context requires buffers not supplied by a valid surface). ";
                    break;
                }
                case 12300: {
                    errorMessage = "One or more argument values are invalid.";
                    break;
                }
                case 12298: {
                    errorMessage = "A NativePixmapType argument does not refer to a valid native pixmap. ";
                    break;
                }
                case 12299: {
                    errorMessage = "A NativeWindowType argument does not refer to a valid native window. ";
                    break;
                }
                case 12302: {
                    errorMessage = "A power management event has occurred. The application must destroy all contexts and reinitialise OpenGL ES state and objects to continue rendering. ";
                    break;
                }
                default: {
                    errorMessage = "Unknown";
                }
            }
            throw new RendererException("EGL error 0x" + Integer.toHexString(error) + ": " + errorMessage);
        }
    }

    public static void checkGLError() {
        if (!ENABLE_ERROR_CHECKING) {
            return;
        }
        int error = GLES20.glGetError();
        if (error != 0) {
            String message = GLU.gluErrorString((int)error);
            if (message == null) {
                throw new RendererException("An unknown OpenGL error has occurred.");
            }
            throw new RendererException("An OpenGL error has occurred: " + message);
        }
    }
}

