/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.android;

import android.opengl.GLSurfaceView;
import com.jme3.renderer.RendererException;
import com.jme3.renderer.android.RendererUtil;
import com.jme3.system.AppSettings;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;

public class AndroidConfigChooser
implements GLSurfaceView.EGLConfigChooser {
    private static final Logger logger = Logger.getLogger(AndroidConfigChooser.class.getName());
    protected AppSettings settings;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    private static final int EGL_OPENGL_ES3_BIT = 64;

    public AndroidConfigChooser(AppSettings settings) {
        this.settings = settings;
    }

    public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
        logger.fine("GLSurfaceView asking for egl config");
        Config requestedConfig = this.getRequestedConfig();
        EGLConfig[] configs = this.getConfigs(egl, display);
        EGLConfig chosenConfig = this.chooseConfig(egl, display, configs, requestedConfig, false, false, false, true);
        if (chosenConfig == null && requestedConfig.d > 16) {
            logger.log(Level.INFO, "EGL configuration not found, reducing depth");
            requestedConfig.d = 16;
            chosenConfig = this.chooseConfig(egl, display, configs, requestedConfig, false, false, false, true);
        }
        if (chosenConfig == null) {
            logger.log(Level.INFO, "EGL configuration not found, allowing higher RGB");
            chosenConfig = this.chooseConfig(egl, display, configs, requestedConfig, true, false, false, true);
        }
        if (chosenConfig == null && requestedConfig.a > 0) {
            logger.log(Level.INFO, "EGL configuration not found, allowing higher alpha");
            chosenConfig = this.chooseConfig(egl, display, configs, requestedConfig, true, true, false, true);
        }
        if (chosenConfig == null && requestedConfig.s > 0) {
            logger.log(Level.INFO, "EGL configuration not found, allowing higher samples");
            chosenConfig = this.chooseConfig(egl, display, configs, requestedConfig, true, true, true, true);
        }
        if (chosenConfig == null && requestedConfig.a > 0) {
            logger.log(Level.INFO, "EGL configuration not found, reducing alpha");
            requestedConfig.a = 1;
            chosenConfig = this.chooseConfig(egl, display, configs, requestedConfig, true, true, false, true);
        }
        if (chosenConfig == null && requestedConfig.s > 0) {
            logger.log(Level.INFO, "EGL configuration not found, reducing samples");
            requestedConfig.s = 1;
            chosenConfig = requestedConfig.a > 0 ? this.chooseConfig(egl, display, configs, requestedConfig, true, true, true, true) : this.chooseConfig(egl, display, configs, requestedConfig, true, false, true, true);
        }
        if (chosenConfig == null && requestedConfig.getBitsPerPixel() > 16) {
            logger.log(Level.INFO, "EGL configuration not found, setting to RGB565");
            requestedConfig.r = 5;
            requestedConfig.g = 6;
            requestedConfig.b = 5;
            chosenConfig = this.chooseConfig(egl, display, configs, requestedConfig, true, false, false, true);
            if (chosenConfig == null) {
                logger.log(Level.INFO, "EGL configuration not found, allowing higher alpha");
                chosenConfig = this.chooseConfig(egl, display, configs, requestedConfig, true, true, false, true);
            }
        }
        if (chosenConfig == null) {
            logger.log(Level.INFO, "EGL configuration not found, looking for best config with >= 16 bit Depth");
            requestedConfig = new Config(0, 0, 0, 0, 16, 0, 0);
            chosenConfig = this.chooseConfig(egl, display, configs, requestedConfig, true, false, false, true);
        }
        if (chosenConfig != null) {
            logger.fine("GLSurfaceView asks for egl config, returning: ");
            this.logEGLConfig(chosenConfig, display, egl, Level.FINE);
            this.storeSelectedConfig(egl, display, chosenConfig);
            return chosenConfig;
        }
        logger.severe("No EGL Config found");
        return null;
    }

    private Config getRequestedConfig() {
        int r;
        int g;
        int b;
        if (this.settings.getBitsPerPixel() == 24) {
            b = 8;
            g = 8;
            r = 8;
        } else {
            if (this.settings.getBitsPerPixel() != 16) {
                logger.log(Level.SEVERE, "Invalid bitsPerPixel setting: {0}, setting to RGB565 (16)", this.settings.getBitsPerPixel());
                this.settings.setBitsPerPixel(16);
            }
            r = 5;
            g = 6;
            b = 5;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Requested Display Config:");
            logger.log(Level.FINE, "RGB: {0}, alpha: {1}, depth: {2}, samples: {3}, stencil: {4}", new Object[]{this.settings.getBitsPerPixel(), this.settings.getAlphaBits(), this.settings.getDepthBits(), this.settings.getSamples(), this.settings.getStencilBits()});
        }
        return new Config(r, g, b, this.settings.getAlphaBits(), this.settings.getDepthBits(), this.settings.getSamples(), this.settings.getStencilBits());
    }

    private EGLConfig[] getConfigs(EGL10 egl, EGLDisplay display) {
        int numConfigs;
        EGLConfig[] configs;
        int[] num_config = new int[1];
        int[] configSpec = new int[]{12352, 64, 12344};
        boolean gles3 = true;
        try {
            if (!egl.eglChooseConfig(display, configSpec, null, 0, num_config)) {
                RendererUtil.checkEGLError(egl);
                gles3 = false;
            }
        }
        catch (RendererException re) {
            gles3 = false;
        }
        if (!gles3) {
            configSpec[1] = 4;
            if (!egl.eglChooseConfig(display, configSpec, null, 0, num_config)) {
                RendererUtil.checkEGLError(egl);
                throw new AssertionError();
            }
        }
        if (!egl.eglChooseConfig(display, configSpec, configs = new EGLConfig[numConfigs = num_config[0]], numConfigs, num_config)) {
            RendererUtil.checkEGLError(egl);
            throw new AssertionError();
        }
        logger.fine("--------------Display Configurations---------------");
        for (EGLConfig eGLConfig : configs) {
            this.logEGLConfig(eGLConfig, display, egl, Level.FINE);
            logger.fine("----------------------------------------");
        }
        return configs;
    }

    private EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs, Config requestedConfig, boolean higherRGB, boolean higherAlpha, boolean higherSamples, boolean higherStencil) {
        EGLConfig keptConfig = null;
        int kr = 0;
        int kg = 0;
        int kb = 0;
        int ka = 0;
        int kd = 0;
        int ks = 0;
        int kst = 0;
        for (EGLConfig config : configs) {
            int r = AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, config, 12324);
            int g = AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, config, 12323);
            int b = AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, config, 12322);
            int a = AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, config, 12321);
            int d = AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, config, 12325);
            int s = AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, config, 12337);
            int st = AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, config, 12326);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Checking Config r: {0}, g: {1}, b: {2}, alpha: {3}, depth: {4}, samples: {5}, stencil: {6}", new Object[]{r, g, b, a, d, s, st});
            }
            if (higherRGB && r < requestedConfig.r || !higherRGB && r != requestedConfig.r || higherRGB && g < requestedConfig.g || !higherRGB && g != requestedConfig.g || higherRGB && b < requestedConfig.b || !higherRGB && b != requestedConfig.b || higherAlpha && a < requestedConfig.a || !higherAlpha && a != requestedConfig.a || d < requestedConfig.d || higherSamples && s < requestedConfig.s || !higherSamples && s != requestedConfig.s || higherStencil && st < requestedConfig.st || !higherStencil && !this.inRange(st, 0, requestedConfig.st) || r < kr && g < kg && b < kb && a < ka && d < kd && s < ks && st < kst) continue;
            kr = r;
            kg = g;
            kb = b;
            ka = a;
            kd = d;
            ks = s;
            kst = st;
            keptConfig = config;
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "Keeping Config r: {0}, g: {1}, b: {2}, alpha: {3}, depth: {4}, samples: {5}, stencil: {6}", new Object[]{r, g, b, a, d, s, st});
        }
        if (keptConfig != null) {
            return keptConfig;
        }
        logger.log(Level.SEVERE, "No egl config match found");
        return null;
    }

    private static int eglGetConfigAttribSafe(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute) {
        int[] value = new int[1];
        if (!egl.eglGetConfigAttrib(display, config, attribute, value)) {
            RendererUtil.checkEGLError(egl);
            throw new AssertionError();
        }
        return value[0];
    }

    private void storeSelectedConfig(EGL10 egl, EGLDisplay display, EGLConfig eglConfig) {
        int r = AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, eglConfig, 12324);
        int g = AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, eglConfig, 12323);
        int b = AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, eglConfig, 12322);
        this.settings.setBitsPerPixel(r + g + b);
        this.settings.setAlphaBits(AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, eglConfig, 12321));
        this.settings.setDepthBits(AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, eglConfig, 12325));
        this.settings.setSamples(AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, eglConfig, 12337));
        this.settings.setStencilBits(AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, eglConfig, 12326));
    }

    private void logEGLConfig(EGLConfig conf, EGLDisplay display, EGL10 egl, Level level) {
        logger.log(level, "EGL_RED_SIZE = {0}", AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, conf, 12324));
        logger.log(level, "EGL_GREEN_SIZE = {0}", AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, conf, 12323));
        logger.log(level, "EGL_BLUE_SIZE = {0}", AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, conf, 12322));
        logger.log(level, "EGL_ALPHA_SIZE = {0}", AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, conf, 12321));
        logger.log(level, "EGL_DEPTH_SIZE = {0}", AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, conf, 12325));
        logger.log(level, "EGL_STENCIL_SIZE = {0}", AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, conf, 12326));
        logger.log(level, "EGL_RENDERABLE_TYPE = {0}", AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, conf, 12352));
        logger.log(level, "EGL_SURFACE_TYPE = {0}", AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, conf, 12339));
        logger.log(level, "EGL_SAMPLE_BUFFERS = {0}", AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, conf, 12338));
        logger.log(level, "EGL_SAMPLES = {0}", AndroidConfigChooser.eglGetConfigAttribSafe(egl, display, conf, 12337));
    }

    private boolean inRange(int val, int min, int max) {
        return min <= val && val <= max;
    }

    private class Config {
        int r;
        int g;
        int b;
        int a;
        int d;
        int s;
        int st;

        private Config(int r, int g, int b, int a, int d, int s, int st) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.d = d;
            this.s = s;
            this.st = st;
        }

        private int getBitsPerPixel() {
            return this.r + this.g + this.b;
        }
    }
}

