/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.animations;

import com.jme3.animation.BoneTrack;
import com.jme3.animation.SpatialTrack;
import com.jme3.animation.Track;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.curves.BezierCurve;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Ipo {
    private static final Logger LOGGER = Logger.getLogger(Ipo.class.getName());
    public static final int AC_LOC_X = 1;
    public static final int AC_LOC_Y = 2;
    public static final int AC_LOC_Z = 3;
    public static final int OB_ROT_X = 7;
    public static final int OB_ROT_Y = 8;
    public static final int OB_ROT_Z = 9;
    public static final int AC_SIZE_X = 13;
    public static final int AC_SIZE_Y = 14;
    public static final int AC_SIZE_Z = 15;
    public static final int AC_QUAT_W = 25;
    public static final int AC_QUAT_X = 26;
    public static final int AC_QUAT_Y = 27;
    public static final int AC_QUAT_Z = 28;
    private BezierCurve[] bezierCurves;
    private Track calculatedTrack;
    protected boolean fixUpAxis;
    protected final int blenderVersion;

    public Ipo(BezierCurve[] bezierCurves, boolean fixUpAxis, int blenderVersion) {
        this.bezierCurves = bezierCurves;
        this.fixUpAxis = fixUpAxis;
        this.blenderVersion = blenderVersion;
    }

    public double calculateValue(int frame) {
        return this.calculateValue(frame, 0);
    }

    public double calculateValue(int frame, int curveIndex) {
        return this.bezierCurves[curveIndex].evaluate(frame, 1);
    }

    public int getLastFrame() {
        int result = 1;
        for (int i = 0; i < this.bezierCurves.length; ++i) {
            int tempResult = this.bezierCurves[i].getLastFrame();
            if (tempResult <= result) continue;
            result = tempResult;
        }
        return result;
    }

    public Track calculateTrack(int targetIndex, BoneContext boneContext, Vector3f localTranslation, Quaternion localRotation, Vector3f localScale, int startFrame, int stopFrame, int fps, boolean spatialTrack) {
        if (this.calculatedTrack == null) {
            boolean swapAxes;
            int framesAmount = stopFrame - startFrame;
            float timeBetweenFrames = 1.0f / (float)fps;
            float[] times = new float[framesAmount + 1];
            Vector3f[] translations = new Vector3f[framesAmount + 1];
            float[] translation = new float[3];
            Quaternion[] rotations = new Quaternion[framesAmount + 1];
            float[] quaternionRotation = new float[]{localRotation.getX(), localRotation.getY(), localRotation.getZ(), localRotation.getW()};
            float[] eulerRotation = localRotation.toAngles(null);
            Vector3f[] scales = new Vector3f[framesAmount + 1];
            float[] scale = new float[]{localScale.x, localScale.y, localScale.z};
            float degreeToRadiansFactor = 1.0f;
            if (this.blenderVersion < 250) {
                degreeToRadiansFactor *= 0.17453292f;
            }
            int yIndex = 1;
            int zIndex = 2;
            boolean bl = swapAxes = spatialTrack && this.fixUpAxis;
            if (swapAxes) {
                yIndex = 2;
                zIndex = 1;
            }
            boolean eulerRotationUsed = false;
            boolean queternionRotationUsed = false;
            for (int frame = startFrame; frame <= stopFrame; ++frame) {
                boolean translationSet = false;
                translation[2] = 0.0f;
                translation[1] = 0.0f;
                translation[0] = 0.0f;
                int index = frame - startFrame;
                times[index] = (float)index * timeBetweenFrames;
                block16: for (int j = 0; j < this.bezierCurves.length; ++j) {
                    double value = this.bezierCurves[j].evaluate(frame, 1);
                    switch (this.bezierCurves[j].getType()) {
                        case 1: {
                            translation[0] = (float)value;
                            translationSet = true;
                            continue block16;
                        }
                        case 2: {
                            if (swapAxes && value != 0.0) {
                                value = -value;
                            }
                            translation[yIndex] = (float)value;
                            translationSet = true;
                            continue block16;
                        }
                        case 3: {
                            translation[zIndex] = (float)value;
                            translationSet = true;
                            continue block16;
                        }
                        case 7: {
                            eulerRotationUsed = true;
                            eulerRotation[0] = (float)value * degreeToRadiansFactor;
                            continue block16;
                        }
                        case 8: {
                            eulerRotationUsed = true;
                            if (swapAxes && value != 0.0) {
                                value = -value;
                            }
                            eulerRotation[yIndex] = (float)value * degreeToRadiansFactor;
                            continue block16;
                        }
                        case 9: {
                            eulerRotationUsed = true;
                            eulerRotation[zIndex] = (float)value * degreeToRadiansFactor;
                            continue block16;
                        }
                        case 13: {
                            scale[0] = (float)value;
                            continue block16;
                        }
                        case 14: {
                            scale[yIndex] = (float)value;
                            continue block16;
                        }
                        case 15: {
                            scale[zIndex] = (float)value;
                            continue block16;
                        }
                        case 25: {
                            queternionRotationUsed = true;
                            quaternionRotation[3] = (float)value;
                            continue block16;
                        }
                        case 26: {
                            queternionRotationUsed = true;
                            quaternionRotation[0] = (float)value;
                            continue block16;
                        }
                        case 27: {
                            queternionRotationUsed = true;
                            if (swapAxes && value != 0.0) {
                                value = -value;
                            }
                            quaternionRotation[yIndex] = (float)value;
                            continue block16;
                        }
                        case 28: {
                            quaternionRotation[zIndex] = (float)value;
                            continue block16;
                        }
                        default: {
                            LOGGER.log(Level.WARNING, "Unknown ipo curve type: {0}.", this.bezierCurves[j].getType());
                        }
                    }
                }
                translations[index] = translationSet ? localRotation.multLocal(new Vector3f(translation[0], translation[1], translation[2])) : new Vector3f();
                if (boneContext != null && boneContext.getBone().getParent() == null && boneContext.is(0x400000)) {
                    float temp = translations[index].z;
                    translations[index].z = -translations[index].y;
                    translations[index].y = temp;
                }
                rotations[index] = queternionRotationUsed ? new Quaternion(quaternionRotation[0], quaternionRotation[1], quaternionRotation[2], quaternionRotation[3]) : new Quaternion().fromAngles(eulerRotation);
                scales[index] = new Vector3f(scale[0], scale[1], scale[2]);
            }
            this.calculatedTrack = spatialTrack ? new SpatialTrack(times, translations, rotations, scales) : new BoneTrack(targetIndex, times, translations, rotations, scales);
            if (queternionRotationUsed && eulerRotationUsed) {
                LOGGER.warning("Animation uses both euler and quaternion tracks for rotations. Quaternion rotation is applied. Make sure that this is what you wanted!");
            }
        }
        return this.calculatedTrack;
    }

    static class ConstIpo
    extends Ipo {
        private float constValue;

        public ConstIpo(float constValue) {
            super(null, false, 0);
            this.constValue = constValue;
        }

        @Override
        public double calculateValue(int frame) {
            return this.constValue;
        }

        @Override
        public double calculateValue(int frame, int curveIndex) {
            return this.constValue;
        }

        public BoneTrack calculateTrack(int boneIndex, BoneContext boneContext, Vector3f localTranslation, Quaternion localRotation, Vector3f localScale, int startFrame, int stopFrame, int fps, boolean boneTrack) {
            throw new IllegalStateException("Constatnt ipo object cannot be used for calculating bone tracks!");
        }
    }
}

