/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints.definitions;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.math.Matrix4f;
import com.jme3.math.Transform;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.constraints.definitions.ConstraintDefinition;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.util.TempVars;

public class ConstraintDefinitionTransLike
extends ConstraintDefinition {
    private Long targetOMA;
    private String subtargetName;

    public ConstraintDefinitionTransLike(Structure constraintData, Long ownerOMA, BlenderContext blenderContext) {
        super(constraintData, ownerOMA, blenderContext);
        Pointer pTarget = (Pointer)constraintData.getFieldValue("tar");
        this.targetOMA = pTarget.getOldMemoryAddress();
        Object subtarget = constraintData.getFieldValue("subtarget");
        if (subtarget != null) {
            this.subtargetName = subtarget.toString();
        }
    }

    @Override
    public void bake(ConstraintHelper.Space ownerSpace, ConstraintHelper.Space targetSpace, Transform targetTransform, float influence) {
        if (influence == 0.0f || targetTransform == null) {
            return;
        }
        Object target = this.getTarget();
        Object owner = this.getOwner();
        if (!target.getClass().equals(owner.getClass())) {
            ConstraintHelper constraintHelper = (ConstraintHelper)this.blenderContext.getHelper(ConstraintHelper.class);
            TempVars tempVars = TempVars.get();
            Matrix4f m = constraintHelper.toMatrix(targetTransform, tempVars.tempMat4);
            tempVars.tempMat42.set(BoneContext.BONE_ARMATURE_TRANSFORMATION_MATRIX);
            if (target instanceof Bone) {
                tempVars.tempMat42.invertLocal();
            }
            m = m.multLocal(tempVars.tempMat42);
            tempVars.release();
            targetTransform = new Transform(m.toTranslationVector(), m.toRotationQuat(), m.toScaleVector());
        }
        this.applyOwnerTransform(targetTransform, ownerSpace);
    }

    private Object getTarget() {
        Object target = this.blenderContext.getLoadedFeature(this.targetOMA, BlenderContext.LoadedDataType.FEATURE);
        if (this.subtargetName != null && this.blenderContext.getMarkerValue("armature-node", target) != null) {
            Skeleton skeleton = this.blenderContext.getSkeleton(this.targetOMA);
            target = skeleton.getBone(this.subtargetName);
        }
        return target;
    }

    @Override
    public String getConstraintTypeName() {
        return "Copy transforms";
    }

    @Override
    public boolean isTargetRequired() {
        return true;
    }
}

