/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.file;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.DnaBlockData;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileBlockHeader {
    private static final Logger LOGGER = Logger.getLogger(FileBlockHeader.class.getName());
    private BlockCode code;
    private int size;
    private long oldMemoryAddress;
    private int sdnaIndex;
    private int count;
    private int blockPosition;

    public FileBlockHeader(BlenderInputStream inputStream, BlenderContext blenderContext) throws BlenderFileException {
        inputStream.alignPosition(4);
        this.code = BlockCode.valueOf(inputStream.readByte() << 24 | inputStream.readByte() << 16 | inputStream.readByte() << 8 | inputStream.readByte());
        this.size = inputStream.readInt();
        this.oldMemoryAddress = inputStream.readPointer();
        this.sdnaIndex = inputStream.readInt();
        this.count = inputStream.readInt();
        this.blockPosition = inputStream.getPosition();
        if (BlockCode.BLOCK_DNA1 == this.code) {
            blenderContext.setBlockData(new DnaBlockData(inputStream, blenderContext));
        } else {
            inputStream.setPosition(this.blockPosition + this.size);
            blenderContext.addFileBlockHeader(this.oldMemoryAddress, this);
        }
    }

    public Structure getStructure(BlenderContext blenderContext) throws BlenderFileException {
        blenderContext.getInputStream().setPosition(this.blockPosition);
        Structure structure = blenderContext.getDnaBlockData().getStructure(this.sdnaIndex);
        structure.fill(blenderContext.getInputStream());
        return structure;
    }

    public BlockCode getCode() {
        return this.code;
    }

    public int getSize() {
        return this.size;
    }

    public int getSdnaIndex() {
        return this.sdnaIndex;
    }

    public int getCount() {
        return this.count;
    }

    public int getBlockPosition() {
        return this.blockPosition;
    }

    public boolean isLastBlock() {
        return BlockCode.BLOCK_ENDB == this.code;
    }

    public boolean isDnaBlock() {
        return BlockCode.BLOCK_DNA1 == this.code;
    }

    public String toString() {
        return "FILE BLOCK HEADER [" + this.code.toString() + " : " + this.size + " : " + this.oldMemoryAddress + " : " + this.sdnaIndex + " : " + this.count + "]";
    }

    public static enum BlockCode {
        BLOCK_ME00(1296367616),
        BLOCK_CA00(1128333312),
        BLOCK_LA00(1279328256),
        BLOCK_OB00(1329725440),
        BLOCK_MA00(1296105472),
        BLOCK_SC00(1396899840),
        BLOCK_WO00(1464795136),
        BLOCK_TX00(1415053312),
        BLOCK_IP00(1229979648),
        BLOCK_AC00(1094909952),
        BLOCK_IM00(1229783040),
        BLOCK_TE00(0x54450000),
        BLOCK_WM00(1464664064),
        BLOCK_SR00(1397882880),
        BLOCK_SN00(1397620736),
        BLOCK_BR00(1112670208),
        BLOCK_LS00(1280507904),
        BLOCK_GR00(1196556288),
        BLOCK_AR00(1095892992),
        BLOCK_GLOB(1196183362),
        BLOCK_REND(1380273732),
        BLOCK_DATA(0x44415441),
        BLOCK_DNA1(1145979185),
        BLOCK_ENDB(1162757186),
        BLOCK_TEST(0x54455354),
        BLOCK_UNKN(0);

        private int code;

        private BlockCode(int code) {
            this.code = code;
        }

        public static BlockCode valueOf(int code) {
            for (BlockCode blockCode : BlockCode.values()) {
                if (blockCode.code != code) continue;
                return blockCode;
            }
            byte[] codeBytes = new byte[]{(byte)(code >> 24 & 0xFF), (byte)(code >> 16 & 0xFF), (byte)(code >> 8 & 0xFF), (byte)(code & 0xFF)};
            for (int i = 0; i < codeBytes.length; ++i) {
                if (codeBytes[i] != 0) continue;
                codeBytes[i] = 48;
            }
            LOGGER.log(Level.WARNING, "Unknown block header: {0}", new String(codeBytes));
            return BLOCK_UNKN;
        }
    }
}

