/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.materials;

import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.textures.CombinedTexture;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MaterialContext
implements Savable {
    private static final Logger LOGGER = Logger.getLogger(MaterialContext.class.getName());
    public static final int MTEX_COL = 1;
    public static final int MTEX_NOR = 2;
    public static final int MTEX_SPEC = 4;
    public static final int MTEX_EMIT = 64;
    public static final int MTEX_ALPHA = 128;
    public static final int MTEX_AMB = 2048;
    public static final int FLAG_TRANSPARENT = 65536;
    final String name;
    final List<CombinedTexture> loadedTextures;
    final ColorRGBA diffuseColor;
    final MaterialHelper.DiffuseShader diffuseShader;
    final MaterialHelper.SpecularShader specularShader;
    final ColorRGBA specularColor;
    final float ambientFactor;
    final float shininess;
    final boolean shadeless;
    final boolean vertexColor;
    final boolean transparent;
    final boolean vTangent;
    RenderState.FaceCullMode faceCullMode;

    MaterialContext(Structure structure, BlenderContext blenderContext) throws BlenderFileException {
        this.name = structure.getName();
        int mode = ((Number)structure.getFieldValue("mode")).intValue();
        this.shadeless = (mode & 4) != 0;
        this.vertexColor = (mode & 0x80) != 0;
        this.vTangent = (mode & 0x4000000) != 0;
        int diff_shader = ((Number)structure.getFieldValue("diff_shader")).intValue();
        this.diffuseShader = MaterialHelper.DiffuseShader.values()[diff_shader];
        this.ambientFactor = ((Number)structure.getFieldValue("amb")).floatValue();
        if (this.shadeless) {
            float r = ((Number)structure.getFieldValue("r")).floatValue();
            float g = ((Number)structure.getFieldValue("g")).floatValue();
            float b = ((Number)structure.getFieldValue("b")).floatValue();
            float alpha = ((Number)structure.getFieldValue("alpha")).floatValue();
            this.diffuseColor = new ColorRGBA(r, g, b, alpha);
            this.specularShader = null;
            this.specularColor = null;
            this.shininess = 0.0f;
        } else {
            this.diffuseColor = this.readDiffuseColor(structure, this.diffuseShader);
            int spec_shader = ((Number)structure.getFieldValue("spec_shader")).intValue();
            this.specularShader = MaterialHelper.SpecularShader.values()[spec_shader];
            this.specularColor = this.readSpecularColor(structure);
            float shininess = ((Number)structure.getFieldValue("har")).floatValue();
            this.shininess = shininess > 0.0f ? shininess : 20.0f;
        }
        TextureHelper textureHelper = (TextureHelper)blenderContext.getHelper(TextureHelper.class);
        this.loadedTextures = textureHelper.readTextureData(structure, new float[]{this.diffuseColor.r, this.diffuseColor.g, this.diffuseColor.b, this.diffuseColor.a}, false);
        long flag = ((Number)structure.getFieldValue("flag")).longValue();
        if ((flag & 0x10000L) != 0L) {
            boolean transparent = false;
            if (this.diffuseColor != null) {
                boolean bl = transparent = this.diffuseColor.a < 1.0f;
                if (this.loadedTextures.size() > 0) {
                    this.diffuseColor.set(1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
            if (this.specularColor != null) {
                transparent = transparent || this.specularColor.a < 1.0f;
            }
            this.transparent = transparent;
        } else {
            this.transparent = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public void applyMaterial(Geometry geometry, Long geometriesOMA, Map<String, List<Vector2f>> userDefinedUVCoordinates, BlenderContext blenderContext) {
        Material material = null;
        if (this.shadeless) {
            material = new Material(blenderContext.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
            if (!this.transparent) {
                this.diffuseColor.a = 1.0f;
            }
            material.setColor("Color", this.diffuseColor);
        } else {
            material = new Material(blenderContext.getAssetManager(), "Common/MatDefs/Light/Lighting.j3md");
            material.setBoolean("UseMaterialColors", Boolean.TRUE.booleanValue());
            if (!this.transparent) {
                this.diffuseColor.a = 1.0f;
            }
            material.setColor("Diffuse", this.diffuseColor);
            material.setColor("Specular", this.specularColor);
            material.setFloat("Shininess", this.shininess);
            material.setColor("Ambient", new ColorRGBA(this.ambientFactor, this.ambientFactor, this.ambientFactor, 1.0f));
        }
        Map unusedUserDefinedUVCoords = Collections.emptyMap();
        if (userDefinedUVCoordinates != null && !userDefinedUVCoordinates.isEmpty()) {
            unusedUserDefinedUVCoords = new HashMap<String, List<Vector2f>>(userDefinedUVCoordinates);
        }
        int textureIndex = 0;
        if (this.loadedTextures != null && this.loadedTextures.size() > 0) {
            if (this.loadedTextures.size() > TextureHelper.TEXCOORD_TYPES.length) {
                LOGGER.log(Level.WARNING, "The blender file has defined more than {0} different textures. JME supports only {0} UV mappings.", TextureHelper.TEXCOORD_TYPES.length);
            }
            for (CombinedTexture combinedTexture : this.loadedTextures) {
                if (textureIndex < TextureHelper.TEXCOORD_TYPES.length) {
                    String usedUserUVSet = combinedTexture.flatten(geometry, geometriesOMA, userDefinedUVCoordinates, blenderContext);
                    this.setTexture(material, combinedTexture.getMappingType(), combinedTexture.getResultTexture());
                    if (usedUserUVSet != null && !unusedUserDefinedUVCoords.containsKey(usedUserUVSet)) continue;
                    List<Vector2f> uvs = combinedTexture.getResultUVS();
                    if (uvs != null && uvs.size() > 0) {
                        VertexBuffer uvCoordsBuffer = new VertexBuffer(TextureHelper.TEXCOORD_TYPES[textureIndex++]);
                        uvCoordsBuffer.setupData(VertexBuffer.Usage.Static, 2, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((Vector2f[])uvs.toArray(new Vector2f[uvs.size()])));
                        geometry.getMesh().setBuffer(uvCoordsBuffer);
                    }
                    if (usedUserUVSet == null) continue;
                    unusedUserDefinedUVCoords.remove(usedUserUVSet);
                    continue;
                }
                LOGGER.log(Level.WARNING, "The texture could not be applied because JME only supports up to {0} different UV's.", TextureHelper.TEXCOORD_TYPES.length);
            }
        }
        if (unusedUserDefinedUVCoords != null && unusedUserDefinedUVCoords.size() > 0) {
            LOGGER.fine("Storing unused, user defined UV coordinates sets.");
            if (unusedUserDefinedUVCoords.size() > TextureHelper.TEXCOORD_TYPES.length) {
                LOGGER.log(Level.WARNING, "The blender file has defined more than {0} different UV coordinates for the mesh. JME supports only {0} UV coordinates buffers.", TextureHelper.TEXCOORD_TYPES.length);
            }
            for (Map.Entry entry : unusedUserDefinedUVCoords.entrySet()) {
                if (textureIndex < TextureHelper.TEXCOORD_TYPES.length) {
                    List uvs = (List)entry.getValue();
                    VertexBuffer uvCoordsBuffer = new VertexBuffer(TextureHelper.TEXCOORD_TYPES[textureIndex++]);
                    uvCoordsBuffer.setupData(VertexBuffer.Usage.Static, 2, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((Vector2f[])uvs.toArray(new Vector2f[uvs.size()])));
                    geometry.getMesh().setBuffer(uvCoordsBuffer);
                    continue;
                }
                LOGGER.log(Level.WARNING, "The user's UV set named: '{0}' could not be stored because JME only supports up to {1} different UV's.", new Object[]{entry.getKey(), TextureHelper.TEXCOORD_TYPES.length});
            }
        }
        material.setName(this.name);
        if (this.vertexColor) {
            material.setBoolean(this.shadeless ? "VertexColor" : "UseVertexColor", true);
        }
        material.getAdditionalRenderState().setFaceCullMode(this.faceCullMode != null ? this.faceCullMode : blenderContext.getBlenderKey().getFaceCullMode());
        if (this.transparent) {
            material.setTransparent(true);
            material.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            geometry.setQueueBucket(RenderQueue.Bucket.Transparent);
        }
        geometry.setMaterial(material);
    }

    private void setTexture(Material material, int mapTo, Texture texture) {
        switch (mapTo) {
            case 1: {
                material.setTexture(this.shadeless ? "ColorMap" : "DiffuseMap", texture);
                break;
            }
            case 2: {
                material.setTexture("NormalMap", texture);
                break;
            }
            case 4: {
                material.setTexture("SpecularMap", texture);
                break;
            }
            case 64: {
                material.setTexture("GlowMap", texture);
                break;
            }
            case 128: {
                if (!this.shadeless) {
                    material.setTexture("AlphaMap", texture);
                    break;
                }
                LOGGER.warning("JME does not support alpha map on unshaded material. Material name is " + this.name);
                break;
            }
            case 2048: {
                material.setTexture("LightMap", texture);
                break;
            }
            default: {
                LOGGER.severe("Unknown mapping type: " + mapTo);
            }
        }
    }

    public boolean hasGeneratedTextures() {
        if (this.loadedTextures != null) {
            for (CombinedTexture generatedTextures : this.loadedTextures) {
                if (!generatedTextures.hasGeneratedTextures()) continue;
                return true;
            }
        }
        return false;
    }

    public void setFaceCullMode(RenderState.FaceCullMode faceCullMode) {
        this.faceCullMode = faceCullMode;
    }

    private ColorRGBA readDiffuseColor(Structure materialStructure, MaterialHelper.DiffuseShader diffuseShader) {
        int commonMapto = ((Number)materialStructure.getFieldValue("mapto")).intValue();
        float r = ((Number)materialStructure.getFieldValue("r")).floatValue();
        float g = ((Number)materialStructure.getFieldValue("g")).floatValue();
        float b = ((Number)materialStructure.getFieldValue("b")).floatValue();
        float alpha = ((Number)materialStructure.getFieldValue("alpha")).floatValue();
        if ((commonMapto & 1) == 1) {
            return new ColorRGBA(r, g, b, alpha);
        }
        switch (diffuseShader) {
            case FRESNEL: 
            case ORENNAYAR: 
            case TOON: {
                break;
            }
            case MINNAERT: 
            case LAMBERT: {
                float ref = ((Number)materialStructure.getFieldValue("ref")).floatValue();
                r *= ref;
                g *= ref;
                b *= ref;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown diffuse shader type: " + diffuseShader.toString());
            }
        }
        return new ColorRGBA(r, g, b, alpha);
    }

    private ColorRGBA readSpecularColor(Structure materialStructure) {
        float specularIntensity = ((Number)materialStructure.getFieldValue("spec")).floatValue();
        float r = ((Number)materialStructure.getFieldValue("specr")).floatValue() * specularIntensity;
        float g = ((Number)materialStructure.getFieldValue("specg")).floatValue() * specularIntensity;
        float b = ((Number)materialStructure.getFieldValue("specb")).floatValue() * specularIntensity;
        float alpha = ((Number)materialStructure.getFieldValue("alpha")).floatValue();
        return new ColorRGBA(r, g, b, alpha);
    }

    public void write(JmeExporter e) throws IOException {
        throw new IOException("Material context is not for saving! It implements savable only to be passed to another blend file as a Savable in user data!");
    }

    public void read(JmeImporter e) throws IOException {
        throw new IOException("Material context is not for loading! It implements savable only to be passed to another blend file as a Savable in user data!");
    }
}

