/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.math;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Transform;
import com.jme3.scene.plugins.blender.math.DQuaternion;
import com.jme3.scene.plugins.blender.math.Matrix;
import com.jme3.scene.plugins.blender.math.Vector3d;
import java.io.IOException;
import java.io.Serializable;

public final class DTransform
implements Savable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 7812915425940606722L;
    private DQuaternion rotation;
    private Vector3d translation;
    private Vector3d scale;

    public DTransform() {
        this.translation = new Vector3d();
        this.rotation = new DQuaternion();
        this.scale = new Vector3d();
    }

    public DTransform(Transform transform) {
        this.translation = new Vector3d(transform.getTranslation());
        this.rotation = new DQuaternion(transform.getRotation());
        this.scale = new Vector3d(transform.getScale());
    }

    public Transform toTransform() {
        return new Transform(this.translation.toVector3f(), this.rotation.toQuaternion(), this.scale.toVector3f());
    }

    public Matrix toMatrix() {
        Matrix m = Matrix.identity(4);
        m.setTranslation(this.translation);
        m.setRotationQuaternion(this.rotation);
        m.setScale(this.scale);
        return m;
    }

    public DTransform setTranslation(Vector3d trans) {
        this.translation.set(trans);
        return this;
    }

    public DTransform setRotation(DQuaternion rot) {
        this.rotation.set(rot);
        return this;
    }

    public DTransform setScale(Vector3d scale) {
        this.scale.set(scale);
        return this;
    }

    public DTransform setScale(float scale) {
        this.scale.set(scale, scale, scale);
        return this;
    }

    public Vector3d getTranslation() {
        return this.translation;
    }

    public DQuaternion getRotation() {
        return this.rotation;
    }

    public Vector3d getScale() {
        return this.scale;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ " + this.translation.x + ", " + this.translation.y + ", " + this.translation.z + "]\n[ " + this.rotation.x + ", " + this.rotation.y + ", " + this.rotation.z + ", " + this.rotation.w + "]\n[ " + this.scale.x + " , " + this.scale.y + ", " + this.scale.z + "]";
    }

    public void write(JmeExporter e) throws IOException {
        OutputCapsule capsule = e.getCapsule((Savable)this);
        capsule.write((Savable)this.rotation, "rot", (Savable)new DQuaternion());
        capsule.write((Savable)this.translation, "translation", (Savable)Vector3d.ZERO);
        capsule.write((Savable)this.scale, "scale", (Savable)Vector3d.UNIT_XYZ);
    }

    public void read(JmeImporter e) throws IOException {
        InputCapsule capsule = e.getCapsule((Savable)this);
        this.rotation = (DQuaternion)capsule.readSavable("rot", (Savable)new DQuaternion());
        this.translation = (Vector3d)capsule.readSavable("translation", (Savable)Vector3d.ZERO);
        this.scale = (Vector3d)capsule.readSavable("scale", (Savable)Vector3d.UNIT_XYZ);
    }

    public DTransform clone() {
        try {
            DTransform tq = (DTransform)super.clone();
            tq.rotation = this.rotation.clone();
            tq.scale = this.scale.clone();
            tq.translation = this.translation.clone();
            return tq;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

