/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.meshes;

import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.math.Vector3d;
import com.jme3.scene.plugins.blender.meshes.IndexesLoop;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Edge {
    private static final Logger LOGGER = Logger.getLogger(Edge.class.getName());
    private static final int FLAG_EDGE_NOT_IN_FACE = 128;
    private int index1;
    private int index2;
    private Vector3f v1;
    private Vector3f v2;
    private float crease;
    private boolean inFace;
    private TemporalMesh temporalMesh;

    public Edge(Vector3f v1, Vector3f v2) {
        this.v1 = v1 == null ? new Vector3f() : v1;
        this.v2 = v2 == null ? new Vector3f() : v2;
        this.index1 = 0;
        this.index2 = 1;
    }

    public Edge(int index1, int index2, float crease, boolean inFace, TemporalMesh temporalMesh) {
        this.index1 = index1;
        this.index2 = index2;
        this.crease = crease;
        this.inFace = inFace;
        this.temporalMesh = temporalMesh;
    }

    public Edge clone() {
        return new Edge(this.index1, this.index2, this.crease, this.inFace, this.temporalMesh);
    }

    public int getFirstIndex() {
        return this.index1;
    }

    public int getSecondIndex() {
        return this.index2;
    }

    public Vector3f getFirstVertex() {
        return this.temporalMesh == null ? this.v1 : this.temporalMesh.getVertices().get(this.index1);
    }

    public Vector3f getSecondVertex() {
        return this.temporalMesh == null ? this.v2 : this.temporalMesh.getVertices().get(this.index2);
    }

    public int getOtherIndex(int index) {
        if (index == this.index1) {
            return this.index2;
        }
        if (index == this.index2) {
            return this.index1;
        }
        throw new IllegalArgumentException("Cannot give the other index for [" + index + "] because this index does not exist in edge: " + this);
    }

    public float getCrease() {
        return this.crease;
    }

    public boolean isInFace() {
        return this.inFace;
    }

    public float getLength() {
        return this.getFirstVertex().distance(this.getSecondVertex());
    }

    public TemporalMesh getTemporalMesh() {
        return this.temporalMesh;
    }

    public Vector3f computeCentroid() {
        return this.getFirstVertex().add(this.getSecondVertex()).divideLocal(2.0f);
    }

    public void shiftIndexes(int shift, IndexesLoop.IndexPredicate predicate) {
        if (predicate == null) {
            this.index1 += shift;
            this.index2 += shift;
        } else {
            this.index1 += predicate.execute(this.index1) ? shift : 0;
            this.index2 += predicate.execute(this.index2) ? shift : 0;
        }
    }

    public void flipIndexes() {
        int temp = this.index1;
        this.index1 = this.index2;
        this.index2 = temp;
    }

    public boolean cross(Edge edge) {
        return this.getCrossPoint(edge) != null;
    }

    public Vector3f getCrossPoint(Edge edge) {
        return this.getCrossPoint(edge, false, false);
    }

    public Vector3f getCrossPoint(Edge edge, boolean extendThisEdge, boolean extendSecondEdge) {
        Vector3d v;
        Vector3d P1 = new Vector3d(this.getFirstVertex());
        Vector3d P2 = new Vector3d(edge.getFirstVertex());
        Vector3d u = new Vector3d(this.getSecondVertex()).subtract(P1).normalizeLocal();
        if (Math.abs(u.dot(v = new Vector3d(edge.getSecondVertex()).subtract(P2).normalizeLocal())) >= 0.9999999999999998) {
            return null;
        }
        double t1 = 0.0;
        double t2 = 0.0;
        if (u.x == 0.0 && v.x == 0.0) {
            t2 = (u.z * (P2.y - P1.y) - u.y * (P2.z - P1.z)) / (u.y * v.z - u.z * v.y);
            t1 = (P2.z - P1.z + v.z * t2) / u.z;
        } else if (u.y == 0.0 && v.y == 0.0) {
            t2 = (u.x * (P2.z - P1.z) - u.z * (P2.x - P1.x)) / (u.z * v.x - u.x * v.z);
            t1 = (P2.x - P1.x + v.x * t2) / u.x;
        } else if (u.z == 0.0 && v.z == 0.0) {
            t2 = (u.x * (P2.y - P1.y) - u.y * (P2.x - P1.x)) / (u.y * v.x - u.x * v.y);
            t1 = (P2.x - P1.x + v.x * t2) / u.x;
        } else {
            t2 = (P1.y * u.x - P1.x * u.y + P2.x * u.y - P2.y * u.x) / (v.y * u.x - u.y * v.x);
            t1 = (P2.x - P1.x + v.x * t2) / u.x;
            if (Math.abs(P1.z - P2.z + u.z * t1 - v.z * t2) > 1.1920928955078125E-7) {
                return null;
            }
        }
        Vector3d p1 = P1.add(u.mult(t1));
        Vector3d p2 = P2.add(v.mult(t2));
        if (p1.distance(p2) <= 1.1920928955078125E-7) {
            if (extendThisEdge && extendSecondEdge) {
                return p1.toVector3f();
            }
            Vector3d p = p1.subtract(P1);
            double cos = p.dot(u) / p.length();
            if (extendThisEdge || p.length() <= 1.1920928955078125E-7 || cos >= 0.9999998807907104 && p.length() - (double)this.getLength() <= 1.1920928955078125E-7) {
                p = p2.subtract(P2);
                cos = p.dot(v) / p.length();
                if (extendSecondEdge || p.length() <= 1.1920928955078125E-7 || cos >= 0.9999998807907104 && p.length() - (double)edge.getLength() <= 1.1920928955078125E-7) {
                    return p1.toVector3f();
                }
            }
        }
        return null;
    }

    public String toString() {
        String result = "Edge [" + this.index1 + ", " + this.index2 + "] {" + this.crease + "}";
        result = result + " (" + this.getFirstVertex() + " -> " + this.getSecondVertex() + ")";
        if (this.inFace) {
            result = result + "[F]";
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        int lowerIndex = Math.min(this.index1, this.index2);
        int higherIndex = Math.max(this.index1, this.index2);
        result = 31 * result + lowerIndex;
        result = 31 * result + higherIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Edge)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Edge other = (Edge)obj;
        return Math.min(this.index1, this.index2) == Math.min(other.index1, other.index2) && Math.max(this.index1, this.index2) == Math.max(other.index1, other.index2);
    }

    public static List<Edge> loadAll(Structure meshStructure, TemporalMesh temporalMesh) throws BlenderFileException {
        LOGGER.log(Level.FINE, "Loading all edges that do not belong to any face from mesh: {0}", meshStructure.getName());
        ArrayList<Edge> result = new ArrayList<Edge>();
        Pointer pMEdge = (Pointer)meshStructure.getFieldValue("medge");
        if (pMEdge.isNotNull()) {
            List<Structure> edges = pMEdge.fetchData();
            for (Structure edge : edges) {
                int flag = ((Number)edge.getFieldValue("flag")).intValue();
                int v1 = ((Number)edge.getFieldValue("v1")).intValue();
                int v2 = ((Number)edge.getFieldValue("v2")).intValue();
                float crease = Math.abs(((Number)edge.getFieldValue("crease")).floatValue());
                boolean edgeInFace = (flag & 0x80) == 0;
                result.add(new Edge(v1, v2, crease, edgeInFace, temporalMesh));
            }
        }
        LOGGER.log(Level.FINE, "Loaded {0} edges.", result.size());
        return result;
    }
}

