/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.meshes;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialContext;
import com.jme3.scene.plugins.blender.meshes.Edge;
import com.jme3.scene.plugins.blender.meshes.Face;
import com.jme3.scene.plugins.blender.meshes.MeshBuffers;
import com.jme3.scene.plugins.blender.meshes.MeshHelper;
import com.jme3.scene.plugins.blender.meshes.Point;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.objects.Properties;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TemporalMesh
extends Geometry {
    private static final Logger LOGGER = Logger.getLogger(TemporalMesh.class.getName());
    private static final double MINIMUM_BONE_WEIGHT = 2.220446049250313E-16;
    protected final BlenderContext blenderContext;
    protected final Structure meshStructure;
    protected List<Vector3f> vertices = new ArrayList<Vector3f>();
    protected List<Vector3f> normals = new ArrayList<Vector3f>();
    protected List<Map<String, Float>> vertexGroups = new ArrayList<Map<String, Float>>();
    protected List<byte[]> verticesColors = new ArrayList<byte[]>();
    protected MaterialContext[] materials;
    protected Properties properties;
    protected Map<String, Integer> boneIndexes = new HashMap<String, Integer>();
    protected List<Modifier> postMeshCreationModifiers = new ArrayList<Modifier>();
    protected List<Face> faces = new ArrayList<Face>();
    protected List<Edge> edges = new ArrayList<Edge>();
    protected List<Point> points = new ArrayList<Point>();
    protected Map<Integer, Set<Face>> indexToFaceMapping = new HashMap<Integer, Set<Face>>();
    protected Map<Integer, Set<Edge>> indexToEdgeMapping = new HashMap<Integer, Set<Edge>>();
    protected BoundingBox boundingBox;

    public TemporalMesh(Structure meshStructure, BlenderContext blenderContext) throws BlenderFileException {
        this(meshStructure, blenderContext, true);
    }

    protected TemporalMesh(Structure meshStructure, BlenderContext blenderContext, boolean loadData) throws BlenderFileException {
        this.blenderContext = blenderContext;
        this.meshStructure = meshStructure;
        if (loadData) {
            this.name = meshStructure.getName();
            MeshHelper meshHelper = (MeshHelper)blenderContext.getHelper(MeshHelper.class);
            meshHelper.loadVerticesAndNormals(meshStructure, this.vertices, this.normals);
            this.verticesColors = meshHelper.loadVerticesColors(meshStructure, blenderContext);
            LinkedHashMap<String, List<Vector2f>> userUVGroups = meshHelper.loadUVCoordinates(meshStructure);
            this.vertexGroups = meshHelper.loadVerticesGroups(meshStructure);
            this.faces = Face.loadAll(meshStructure, userUVGroups, this.verticesColors, this, blenderContext);
            this.edges = Edge.loadAll(meshStructure, this);
            this.points = Point.loadAll(meshStructure);
            this.rebuildIndexesMappings();
        }
    }

    public BlenderContext getBlenderContext() {
        return this.blenderContext;
    }

    public List<Vector3f> getVertices() {
        return this.vertices;
    }

    public List<Vector3f> getNormals() {
        return this.normals;
    }

    public List<Face> getFaces() {
        return this.faces;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public List<byte[]> getVerticesColors() {
        return this.verticesColors;
    }

    public List<Map<String, Float>> getVertexGroups() {
        return this.vertexGroups;
    }

    public Collection<Face> getAdjacentFaces(Integer index) {
        return this.indexToFaceMapping.get(index);
    }

    public Collection<Face> getAdjacentFaces(Edge edge) {
        ArrayList<Face> result = new ArrayList<Face>((Collection)this.indexToFaceMapping.get(edge.getFirstIndex()));
        Set<Face> secondIndexAdjacentFaces = this.indexToFaceMapping.get(edge.getSecondIndex());
        if (secondIndexAdjacentFaces != null) {
            result.retainAll((Collection)this.indexToFaceMapping.get(edge.getSecondIndex()));
        }
        return result;
    }

    public Collection<Edge> getAdjacentEdges(Integer index) {
        return this.indexToEdgeMapping.get(index);
    }

    public boolean isBoundary(Edge edge) {
        return this.getAdjacentFaces(edge).size() <= 1;
    }

    public boolean isBoundary(Integer index) {
        Collection<Edge> adjacentEdges = this.getAdjacentEdges(index);
        for (Edge edge : adjacentEdges) {
            if (!this.isBoundary(edge)) continue;
            return true;
        }
        return false;
    }

    public TemporalMesh clone() {
        try {
            TemporalMesh result = new TemporalMesh(this.meshStructure, this.blenderContext, false);
            result.name = this.name;
            for (Vector3f vector3f : this.vertices) {
                result.vertices.add(vector3f.clone());
            }
            for (Vector3f vector3f : this.normals) {
                result.normals.add(vector3f.clone());
            }
            for (Map map : this.vertexGroups) {
                result.vertexGroups.add(new HashMap(map));
            }
            for (byte[] byArray : this.verticesColors) {
                result.verticesColors.add((byte[])byArray.clone());
            }
            result.materials = this.materials;
            result.properties = this.properties;
            result.boneIndexes.putAll(this.boneIndexes);
            result.postMeshCreationModifiers.addAll(this.postMeshCreationModifiers);
            for (Face face : this.faces) {
                result.faces.add(face.clone());
            }
            for (Edge edge : this.edges) {
                result.edges.add(edge.clone());
            }
            for (Point point : this.points) {
                result.points.add(point.clone());
            }
            result.rebuildIndexesMappings();
            return result;
        }
        catch (BlenderFileException e) {
            LOGGER.log(Level.SEVERE, "Error while cloning the temporal mesh: {0}. Returning null.", e.getLocalizedMessage());
            return null;
        }
    }

    public void rebuildIndexesMappings() {
        this.indexToEdgeMapping.clear();
        this.indexToFaceMapping.clear();
        for (Face face : this.faces) {
            for (Integer index : face.getIndexes()) {
                Set<Face> faces = this.indexToFaceMapping.get(index);
                if (faces == null) {
                    faces = new HashSet<Face>();
                    this.indexToFaceMapping.put(index, faces);
                }
                faces.add(face);
            }
        }
        for (Edge edge : this.edges) {
            Set<Edge> edges = this.indexToEdgeMapping.get(edge.getFirstIndex());
            if (edges == null) {
                edges = new HashSet<Edge>();
                this.indexToEdgeMapping.put(edge.getFirstIndex(), edges);
            }
            edges.add(edge);
            edges = this.indexToEdgeMapping.get(edge.getSecondIndex());
            if (edges == null) {
                edges = new HashSet<Edge>();
                this.indexToEdgeMapping.put(edge.getSecondIndex(), edges);
            }
            edges.add(edge);
        }
    }

    public void updateModelBound() {
        if (this.boundingBox == null) {
            this.boundingBox = new BoundingBox();
        }
        Vector3f min = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Vector3f max = new Vector3f(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
        for (Vector3f v : this.vertices) {
            min.set(Math.min(min.x, v.x), Math.min(min.y, v.y), Math.min(min.z, v.z));
            max.set(Math.max(max.x, v.x), Math.max(max.y, v.y), Math.max(max.z, v.z));
        }
        this.boundingBox.setMinMax(min, max);
    }

    public BoundingVolume getModelBound() {
        this.updateModelBound();
        return this.boundingBox;
    }

    public BoundingVolume getWorldBound() {
        this.updateModelBound();
        Node parent = this.getParent();
        if (parent != null) {
            BoundingVolume bv = this.boundingBox.clone();
            bv.setCenter(parent.getWorldTranslation());
            return bv;
        }
        return this.boundingBox;
    }

    public void triangulate() {
        HashSet<Face.TriangulationWarning> warnings = new HashSet<Face.TriangulationWarning>(Face.TriangulationWarning.values().length - 1);
        LOGGER.fine("Triangulating temporal mesh.");
        for (Face face : this.faces) {
            Face.TriangulationWarning warning = face.triangulate();
            if (warning == Face.TriangulationWarning.NONE) continue;
            warnings.add(warning);
        }
        if (warnings.size() > 0 && LOGGER.isLoggable(Level.WARNING)) {
            StringBuilder sb = new StringBuilder(512);
            sb.append("There were problems with triangulating the faces of a mesh: ").append(this.name);
            for (Face.TriangulationWarning w : warnings) {
                sb.append("\n\t").append((Object)w);
            }
            LOGGER.warning(sb.toString());
        }
    }

    public void append(TemporalMesh mesh) {
        if (mesh != null) {
            int shift = this.vertices.size();
            if (shift > 0) {
                for (Face face : mesh.faces) {
                    face.getIndexes().shiftIndexes(shift, null);
                    face.setTemporalMesh(this);
                }
                for (Edge edge : mesh.edges) {
                    edge.shiftIndexes(shift, null);
                }
                for (Point point : mesh.points) {
                    point.shiftIndexes(shift, null);
                }
            }
            this.faces.addAll(mesh.faces);
            this.edges.addAll(mesh.edges);
            this.points.addAll(mesh.points);
            this.vertices.addAll(mesh.vertices);
            this.normals.addAll(mesh.normals);
            this.vertexGroups.addAll(mesh.vertexGroups);
            this.verticesColors.addAll(mesh.verticesColors);
            this.boneIndexes.putAll(mesh.boneIndexes);
            this.rebuildIndexesMappings();
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setMaterials(MaterialContext[] materials) {
        this.materials = materials;
    }

    public void addBoneIndex(String boneName, Integer boneIndex) {
        this.boneIndexes.put(boneName, boneIndex);
    }

    public void applyAfterMeshCreate(Modifier modifier) {
        this.postMeshCreationModifiers.add(modifier);
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    public void clear() {
        this.vertices.clear();
        this.normals.clear();
        this.vertexGroups.clear();
        this.verticesColors.clear();
        this.faces.clear();
        this.edges.clear();
        this.points.clear();
        this.indexToEdgeMapping.clear();
        this.indexToFaceMapping.clear();
    }

    public void toGeometries() {
        LOGGER.log(Level.FINE, "Converting temporal mesh {0} to jme geometries.", this.name);
        ArrayList<Geometry> result = new ArrayList<Geometry>();
        MeshHelper meshHelper = (MeshHelper)this.blenderContext.getHelper(MeshHelper.class);
        Node parent = this.getParent();
        parent.detachChild((Spatial)this);
        this.prepareFacesGeometry(result, meshHelper);
        this.prepareLinesGeometry(result, meshHelper);
        this.preparePointsGeometry(result, meshHelper);
        this.blenderContext.addLoadedFeatures(this.meshStructure.getOldMemoryAddress(), BlenderContext.LoadedDataType.FEATURE, result);
        for (Geometry geometry : result) {
            parent.attachChild((Spatial)geometry);
        }
        for (Modifier modifier : this.postMeshCreationModifiers) {
            modifier.postMeshCreationApply(parent, this.blenderContext);
        }
    }

    protected void prepareFacesGeometry(List<Geometry> result, MeshHelper meshHelper) {
        LOGGER.fine("Preparing faces geometries.");
        this.triangulate();
        Vector3f[] tempVerts = new Vector3f[3];
        Vector3f[] tempNormals = new Vector3f[3];
        byte[][] tempVertColors = new byte[3][];
        ArrayList<Map<Float, Integer>> boneBuffers = new ArrayList<Map<Float, Integer>>(3);
        LOGGER.log(Level.FINE, "Appending {0} faces to mesh buffers.", this.faces.size());
        HashMap<Integer, MeshBuffers> faceMeshes = new HashMap<Integer, MeshBuffers>();
        for (Face face : this.faces) {
            MeshBuffers meshBuffers = (MeshBuffers)faceMeshes.get(face.getMaterialNumber());
            if (meshBuffers == null) {
                meshBuffers = new MeshBuffers(face.getMaterialNumber());
                faceMeshes.put(face.getMaterialNumber(), meshBuffers);
            }
            List<List<Integer>> triangulatedIndexes = face.getCurrentIndexes();
            List<byte[]> vertexColors = face.getVertexColors();
            for (List<Integer> indexes : triangulatedIndexes) {
                assert (indexes.size() == 3) : "The mesh has not been properly triangulated!";
                Vector3f normal = null;
                if (!face.isSmooth()) {
                    normal = FastMath.computeNormal((Vector3f)this.vertices.get(indexes.get(0)), (Vector3f)this.vertices.get(indexes.get(1)), (Vector3f)this.vertices.get(indexes.get(2)));
                }
                boneBuffers.clear();
                for (int i = 0; i < 3; ++i) {
                    int vertIndex = indexes.get(i);
                    tempVerts[i] = this.vertices.get(vertIndex);
                    tempNormals[i] = normal != null ? normal : this.normals.get(vertIndex);
                    byte[] byArray = tempVertColors[i] = vertexColors != null ? vertexColors.get(face.getIndexes().indexOf(vertIndex)) : null;
                    if (this.boneIndexes.size() <= 0 || this.vertexGroups.size() <= 0) continue;
                    HashMap<Float, Integer> boneBuffersForVertex = new HashMap<Float, Integer>();
                    Map<String, Float> vertexGroupsForVertex = this.vertexGroups.get(vertIndex);
                    for (Map.Entry<String, Integer> entry : this.boneIndexes.entrySet()) {
                        float weight;
                        if (!vertexGroupsForVertex.containsKey(entry.getKey()) || !((double)(weight = vertexGroupsForVertex.get(entry.getKey()).floatValue()) > 2.220446049250313E-16)) continue;
                        boneBuffersForVertex.put(Float.valueOf(weight), entry.getValue());
                    }
                    if (boneBuffersForVertex.size() == 0) {
                        boneBuffersForVertex.put(Float.valueOf(1.0f), 0);
                    }
                    boneBuffers.add(boneBuffersForVertex);
                }
                Map<String, List<Vector2f>> uvs = meshHelper.selectUVSubset(face, indexes.toArray(new Integer[indexes.size()]));
                meshBuffers.append(face.isSmooth(), tempVerts, tempNormals, uvs, tempVertColors, boneBuffers);
            }
        }
        LOGGER.fine("Converting mesh buffers to geometries.");
        HashMap<Geometry, MeshBuffers> geometryToBuffersMap = new HashMap<Geometry, MeshBuffers>();
        for (Map.Entry entry : faceMeshes.entrySet()) {
            MeshBuffers.BoneBuffersData boneBuffersData;
            MeshBuffers meshBuffers = (MeshBuffers)entry.getValue();
            Mesh mesh = new Mesh();
            if (meshBuffers.isShortIndexBuffer()) {
                mesh.setBuffer(VertexBuffer.Type.Index, 1, (ShortBuffer)meshBuffers.getIndexBuffer());
            } else {
                mesh.setBuffer(VertexBuffer.Type.Index, 1, (IntBuffer)meshBuffers.getIndexBuffer());
            }
            mesh.setBuffer(meshBuffers.getPositionsBuffer());
            mesh.setBuffer(meshBuffers.getNormalsBuffer());
            if (meshBuffers.areVertexColorsUsed()) {
                mesh.setBuffer(VertexBuffer.Type.Color, 4, meshBuffers.getVertexColorsBuffer());
                mesh.getBuffer(VertexBuffer.Type.Color).setNormalized(true);
            }
            if ((boneBuffersData = meshBuffers.getBoneBuffers()) != null) {
                mesh.setMaxNumWeights(boneBuffersData.maximumWeightsPerVertex);
                mesh.setBuffer(boneBuffersData.verticesWeights);
                mesh.setBuffer(boneBuffersData.verticesWeightsIndices);
                LOGGER.fine("Generating bind pose and normal buffers.");
                mesh.generateBindPose(true);
                mesh.getBuffer(VertexBuffer.Type.Position).setUsage(VertexBuffer.Usage.Stream);
                mesh.getBuffer(VertexBuffer.Type.Normal).setUsage(VertexBuffer.Usage.Stream);
                VertexBuffer verticesWeightsHW = new VertexBuffer(VertexBuffer.Type.HWBoneWeight);
                VertexBuffer verticesWeightsIndicesHW = new VertexBuffer(VertexBuffer.Type.HWBoneIndex);
                mesh.setBuffer(verticesWeightsHW);
                mesh.setBuffer(verticesWeightsIndicesHW);
            }
            Geometry geometry = new Geometry(this.name + (result.size() + 1), mesh);
            if (this.properties != null && this.properties.getValue() != null) {
                meshHelper.applyProperties((Spatial)geometry, this.properties);
            }
            result.add(geometry);
            geometryToBuffersMap.put(geometry, meshBuffers);
        }
        LOGGER.fine("Applying materials to geometries.");
        for (Map.Entry entry : geometryToBuffersMap.entrySet()) {
            int materialIndex = ((MeshBuffers)entry.getValue()).getMaterialIndex();
            Geometry geometry = (Geometry)entry.getKey();
            if (materialIndex >= 0 && this.materials != null && this.materials.length > materialIndex && this.materials[materialIndex] != null) {
                this.materials[materialIndex].applyMaterial(geometry, this.meshStructure.getOldMemoryAddress(), ((MeshBuffers)entry.getValue()).getUvCoords(), this.blenderContext);
                continue;
            }
            Material defaultMaterial = this.blenderContext.getDefaultMaterial().clone();
            defaultMaterial.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
            geometry.setMaterial(defaultMaterial);
        }
    }

    protected void prepareLinesGeometry(List<Geometry> result, MeshHelper meshHelper) {
        if (this.edges.size() > 0) {
            LOGGER.fine("Preparing lines geometries.");
            ArrayList<ArrayList<Integer>> separateEdges = new ArrayList<ArrayList<Integer>>();
            ArrayList<Edge> edges = new ArrayList<Edge>(this.edges.size());
            for (Edge edge : this.edges) {
                if (edge.isInFace()) continue;
                edges.add(edge);
            }
            while (edges.size() > 0) {
                int n;
                boolean edgeAppended = false;
                boolean bl = false;
                for (List list : separateEdges) {
                    for (n = 0; n < edges.size() && !edgeAppended; ++n) {
                        Edge edge = (Edge)edges.get(n);
                        if (((Integer)list.get(0)).equals(edge.getFirstIndex())) {
                            list.add(0, edge.getSecondIndex());
                            --n;
                            edgeAppended = true;
                            continue;
                        }
                        if (((Integer)list.get(0)).equals(edge.getSecondIndex())) {
                            list.add(0, edge.getFirstIndex());
                            --n;
                            edgeAppended = true;
                            continue;
                        }
                        if (((Integer)list.get(list.size() - 1)).equals(edge.getFirstIndex())) {
                            list.add(edge.getSecondIndex());
                            --n;
                            edgeAppended = true;
                            continue;
                        }
                        if (!((Integer)list.get(list.size() - 1)).equals(edge.getSecondIndex())) continue;
                        list.add(edge.getFirstIndex());
                        --n;
                        edgeAppended = true;
                    }
                    if (!edgeAppended) continue;
                    break;
                }
                Edge edge = (Edge)edges.remove(edgeAppended ? n : 0);
                if (edgeAppended) continue;
                separateEdges.add(new ArrayList<Integer>(Arrays.asList(edge.getFirstIndex(), edge.getSecondIndex())));
            }
            for (List list : separateEdges) {
                MeshBuffers meshBuffers = new MeshBuffers(0);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    meshBuffers.append(this.vertices.get(index), this.normals.get(index));
                }
                Mesh mesh = new Mesh();
                mesh.setLineWidth(this.blenderContext.getBlenderKey().getLinesWidth());
                mesh.setMode(Mesh.Mode.LineStrip);
                if (meshBuffers.isShortIndexBuffer()) {
                    mesh.setBuffer(VertexBuffer.Type.Index, 1, (ShortBuffer)meshBuffers.getIndexBuffer());
                } else {
                    mesh.setBuffer(VertexBuffer.Type.Index, 1, (IntBuffer)meshBuffers.getIndexBuffer());
                }
                mesh.setBuffer(meshBuffers.getPositionsBuffer());
                mesh.setBuffer(meshBuffers.getNormalsBuffer());
                Geometry geometry = new Geometry(this.meshStructure.getName() + (result.size() + 1), mesh);
                geometry.setMaterial(meshHelper.getBlackUnshadedMaterial(this.blenderContext));
                if (this.properties != null && this.properties.getValue() != null) {
                    meshHelper.applyProperties((Spatial)geometry, this.properties);
                }
                result.add(geometry);
            }
        }
    }

    protected void preparePointsGeometry(List<Geometry> result, MeshHelper meshHelper) {
        if (this.points.size() > 0) {
            LOGGER.fine("Preparing point geometries.");
            MeshBuffers pointBuffers = new MeshBuffers(0);
            for (Point point : this.points) {
                pointBuffers.append(this.vertices.get(point.getIndex()), this.normals.get(point.getIndex()));
            }
            Mesh pointsMesh = new Mesh();
            pointsMesh.setMode(Mesh.Mode.Points);
            pointsMesh.setPointSize(this.blenderContext.getBlenderKey().getPointsSize());
            if (pointBuffers.isShortIndexBuffer()) {
                pointsMesh.setBuffer(VertexBuffer.Type.Index, 1, (ShortBuffer)pointBuffers.getIndexBuffer());
            } else {
                pointsMesh.setBuffer(VertexBuffer.Type.Index, 1, (IntBuffer)pointBuffers.getIndexBuffer());
            }
            pointsMesh.setBuffer(pointBuffers.getPositionsBuffer());
            pointsMesh.setBuffer(pointBuffers.getNormalsBuffer());
            Geometry pointsGeometry = new Geometry(this.meshStructure.getName() + (result.size() + 1), pointsMesh);
            pointsGeometry.setMaterial(meshHelper.getBlackUnshadedMaterial(this.blenderContext));
            if (this.properties != null && this.properties.getValue() != null) {
                meshHelper.applyProperties((Spatial)pointsGeometry, this.properties);
            }
            result.add(pointsGeometry);
        }
    }

    public String toString() {
        return "TemporalMesh [name=" + this.name + ", vertices.size()=" + this.vertices.size() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.meshStructure == null ? 0 : this.meshStructure.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TemporalMesh)) {
            return false;
        }
        TemporalMesh other = (TemporalMesh)((Object)obj);
        return this.meshStructure.getOldMemoryAddress().equals(other.meshStructure.getOldMemoryAddress());
    }
}

