/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.meshes.MeshHelper;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import com.jme3.scene.shape.Curve;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class ArrayModifier
extends Modifier {
    private static final Logger LOGGER = Logger.getLogger(ArrayModifier.class.getName());
    private int fittype;
    private int count;
    private float length;
    private float[] offset;
    private float[] scale;
    private Pointer pOffsetObject;
    private Pointer pStartCap;
    private Pointer pEndCap;

    public ArrayModifier(Structure modifierStructure, BlenderContext blenderContext) throws BlenderFileException {
        if (this.validate(modifierStructure, blenderContext)) {
            this.fittype = ((Number)modifierStructure.getFieldValue("fit_type")).intValue();
            switch (this.fittype) {
                case 0: {
                    this.count = ((Number)modifierStructure.getFieldValue("count")).intValue();
                    break;
                }
                case 1: {
                    this.length = ((Number)modifierStructure.getFieldValue("length")).floatValue();
                    break;
                }
                case 2: {
                    Pointer pCurveOb = (Pointer)modifierStructure.getFieldValue("curve_ob");
                    if (pCurveOb.isNotNull()) {
                        Structure curveStructure = pCurveOb.fetchData().get(0);
                        ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
                        Node curveObject = (Node)objectHelper.toObject(curveStructure, blenderContext);
                        HashSet<Number> referencesToCurveLengths = new HashSet<Number>(curveObject.getChildren().size());
                        for (Spatial spatial : curveObject.getChildren()) {
                            if (!(spatial instanceof Geometry)) continue;
                            Mesh mesh = ((Geometry)spatial).getMesh();
                            if (mesh instanceof Curve) {
                                this.length += ((Curve)mesh).getLength();
                                continue;
                            }
                            Number curveLength = (Number)spatial.getUserData("curveLength");
                            if (curveLength == null || referencesToCurveLengths.contains(curveLength)) continue;
                            this.length += curveLength.floatValue();
                            referencesToCurveLengths.add(curveLength);
                        }
                    }
                    this.fittype = 1;
                    break;
                }
                default: {
                    assert (false) : "Unknown array modifier fit type: " + this.fittype;
                    break;
                }
            }
            int offsettype = ((Number)modifierStructure.getFieldValue("offset_type")).intValue();
            if ((offsettype & 1) != 0) {
                DynamicArray offsetArray = (DynamicArray)modifierStructure.getFieldValue("offset");
                this.offset = new float[]{((Number)offsetArray.get(0)).floatValue(), ((Number)offsetArray.get(1)).floatValue(), ((Number)offsetArray.get(2)).floatValue()};
            }
            if ((offsettype & 2) != 0) {
                DynamicArray scaleArray = (DynamicArray)modifierStructure.getFieldValue("scale");
                this.scale = new float[]{((Number)scaleArray.get(0)).floatValue(), ((Number)scaleArray.get(1)).floatValue(), ((Number)scaleArray.get(2)).floatValue()};
            }
            if ((offsettype & 4) != 0) {
                this.pOffsetObject = (Pointer)modifierStructure.getFieldValue("offset_ob");
            }
            this.pStartCap = (Pointer)modifierStructure.getFieldValue("start_cap");
            this.pEndCap = (Pointer)modifierStructure.getFieldValue("end_cap");
        }
    }

    @Override
    public void apply(Node node, BlenderContext blenderContext) {
        if (this.invalid) {
            LOGGER.log(Level.WARNING, "Array modifier is invalid! Cannot be applied to: {0}", node.getName());
        } else {
            TemporalMesh temporalMesh = this.getTemporalMesh(node);
            if (temporalMesh != null) {
                TemporalMesh capsClone;
                LOGGER.log(Level.FINE, "Applying array modifier to: {0}", (Object)temporalMesh);
                if (this.offset == null) {
                    this.offset = new float[]{0.0f, 0.0f, 0.0f};
                }
                if (this.scale == null) {
                    this.scale = new float[]{0.0f, 0.0f, 0.0f};
                } else {
                    temporalMesh.updateModelBound();
                    BoundingVolume boundingVolume = temporalMesh.getWorldBound();
                    if (boundingVolume instanceof BoundingBox) {
                        this.scale[0] = this.scale[0] * (((BoundingBox)boundingVolume).getXExtent() * 2.0f);
                        this.scale[1] = this.scale[1] * (((BoundingBox)boundingVolume).getYExtent() * 2.0f);
                        this.scale[2] = this.scale[2] * (((BoundingBox)boundingVolume).getZExtent() * 2.0f);
                    } else if (boundingVolume instanceof BoundingSphere) {
                        float radius = ((BoundingSphere)boundingVolume).getRadius();
                        this.scale[0] = this.scale[0] * (radius * 2.0f);
                        this.scale[1] = this.scale[1] * (radius * 2.0f);
                        this.scale[2] = this.scale[2] * (radius * 2.0f);
                    } else {
                        throw new IllegalStateException("Unknown bounding volume type: " + boundingVolume.getClass().getName());
                    }
                }
                float[] objectOffset = new float[]{0.0f, 0.0f, 0.0f};
                if (this.pOffsetObject != null && this.pOffsetObject.isNotNull()) {
                    FileBlockHeader offsetObjectBlock = blenderContext.getFileBlock(this.pOffsetObject.getOldMemoryAddress());
                    ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
                    try {
                        Structure offsetStructure = offsetObjectBlock.getStructure(blenderContext);
                        Vector3f translation = objectHelper.getTransformation(offsetStructure, blenderContext).getTranslation();
                        objectOffset[0] = translation.x;
                        objectOffset[1] = translation.y;
                        objectOffset[2] = translation.z;
                    }
                    catch (BlenderFileException e) {
                        LOGGER.log(Level.WARNING, "Problems in blender file structure! Object offset cannot be applied! The problem: {0}", e.getMessage());
                    }
                }
                MeshHelper meshHelper = (MeshHelper)blenderContext.getHelper(MeshHelper.class);
                TemporalMesh[] caps = new TemporalMesh[]{null, null};
                Pointer[] pCaps = new Pointer[]{this.pStartCap, this.pEndCap};
                for (int i = 0; i < pCaps.length; ++i) {
                    if (!pCaps[i].isNotNull()) continue;
                    FileBlockHeader capBlock = blenderContext.getFileBlock(pCaps[i].getOldMemoryAddress());
                    try {
                        Structure capStructure = capBlock.getStructure(blenderContext);
                        Pointer pMesh = (Pointer)capStructure.getFieldValue("data");
                        List<Structure> meshesArray = pMesh.fetchData();
                        caps[i] = meshHelper.toTemporalMesh(meshesArray.get(0), blenderContext);
                        continue;
                    }
                    catch (BlenderFileException e) {
                        LOGGER.log(Level.WARNING, "Problems in blender file structure! Cap object cannot be applied! The problem: {0}", e.getMessage());
                    }
                }
                Vector3f translationVector = new Vector3f(this.offset[0] + this.scale[0] + objectOffset[0], this.offset[1] + this.scale[1] + objectOffset[1], this.offset[2] + this.scale[2] + objectOffset[2]);
                if (blenderContext.getBlenderKey().isFixUpAxis()) {
                    float y = translationVector.y;
                    translationVector.y = translationVector.z;
                    translationVector.z = y == 0.0f ? 0.0f : -y;
                }
                int count = 0;
                if (this.fittype == 0) {
                    count = this.count - 1;
                } else if (this.fittype == 1) {
                    float length = this.length;
                    if (translationVector.length() > 0.0f) {
                        count = (int)(length / translationVector.length()) - 1;
                    }
                } else {
                    if (this.fittype == 2) {
                        throw new IllegalStateException("Fit curve should be transformed to Fixed Length array type!");
                    }
                    throw new IllegalStateException("Unknown fit type: " + this.fittype);
                }
                Vector3f totalTranslation = new Vector3f(translationVector);
                if (count > 0) {
                    TemporalMesh originalMesh = temporalMesh.clone();
                    for (int i = 0; i < count; ++i) {
                        TemporalMesh clone = originalMesh.clone();
                        for (Vector3f v : clone.getVertices()) {
                            v.addLocal(totalTranslation);
                        }
                        temporalMesh.append(clone);
                        totalTranslation.addLocal(translationVector);
                    }
                }
                if (caps[0] != null) {
                    translationVector.multLocal(-1.0f);
                    capsClone = caps[0].clone();
                    for (Vector3f v : capsClone.getVertices()) {
                        v.addLocal(translationVector);
                    }
                    temporalMesh.append(capsClone);
                }
                if (caps[1] != null) {
                    capsClone = caps[1].clone();
                    for (Vector3f v : capsClone.getVertices()) {
                        v.addLocal(totalTranslation);
                    }
                    temporalMesh.append(capsClone);
                }
            } else {
                LOGGER.log(Level.WARNING, "Cannot find temporal mesh for node: {0}. The modifier will NOT be applied!", node);
            }
        }
    }
}

