/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.meshes.Edge;
import com.jme3.scene.plugins.blender.meshes.Face;
import com.jme3.scene.plugins.blender.meshes.IndexesLoop;
import com.jme3.scene.plugins.blender.meshes.Point;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class MaskModifier
extends Modifier {
    private static final Logger LOGGER = Logger.getLogger(MaskModifier.class.getName());
    private static final int FLAG_INVERT_MASK = 1;
    private static final int MODE_VERTEX_GROUP = 0;
    private static final int MODE_ARMATURE = 1;
    private Pointer pArmatureObject;
    private String vertexGroupName;
    private boolean invertMask;

    public MaskModifier(Structure modifierStructure, BlenderContext blenderContext) {
        if (this.validate(modifierStructure, blenderContext)) {
            int flag = ((Number)modifierStructure.getFieldValue("flag")).intValue();
            this.invertMask = (flag & 1) != 0;
            int mode = ((Number)modifierStructure.getFieldValue("mode")).intValue();
            if (mode == 0) {
                this.vertexGroupName = modifierStructure.getFieldValue("vgroup").toString();
                if (this.vertexGroupName != null && this.vertexGroupName.length() == 0) {
                    this.vertexGroupName = null;
                }
            } else if (mode == 1) {
                this.pArmatureObject = (Pointer)modifierStructure.getFieldValue("ob_arm");
            } else {
                LOGGER.log(Level.SEVERE, "Unknown mode type: {0}. Cannot apply modifier: {1}.", new Object[]{mode, modifierStructure.getName()});
                this.invalid = true;
            }
        }
    }

    @Override
    public void apply(Node node, BlenderContext blenderContext) {
        if (this.invalid) {
            LOGGER.log(Level.WARNING, "Mirror modifier is invalid! Cannot be applied to: {0}", node.getName());
        } else {
            TemporalMesh temporalMesh = this.getTemporalMesh(node);
            if (temporalMesh != null) {
                ArrayList<String> vertexGroupsToRemove = new ArrayList<String>();
                if (this.vertexGroupName != null) {
                    vertexGroupsToRemove.add(this.vertexGroupName);
                } else if (this.pArmatureObject != null && this.pArmatureObject.isNotNull()) {
                    try {
                        Structure armatureObject = this.pArmatureObject.fetchData().get(0);
                        Structure armatureStructure = ((Pointer)armatureObject.getFieldValue("data")).fetchData().get(0);
                        List<Structure> bonebase = ((Structure)armatureStructure.getFieldValue("bonebase")).evaluateListBase();
                        vertexGroupsToRemove.addAll(this.readBoneNames(bonebase));
                    }
                    catch (BlenderFileException e) {
                        LOGGER.log(Level.SEVERE, "Cannot load armature object for the mask modifier. Cause: {0}", e.getLocalizedMessage());
                        LOGGER.log(Level.SEVERE, "Mask modifier will NOT be applied to node named: {0}", node.getName());
                    }
                } else {
                    HashSet<String> vertexGroupNames = new HashSet<String>();
                    for (Map<String, Float> groups : temporalMesh.getVertexGroups()) {
                        vertexGroupNames.addAll(groups.keySet());
                    }
                    if (vertexGroupNames.size() == 0 && !this.invertMask || vertexGroupNames.size() > 0 && this.invertMask) {
                        temporalMesh.clear();
                    }
                }
                if (vertexGroupsToRemove.size() > 0) {
                    ArrayList<Integer> vertsToBeRemoved = new ArrayList<Integer>();
                    for (int i = 0; i < temporalMesh.getVertexCount(); ++i) {
                        Map<String, Float> vertexGroups = temporalMesh.getVertexGroups().get(i);
                        boolean hasVertexGroup = false;
                        if (vertexGroups != null) {
                            for (String groupName : vertexGroupsToRemove) {
                                Float weight = vertexGroups.get(groupName);
                                if (weight == null || !(weight.floatValue() > 0.0f)) continue;
                                hasVertexGroup = true;
                                break;
                            }
                        }
                        if ((hasVertexGroup || this.invertMask) && (!hasVertexGroup || !this.invertMask)) continue;
                        vertsToBeRemoved.add(i);
                    }
                    Collections.reverse(vertsToBeRemoved);
                    for (Integer vertexIndex : vertsToBeRemoved) {
                        this.removeVertexAt(vertexIndex, temporalMesh);
                    }
                }
            } else {
                LOGGER.log(Level.WARNING, "Cannot find temporal mesh for node: {0}. The modifier will NOT be applied!", node);
            }
        }
    }

    private void removeVertexAt(final int index, TemporalMesh temporalMesh) {
        int i;
        if (index < 0 || index >= temporalMesh.getVertexCount()) {
            throw new IndexOutOfBoundsException("The given index is out of bounds: " + index);
        }
        temporalMesh.getVertices().remove(index);
        temporalMesh.getNormals().remove(index);
        if (temporalMesh.getVertexGroups().size() > 0) {
            temporalMesh.getVertexGroups().remove(index);
        }
        if (temporalMesh.getVerticesColors().size() > 0) {
            temporalMesh.getVerticesColors().remove(index);
        }
        IndexesLoop.IndexPredicate shiftPredicate = new IndexesLoop.IndexPredicate(){

            @Override
            public boolean execute(Integer i) {
                return i > index;
            }
        };
        for (i = temporalMesh.getFaces().size() - 1; i >= 0; --i) {
            Face face = temporalMesh.getFaces().get(i);
            if (face.getIndexes().indexOf(index) >= 0) {
                temporalMesh.getFaces().remove(i);
                continue;
            }
            face.getIndexes().shiftIndexes(-1, shiftPredicate);
        }
        for (i = temporalMesh.getEdges().size() - 1; i >= 0; --i) {
            Edge edge = temporalMesh.getEdges().get(i);
            if (edge.getFirstIndex() == index || edge.getSecondIndex() == index) {
                temporalMesh.getEdges().remove(i);
                continue;
            }
            edge.shiftIndexes(-1, shiftPredicate);
        }
        for (i = temporalMesh.getPoints().size() - 1; i >= 0; --i) {
            Point point = temporalMesh.getPoints().get(i);
            if (point.getIndex() == index) {
                temporalMesh.getPoints().remove(i);
                continue;
            }
            point.shiftIndexes(-1, shiftPredicate);
        }
    }

    private List<String> readBoneNames(List<Structure> boneBase) throws BlenderFileException {
        ArrayList<String> result = new ArrayList<String>();
        for (Structure boneStructure : boneBase) {
            int flag = ((Number)boneStructure.getFieldValue("flag")).intValue();
            if ((flag & 1) != 0) {
                result.add(boneStructure.getFieldValue("name").toString());
            }
            List<Structure> childbase = ((Structure)boneStructure.getFieldValue("childbase")).evaluateListBase();
            result.addAll(this.readBoneNames(childbase));
        }
        return result;
    }
}

