/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.effect.ParticleEmitter;
import com.jme3.effect.shapes.EmitterMeshVertexShape;
import com.jme3.effect.shapes.EmitterShape;
import com.jme3.material.Material;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import com.jme3.scene.plugins.blender.modifiers.MirrorModifier;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.particles.ParticlesHelper;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

class ParticlesModifier
extends Modifier {
    private static final Logger LOGGER = Logger.getLogger(MirrorModifier.class.getName());
    private ParticleEmitter particleEmitter;

    public ParticlesModifier(Structure modifierStructure, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pParticleSystem;
        if (this.validate(modifierStructure, blenderContext) && (pParticleSystem = (Pointer)modifierStructure.getFieldValue("psys")).isNotNull()) {
            ParticlesHelper particlesHelper = (ParticlesHelper)blenderContext.getHelper(ParticlesHelper.class);
            Structure particleSystem = pParticleSystem.fetchData().get(0);
            this.particleEmitter = particlesHelper.toParticleEmitter(particleSystem);
        }
    }

    @Override
    public void postMeshCreationApply(Node node, BlenderContext blenderContext) {
        LOGGER.log(Level.FINE, "Applying particles modifier to: {0}", node);
        MaterialHelper materialHelper = (MaterialHelper)blenderContext.getHelper(MaterialHelper.class);
        ParticleEmitter emitter = this.particleEmitter.clone();
        Integer alphaFunction = MaterialHelper.ALPHA_MASK_HYPERBOLE;
        char nameSuffix = emitter.getName().charAt(emitter.getName().length() - 1);
        if (nameSuffix == 'B' || nameSuffix == 'N') {
            alphaFunction = MaterialHelper.ALPHA_MASK_NONE;
        }
        emitter.setName(emitter.getName().substring(0, emitter.getName().length() - 1));
        EmitterShape emitterShape = emitter.getShape();
        ArrayList<Mesh> meshes = new ArrayList<Mesh>();
        for (Spatial spatial : node.getChildren()) {
            Mesh mesh;
            if (!(spatial instanceof Geometry) || (mesh = ((Geometry)spatial).getMesh()) == null) continue;
            meshes.add(mesh);
            Material material = materialHelper.getParticlesMaterial(((Geometry)spatial).getMaterial(), alphaFunction, blenderContext);
            emitter.setMaterial(material);
        }
        if (meshes.size() > 0 && emitterShape instanceof EmitterMeshVertexShape) {
            ((EmitterMeshVertexShape)emitterShape).setMeshes(meshes);
        }
        node.attachChild((Spatial)emitter);
    }

    @Override
    public void apply(Node node, BlenderContext blenderContext) {
        if (this.invalid) {
            LOGGER.log(Level.WARNING, "Particles modifier is invalid! Cannot be applied to: {0}", node.getName());
        } else {
            TemporalMesh temporalMesh = this.getTemporalMesh(node);
            if (temporalMesh != null) {
                temporalMesh.applyAfterMeshCreate(this);
            } else {
                LOGGER.log(Level.WARNING, "Cannot find temporal mesh for node: {0}. The modifier will NOT be applied!", node);
            }
        }
    }
}

