/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import com.jme3.scene.plugins.blender.textures.ColorBand;
import com.jme3.scene.plugins.blender.textures.GeneratedTexture;
import com.jme3.scene.plugins.blender.textures.ImageLoader;
import com.jme3.scene.plugins.blender.textures.ImageUtils;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.TriangulatedTexture;
import com.jme3.scene.plugins.blender.textures.UVCoordinatesGenerator;
import com.jme3.scene.plugins.blender.textures.UVProjectionGenerator;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlender;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlenderFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelIOFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelInputOutput;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.TextureCubeMap;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3tools.converters.ImageToAwt;

public class CombinedTexture {
    private static final Logger LOGGER = Logger.getLogger(CombinedTexture.class.getName());
    private final int mappingType;
    private boolean discardCoveredTextures;
    private List<TextureData> textureDatas = new ArrayList<TextureData>();
    private Texture resultTexture;
    private List<Vector2f> resultUVS;

    public CombinedTexture(int mappingType, boolean discardCoveredTextures) {
        this.mappingType = mappingType;
        this.discardCoveredTextures = discardCoveredTextures;
    }

    public void add(Texture texture, TextureBlender textureBlender, int uvCoordinatesType, int projectionType, Structure textureStructure, String uvCoordinatesName, BlenderContext blenderContext) {
        if (!(texture instanceof GeneratedTexture) && !(texture instanceof Texture2D)) {
            throw new IllegalArgumentException("Unsupported texture type: " + (texture == null ? "null" : texture.getClass()));
        }
        if (!(texture instanceof GeneratedTexture) || blenderContext.getBlenderKey().isLoadGeneratedTextures()) {
            if (UVCoordinatesGenerator.isTextureCoordinateTypeSupported(UVCoordinatesGenerator.UVCoordinatesType.valueOf(uvCoordinatesType))) {
                TextureData textureData = new TextureData();
                textureData.texture = texture;
                textureData.textureBlender = textureBlender;
                textureData.uvCoordinatesType = UVCoordinatesGenerator.UVCoordinatesType.valueOf(uvCoordinatesType);
                textureData.projectionType = UVProjectionGenerator.UVProjectionType.valueOf(projectionType);
                textureData.textureStructure = textureStructure;
                textureData.uvCoordinatesName = uvCoordinatesName;
                if (this.discardCoveredTextures && this.textureDatas.size() > 0 && this.isWithoutAlpha(textureData, blenderContext)) {
                    this.textureDatas.clear();
                }
                this.textureDatas.add(textureData);
            } else {
                LOGGER.warning("The texture coordinates type is not supported: " + (Object)((Object)UVCoordinatesGenerator.UVCoordinatesType.valueOf(uvCoordinatesType)) + ". The texture '" + textureStructure.getName() + "'.");
            }
        }
    }

    public String flatten(Geometry geometry, Long geometriesOMA, Map<String, List<Vector2f>> userDefinedUVCoordinates, BlenderContext blenderContext) {
        Mesh mesh = geometry.getMesh();
        Object previousTexture = null;
        UVCoordinatesGenerator.UVCoordinatesType masterUVCoordinatesType = null;
        String masterUserUVSetName = null;
        for (TextureData textureData : this.textureDatas) {
            if (this.textureDatas.size() > 1 && textureData.texture.getImage().getFormat().isCompressed()) {
                textureData.texture.setImage(ImageUtils.decompress(textureData.texture.getImage()));
                textureData.textureBlender = TextureBlenderFactory.alterTextureType(textureData.texture.getImage().getFormat(), textureData.textureBlender);
            }
            if (previousTexture == null) {
                if (textureData.texture instanceof GeneratedTexture) {
                    this.resultTexture = ((GeneratedTexture)textureData.texture).triangulate(mesh, geometriesOMA, textureData.uvCoordinatesType, blenderContext);
                } else if (textureData.texture instanceof Texture2D) {
                    this.resultTexture = textureData.texture;
                    if (textureData.uvCoordinatesType == UVCoordinatesGenerator.UVCoordinatesType.TEXCO_UV && userDefinedUVCoordinates != null && userDefinedUVCoordinates.size() > 0) {
                        this.resultUVS = textureData.uvCoordinatesName == null ? userDefinedUVCoordinates.values().iterator().next() : userDefinedUVCoordinates.get(textureData.uvCoordinatesName);
                        if (this.resultUVS == null && LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.warning("The texture " + textureData.texture.getName() + " has assigned non existing UV coordinates group: " + textureData.uvCoordinatesName + ".");
                        }
                        masterUserUVSetName = textureData.uvCoordinatesName;
                    } else {
                        TemporalMesh temporalMesh = (TemporalMesh)((Object)blenderContext.getLoadedFeature(geometriesOMA, BlenderContext.LoadedDataType.TEMPORAL_MESH));
                        this.resultUVS = UVCoordinatesGenerator.generateUVCoordinatesFor2DTexture(mesh, textureData.uvCoordinatesType, textureData.projectionType, temporalMesh);
                    }
                }
                this.blend(this.resultTexture, textureData.textureBlender, blenderContext);
                previousTexture = this.resultTexture;
                masterUVCoordinatesType = textureData.uvCoordinatesType;
                continue;
            }
            if (textureData.texture instanceof GeneratedTexture) {
                if (!(this.resultTexture instanceof TriangulatedTexture)) {
                    this.resultTexture = new TriangulatedTexture((Texture2D)this.resultTexture, this.resultUVS, blenderContext);
                    this.resultUVS = null;
                    previousTexture = this.resultTexture;
                }
                TriangulatedTexture triangulatedTexture = ((GeneratedTexture)textureData.texture).triangulate(mesh, geometriesOMA, textureData.uvCoordinatesType, blenderContext);
                triangulatedTexture.castToUVS((TriangulatedTexture)this.resultTexture, blenderContext);
                triangulatedTexture.blend(textureData.textureBlender, (TriangulatedTexture)this.resultTexture, blenderContext);
                this.resultTexture = previousTexture = triangulatedTexture;
                continue;
            }
            if (!(textureData.texture instanceof Texture2D)) continue;
            if (this.isUVTypesMatch(masterUVCoordinatesType, masterUserUVSetName, textureData.uvCoordinatesType, textureData.uvCoordinatesName) && this.resultTexture instanceof Texture2D) {
                this.scale((Texture2D)textureData.texture, this.resultTexture.getImage().getWidth(), this.resultTexture.getImage().getHeight());
                ImageUtils.merge(this.resultTexture.getImage(), textureData.texture.getImage());
                previousTexture = this.resultTexture;
                continue;
            }
            if (!(this.resultTexture instanceof TriangulatedTexture)) {
                this.resultTexture = new TriangulatedTexture((Texture2D)this.resultTexture, this.resultUVS, blenderContext);
                this.resultUVS = null;
            }
            List<Vector2f> textureUVS = null;
            if (textureData.uvCoordinatesType == UVCoordinatesGenerator.UVCoordinatesType.TEXCO_UV && userDefinedUVCoordinates != null && userDefinedUVCoordinates.size() > 0) {
                textureUVS = textureData.uvCoordinatesName == null ? userDefinedUVCoordinates.values().iterator().next() : userDefinedUVCoordinates.get(textureData.uvCoordinatesName);
            } else {
                TemporalMesh geometries = (TemporalMesh)((Object)blenderContext.getLoadedFeature(geometriesOMA, BlenderContext.LoadedDataType.TEMPORAL_MESH));
                textureUVS = UVCoordinatesGenerator.generateUVCoordinatesFor2DTexture(mesh, textureData.uvCoordinatesType, textureData.projectionType, geometries);
            }
            TriangulatedTexture triangulatedTexture = new TriangulatedTexture((Texture2D)textureData.texture, textureUVS, blenderContext);
            triangulatedTexture.castToUVS((TriangulatedTexture)this.resultTexture, blenderContext);
            for (int i = 0; i < ((TriangulatedTexture)this.resultTexture).getFaceTextureCount(); ++i) {
                ImageUtils.merge(((TriangulatedTexture)this.resultTexture).getFaceTextureElement((int)i).image, triangulatedTexture.getFaceTextureElement((int)i).image);
            }
        }
        if (this.resultTexture instanceof TriangulatedTexture) {
            if (this.mappingType == 2) {
                for (int i = 0; i < ((TriangulatedTexture)this.resultTexture).getFaceTextureCount(); ++i) {
                    TriangulatedTexture.TriangleTextureElement triangleTextureElement = ((TriangulatedTexture)this.resultTexture).getFaceTextureElement(i);
                    triangleTextureElement.image = ImageUtils.convertToNormalMapTexture(triangleTextureElement.image, 1.0f);
                }
            }
            this.resultUVS = ((TriangulatedTexture)this.resultTexture).getResultUVS();
            this.resultTexture = ((TriangulatedTexture)this.resultTexture).getResultTexture();
            masterUserUVSetName = null;
        }
        this.resultTexture.setWrap(Texture.WrapMode.Repeat);
        this.resultTexture.setMagFilter(Texture.MagFilter.Nearest);
        this.resultTexture.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
        return masterUserUVSetName;
    }

    public TextureCubeMap generateSkyTexture(ColorRGBA horizontalColor, ColorRGBA zenithColor, BlenderContext blenderContext) {
        LOGGER.log(Level.FINE, "Preparing sky texture from {0} applied textures.", this.textureDatas.size());
        LOGGER.fine("Computing the texture size.");
        int size = -1;
        for (TextureData textureData : this.textureDatas) {
            if (!(textureData.texture instanceof Texture2D)) continue;
            size = Math.max(textureData.texture.getImage().getWidth(), size);
            size = Math.max(textureData.texture.getImage().getHeight(), size);
        }
        if (size < 0) {
            size = blenderContext.getBlenderKey().getSkyGeneratedTextureSize();
        }
        LOGGER.log(Level.FINE, "The sky texture size will be: {0}x{0}.", size);
        TextureCubeMap result = null;
        for (TextureData textureData : this.textureDatas) {
            TextureCubeMap texture = null;
            if (textureData.texture instanceof GeneratedTexture) {
                texture = ((GeneratedTexture)textureData.texture).generateSkyTexture(size, horizontalColor, zenithColor, blenderContext);
            } else {
                Image image = textureData.texture.getImage();
                if (image.getWidth() != image.getHeight() || image.getWidth() != size) {
                    image = ImageUtils.resizeTo(image, size, size);
                }
                Image grayscaleImage = ImageUtils.convertToGrayscaleTexture(image);
                PixelInputOutput sourcePixelIO = PixelIOFactory.getPixelIO(grayscaleImage.getFormat());
                PixelInputOutput targetPixelIO = PixelIOFactory.getPixelIO(image.getFormat());
                TexturePixel texturePixel = new TexturePixel();
                for (int x = 0; x < image.getWidth(); ++x) {
                    for (int y = 0; y < image.getHeight(); ++y) {
                        sourcePixelIO.read(grayscaleImage, 0, texturePixel, x, y);
                        texturePixel.intensity = texturePixel.red;
                        ImageUtils.color(texturePixel, horizontalColor, zenithColor);
                        targetPixelIO.write(image, 0, texturePixel, x, y);
                    }
                }
                ByteBuffer sourceData = image.getData(0);
                ArrayList<ByteBuffer> data = new ArrayList<ByteBuffer>(6);
                for (int i = 0; i < 6; ++i) {
                    data.add(BufferUtils.clone((ByteBuffer)sourceData));
                }
                texture = new TextureCubeMap(new Image(image.getFormat(), image.getWidth(), image.getHeight(), 6, data, ColorSpace.Linear));
            }
            if (result == null) {
                result = texture;
                continue;
            }
            ImageUtils.mix(result.getImage(), texture.getImage());
        }
        return result;
    }

    private boolean isUVTypesMatch(UVCoordinatesGenerator.UVCoordinatesType type1, String uvSetName1, UVCoordinatesGenerator.UVCoordinatesType type2, String uvSetName2) {
        if (type1 == type2) {
            if (type1 == UVCoordinatesGenerator.UVCoordinatesType.TEXCO_UV) {
                if (uvSetName1 != null && uvSetName2 != null && uvSetName1.equals(uvSetName2)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private void blend(Texture texture, TextureBlender textureBlender, BlenderContext blenderContext) {
        if (texture instanceof TriangulatedTexture) {
            ((TriangulatedTexture)texture).blend(textureBlender, null, blenderContext);
        } else if (texture instanceof Texture2D) {
            Image blendedImage = textureBlender.blend(texture.getImage(), null, blenderContext);
            texture.setImage(blendedImage);
        } else {
            throw new IllegalArgumentException("Invalid type for texture to blend!");
        }
    }

    public Texture getResultTexture() {
        return this.resultTexture;
    }

    public List<Vector2f> getResultUVS() {
        return this.resultUVS;
    }

    public int getTexturesCount() {
        return this.textureDatas.size();
    }

    public int getMappingType() {
        return this.mappingType;
    }

    public boolean hasGeneratedTextures() {
        if (this.textureDatas != null) {
            for (TextureData textureData : this.textureDatas) {
                if (!(textureData.texture instanceof GeneratedTexture)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isWithoutAlpha(TextureData textureData, BlenderContext blenderContext) {
        ColorBand colorBand = new ColorBand(textureData.textureStructure, blenderContext);
        if (!colorBand.hasTransparencies()) {
            int type = ((Number)textureData.textureStructure.getFieldValue("type")).intValue();
            if (type == 4) {
                return true;
            }
            if (type == 12) {
                int voronoiColorType = ((Number)textureData.textureStructure.getFieldValue("vn_coltype")).intValue();
                return voronoiColorType != 0;
            }
            if (type == 1) {
                int sType = ((Number)textureData.textureStructure.getFieldValue("stype")).intValue();
                return sType == 1;
            }
            if (type == 8) {
                Image image = textureData.texture.getImage();
                switch (image.getFormat()) {
                    case BGR8: 
                    case DXT1: 
                    case Luminance16F: 
                    case Luminance32F: 
                    case Luminance8: 
                    case RGB111110F: 
                    case RGB16F: 
                    case RGB32F: 
                    case RGB565: 
                    case RGB8: {
                        return true;
                    }
                    case ABGR8: 
                    case DXT1A: 
                    case DXT3: 
                    case DXT5: 
                    case Luminance16FAlpha16F: 
                    case Luminance8Alpha8: 
                    case RGBA16F: 
                    case RGBA32F: 
                    case RGBA8: 
                    case ARGB8: 
                    case BGRA8: 
                    case RGB5A1: {
                        PixelInputOutput pixelInputOutput = PixelIOFactory.getPixelIO(image.getFormat());
                        TexturePixel pixel = new TexturePixel();
                        int depth = image.getDepth() == 0 ? 1 : image.getDepth();
                        for (int layerIndex = 0; layerIndex < depth; ++layerIndex) {
                            for (int x = 0; x < image.getWidth(); ++x) {
                                for (int y = 0; y < image.getHeight(); ++y) {
                                    pixelInputOutput.read(image, layerIndex, pixel, x, y);
                                    if (!(pixel.alpha < 1.0f)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                }
                throw new IllegalStateException("Unknown image format: " + image.getFormat());
            }
        }
        return false;
    }

    private void scale(Texture2D texture, int width, int height) {
        boolean scaleRequired;
        boolean bl = scaleRequired = texture.getImage().getWidth() != width || texture.getImage().getHeight() != height;
        if (scaleRequired) {
            Image image = texture.getImage();
            BufferedImage sourceImage = ImageToAwt.convert((Image)image, (boolean)false, (boolean)true, (int)0);
            int sourceWidth = sourceImage.getWidth();
            int sourceHeight = sourceImage.getHeight();
            BufferedImage targetImage = new BufferedImage(width, height, sourceImage.getType());
            Graphics2D g = targetImage.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(sourceImage, 0, 0, width, height, 0, 0, sourceWidth, sourceHeight, null);
            g.dispose();
            Image output = new ImageLoader().load(targetImage, false);
            image.setWidth(width);
            image.setHeight(height);
            image.setData(output.getData(0));
            image.setFormat(output.getFormat());
        }
    }

    private static class TextureData {
        public Texture texture;
        public TextureBlender textureBlender;
        public UVCoordinatesGenerator.UVCoordinatesType uvCoordinatesType;
        public UVProjectionGenerator.UVProjectionType projectionType;
        public Structure textureStructure;
        public String uvCoordinatesName;

        private TextureData() {
        }
    }
}

