/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.plugins.AWTLoader;
import com.jme3.texture.plugins.HDRLoader;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class ImageLoader
extends AWTLoader {
    private static final Logger LOGGER = Logger.getLogger(ImageLoader.class.getName());
    private static final Logger hdrLogger = Logger.getLogger(HDRLoader.class.getName());
    private static final String[] extensions = new String[]{".bmp", ".sgi", ".rgb", ".bw", ".png", ".jpg", ".jpeg", ".jp2", ".j2c", ".tga", ".cin", ".dpx", ".exr", ".hdr", ".tif", ".tiff", ".dds"};

    ImageLoader() {
    }

    public Image loadImage(AssetManager assetManager, BlenderInputStream inputStream, int startPosition, boolean flipY) {
        Texture tex = this.loadTexture(assetManager, inputStream, startPosition, flipY);
        if (tex == null) {
            return null;
        }
        return tex.getImage();
    }

    public Texture loadTexture(AssetManager assetManager, BlenderInputStream inputStream, int startPosition, boolean flipY) {
        inputStream.setPosition(startPosition);
        Texture result = null;
        hdrLogger.setLevel(Level.SEVERE);
        for (String ext : extensions) {
            TextureKey tKey = new TextureKey("dummy" + ext, flipY);
            try {
                result = (Texture)assetManager.loadAssetFromStream((AssetKey)tKey, (InputStream)inputStream);
            }
            catch (Exception e) {
                continue;
            }
            if (result != null) break;
        }
        if (result == null) {
            LOGGER.warning("Texture could not be loaded by any of the available loaders!\nSince the file has been packed into the blender file, there is noway for us to tell you which texture it was.");
        }
        return result;
    }
}

