/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.app.AppTask;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionEventFactory;
import com.jme3.bullet.collision.PhysicsCollisionGroupListener;
import com.jme3.bullet.collision.PhysicsCollisionListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.PhysicsRayTestResult;
import com.jme3.bullet.collision.PhysicsSweepTestResult;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.bullet.objects.PhysicsGhostObject;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhysicsSpace {
    private static final Logger logger = Logger.getLogger(PhysicsSpace.class.getName());
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_Z = 2;
    private long physicsSpaceId = 0L;
    private static ThreadLocal<ConcurrentLinkedQueue<AppTask<?>>> pQueueTL = new ThreadLocal<ConcurrentLinkedQueue<AppTask<?>>>(){

        @Override
        protected ConcurrentLinkedQueue<AppTask<?>> initialValue() {
            return new ConcurrentLinkedQueue();
        }
    };
    private ConcurrentLinkedQueue<AppTask<?>> pQueue = new ConcurrentLinkedQueue();
    private static ThreadLocal<PhysicsSpace> physicsSpaceTL = new ThreadLocal();
    private BroadphaseType broadphaseType = BroadphaseType.DBVT;
    private Map<Long, PhysicsGhostObject> physicsGhostObjects = new ConcurrentHashMap<Long, PhysicsGhostObject>();
    private Map<Long, PhysicsCharacter> physicsCharacters = new ConcurrentHashMap<Long, PhysicsCharacter>();
    private Map<Long, PhysicsRigidBody> physicsBodies = new ConcurrentHashMap<Long, PhysicsRigidBody>();
    private Map<Long, PhysicsJoint> physicsJoints = new ConcurrentHashMap<Long, PhysicsJoint>();
    private Map<Long, PhysicsVehicle> physicsVehicles = new ConcurrentHashMap<Long, PhysicsVehicle>();
    private ArrayList<PhysicsCollisionListener> collisionListeners = new ArrayList();
    private ArrayDeque<PhysicsCollisionEvent> collisionEvents = new ArrayDeque();
    private Map<Integer, PhysicsCollisionGroupListener> collisionGroupListeners = new ConcurrentHashMap<Integer, PhysicsCollisionGroupListener>();
    private ConcurrentLinkedQueue<PhysicsTickListener> tickListeners = new ConcurrentLinkedQueue();
    private PhysicsCollisionEventFactory eventFactory = new PhysicsCollisionEventFactory();
    private Vector3f worldMin = new Vector3f(-10000.0f, -10000.0f, -10000.0f);
    private Vector3f worldMax = new Vector3f(10000.0f, 10000.0f, 10000.0f);
    private float accuracy = 0.016666668f;
    private int maxSubSteps = 4;
    private int rayTestFlags = 4;
    private int solverNumIterations = 10;
    private final Vector3f gravity = new Vector3f(0.0f, -9.81f, 0.0f);

    public static PhysicsSpace getPhysicsSpace() {
        return physicsSpaceTL.get();
    }

    public static void setLocalThreadPhysicsSpace(PhysicsSpace space) {
        physicsSpaceTL.set(space);
    }

    public PhysicsSpace() {
        this(new Vector3f(-10000.0f, -10000.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f), BroadphaseType.DBVT);
    }

    public PhysicsSpace(BroadphaseType broadphaseType) {
        this(new Vector3f(-10000.0f, -10000.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f), broadphaseType);
    }

    public PhysicsSpace(Vector3f worldMin, Vector3f worldMax) {
        this(worldMin, worldMax, BroadphaseType.AXIS_SWEEP_3);
    }

    public PhysicsSpace(Vector3f worldMin, Vector3f worldMax, BroadphaseType broadphaseType) {
        this.worldMin.set(worldMin);
        this.worldMax.set(worldMax);
        this.broadphaseType = broadphaseType;
        this.create();
    }

    public void create() {
        this.physicsSpaceId = this.createPhysicsSpace(this.worldMin.x, this.worldMin.y, this.worldMin.z, this.worldMax.x, this.worldMax.y, this.worldMax.z, this.broadphaseType.ordinal(), false);
        pQueueTL.set(this.pQueue);
        physicsSpaceTL.set(this);
    }

    private native long createPhysicsSpace(float var1, float var2, float var3, float var4, float var5, float var6, int var7, boolean var8);

    private void preTick_native(float f) {
        AppTask<?> task = this.pQueue.poll();
        task = this.pQueue.poll();
        while (task != null) {
            while (task.isCancelled()) {
                task = this.pQueue.poll();
            }
            try {
                task.invoke();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            task = this.pQueue.poll();
        }
        for (PhysicsTickListener physicsTickCallback : this.tickListeners) {
            physicsTickCallback.prePhysicsTick(this, f);
        }
    }

    private void postTick_native(float f) {
        for (PhysicsTickListener physicsTickCallback : this.tickListeners) {
            physicsTickCallback.physicsTick(this, f);
        }
    }

    private void addCollision_native() {
    }

    private boolean needCollision_native(PhysicsCollisionObject objectA, PhysicsCollisionObject objectB) {
        return false;
    }

    private void addCollisionEvent_native(PhysicsCollisionObject node, PhysicsCollisionObject node1, long manifoldPointObjectId) {
        this.collisionEvents.add(this.eventFactory.getEvent(1, node, node1, manifoldPointObjectId));
    }

    private boolean notifyCollisionGroupListeners_native(PhysicsCollisionObject node, PhysicsCollisionObject node1) {
        PhysicsCollisionGroupListener listener = this.collisionGroupListeners.get(node.getCollisionGroup());
        PhysicsCollisionGroupListener listener1 = this.collisionGroupListeners.get(node1.getCollisionGroup());
        boolean result = true;
        if (listener != null) {
            result = listener.collide(node, node1);
        }
        if (listener1 != null && node.getCollisionGroup() != node1.getCollisionGroup()) {
            result = listener1.collide(node, node1) && result;
        }
        return result;
    }

    public void update(float time) {
        this.update(time, this.maxSubSteps);
    }

    public void update(float time, int maxSteps) {
        this.stepSimulation(this.physicsSpaceId, time, maxSteps, this.accuracy);
    }

    private native void stepSimulation(long var1, float var3, int var4, float var5);

    public void distributeEvents() {
        int clistsize = this.collisionListeners.size();
        while (!this.collisionEvents.isEmpty()) {
            PhysicsCollisionEvent physicsCollisionEvent = this.collisionEvents.pop();
            for (int i = 0; i < clistsize; ++i) {
                this.collisionListeners.get(i).collision(physicsCollisionEvent);
            }
            this.eventFactory.recycle(physicsCollisionEvent);
        }
    }

    public static <V> Future<V> enqueueOnThisThread(Callable<V> callable) {
        AppTask task = new AppTask(callable);
        System.out.println("created apptask");
        pQueueTL.get().add(task);
        return task;
    }

    public <V> Future<V> enqueue(Callable<V> callable) {
        AppTask task = new AppTask(callable);
        this.pQueue.add(task);
        return task;
    }

    public void add(Object obj) {
        if (obj instanceof PhysicsControl) {
            ((PhysicsControl)obj).setPhysicsSpace(this);
        } else if (obj instanceof Spatial) {
            Spatial node = (Spatial)obj;
            for (int i = 0; i < node.getNumControls(); ++i) {
                if (!(node.getControl(i) instanceof PhysicsControl)) continue;
                this.add((PhysicsControl)node.getControl(i));
            }
        } else if (obj instanceof PhysicsCollisionObject) {
            this.addCollisionObject((PhysicsCollisionObject)obj);
        } else if (obj instanceof PhysicsJoint) {
            this.addJoint((PhysicsJoint)obj);
        } else {
            throw new UnsupportedOperationException("Cannot add this kind of object to the physics space.");
        }
    }

    public void addCollisionObject(PhysicsCollisionObject obj) {
        if (obj instanceof PhysicsGhostObject) {
            this.addGhostObject((PhysicsGhostObject)obj);
        } else if (obj instanceof PhysicsRigidBody) {
            this.addRigidBody((PhysicsRigidBody)obj);
        } else if (obj instanceof PhysicsVehicle) {
            this.addRigidBody((PhysicsVehicle)obj);
        } else if (obj instanceof PhysicsCharacter) {
            this.addCharacter((PhysicsCharacter)obj);
        }
    }

    public void remove(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof PhysicsControl) {
            ((PhysicsControl)obj).setPhysicsSpace(null);
        } else if (obj instanceof Spatial) {
            Spatial node = (Spatial)obj;
            for (int i = 0; i < node.getNumControls(); ++i) {
                if (!(node.getControl(i) instanceof PhysicsControl)) continue;
                this.remove((PhysicsControl)node.getControl(i));
            }
        } else if (obj instanceof PhysicsCollisionObject) {
            this.removeCollisionObject((PhysicsCollisionObject)obj);
        } else if (obj instanceof PhysicsJoint) {
            this.removeJoint((PhysicsJoint)obj);
        } else {
            throw new UnsupportedOperationException("Cannot remove this kind of object from the physics space.");
        }
    }

    public void removeCollisionObject(PhysicsCollisionObject obj) {
        if (obj instanceof PhysicsGhostObject) {
            this.removeGhostObject((PhysicsGhostObject)obj);
        } else if (obj instanceof PhysicsRigidBody) {
            this.removeRigidBody((PhysicsRigidBody)obj);
        } else if (obj instanceof PhysicsCharacter) {
            this.removeCharacter((PhysicsCharacter)obj);
        }
    }

    public void addAll(Spatial spatial) {
        if (spatial.getControl(RigidBodyControl.class) != null) {
            RigidBodyControl physicsNode = (RigidBodyControl)spatial.getControl(RigidBodyControl.class);
            this.add(physicsNode);
            List<PhysicsJoint> joints = physicsNode.getJoints();
            for (PhysicsJoint physicsJoint : joints) {
                if (!physicsNode.equals(physicsJoint.getBodyA())) continue;
                this.add(physicsJoint);
            }
        } else {
            this.add(spatial);
        }
        if (spatial instanceof Node) {
            List children = ((Node)spatial).getChildren();
            for (Spatial spat : children) {
                this.addAll(spat);
            }
        }
    }

    public void removeAll(Spatial spatial) {
        if (spatial.getControl(RigidBodyControl.class) != null) {
            RigidBodyControl physicsNode = (RigidBodyControl)spatial.getControl(RigidBodyControl.class);
            List<PhysicsJoint> joints = physicsNode.getJoints();
            for (PhysicsJoint physicsJoint : joints) {
                if (!physicsNode.equals(physicsJoint.getBodyA())) continue;
                this.removeJoint(physicsJoint);
            }
            this.remove(physicsNode);
        } else if (spatial.getControl(PhysicsControl.class) != null) {
            this.remove(spatial);
        }
        if (spatial instanceof Node) {
            List children = ((Node)spatial).getChildren();
            for (Spatial spat : children) {
                this.removeAll(spat);
            }
        }
    }

    private native void addCollisionObject(long var1, long var3);

    private native void removeCollisionObject(long var1, long var3);

    private native void addRigidBody(long var1, long var3);

    private native void removeRigidBody(long var1, long var3);

    private native void addCharacterObject(long var1, long var3);

    private native void removeCharacterObject(long var1, long var3);

    private native void addAction(long var1, long var3);

    private native void removeAction(long var1, long var3);

    private native void addVehicle(long var1, long var3);

    private native void removeVehicle(long var1, long var3);

    private native void addConstraint(long var1, long var3);

    private native void addConstraintC(long var1, long var3, boolean var5);

    private native void removeConstraint(long var1, long var3);

    private void addGhostObject(PhysicsGhostObject node) {
        if (this.physicsGhostObjects.containsKey(node.getObjectId())) {
            logger.log(Level.WARNING, "GhostObject {0} already exists in PhysicsSpace, cannot add.", node);
            return;
        }
        this.physicsGhostObjects.put(node.getObjectId(), node);
        logger.log(Level.FINE, "Adding ghost object {0} to physics space.", Long.toHexString(node.getObjectId()));
        this.addCollisionObject(this.physicsSpaceId, node.getObjectId());
    }

    private void removeGhostObject(PhysicsGhostObject node) {
        if (!this.physicsGhostObjects.containsKey(node.getObjectId())) {
            logger.log(Level.WARNING, "GhostObject {0} does not exist in PhysicsSpace, cannot remove.", node);
            return;
        }
        this.physicsGhostObjects.remove(node.getObjectId());
        logger.log(Level.FINE, "Removing ghost object {0} from physics space.", Long.toHexString(node.getObjectId()));
        this.removeCollisionObject(this.physicsSpaceId, node.getObjectId());
    }

    private void addCharacter(PhysicsCharacter node) {
        if (this.physicsCharacters.containsKey(node.getObjectId())) {
            logger.log(Level.WARNING, "Character {0} already exists in PhysicsSpace, cannot add.", node);
            return;
        }
        this.physicsCharacters.put(node.getObjectId(), node);
        logger.log(Level.FINE, "Adding character {0} to physics space.", Long.toHexString(node.getObjectId()));
        this.addCharacterObject(this.physicsSpaceId, node.getObjectId());
        this.addAction(this.physicsSpaceId, node.getControllerId());
    }

    private void removeCharacter(PhysicsCharacter node) {
        if (!this.physicsCharacters.containsKey(node.getObjectId())) {
            logger.log(Level.WARNING, "Character {0} does not exist in PhysicsSpace, cannot remove.", node);
            return;
        }
        this.physicsCharacters.remove(node.getObjectId());
        logger.log(Level.FINE, "Removing character {0} from physics space.", Long.toHexString(node.getObjectId()));
        this.removeAction(this.physicsSpaceId, node.getControllerId());
        this.removeCharacterObject(this.physicsSpaceId, node.getObjectId());
    }

    private void addRigidBody(PhysicsRigidBody node) {
        if (this.physicsBodies.containsKey(node.getObjectId())) {
            logger.log(Level.WARNING, "RigidBody {0} already exists in PhysicsSpace, cannot add.", node);
            return;
        }
        this.physicsBodies.put(node.getObjectId(), node);
        boolean kinematic = false;
        if (node.isKinematic()) {
            kinematic = true;
            node.setKinematic(false);
        }
        this.addRigidBody(this.physicsSpaceId, node.getObjectId());
        if (kinematic) {
            node.setKinematic(true);
        }
        logger.log(Level.FINE, "Adding RigidBody {0} to physics space.", node.getObjectId());
        if (node instanceof PhysicsVehicle) {
            logger.log(Level.FINE, "Adding vehicle constraint {0} to physics space.", Long.toHexString(((PhysicsVehicle)node).getVehicleId()));
            this.physicsVehicles.put(((PhysicsVehicle)node).getVehicleId(), (PhysicsVehicle)node);
            this.addVehicle(this.physicsSpaceId, ((PhysicsVehicle)node).getVehicleId());
        }
    }

    private void removeRigidBody(PhysicsRigidBody node) {
        if (!this.physicsBodies.containsKey(node.getObjectId())) {
            logger.log(Level.WARNING, "RigidBody {0} does not exist in PhysicsSpace, cannot remove.", node);
            return;
        }
        if (node instanceof PhysicsVehicle) {
            logger.log(Level.FINE, "Removing vehicle constraint {0} from physics space.", Long.toHexString(((PhysicsVehicle)node).getVehicleId()));
            this.physicsVehicles.remove(((PhysicsVehicle)node).getVehicleId());
            this.removeVehicle(this.physicsSpaceId, ((PhysicsVehicle)node).getVehicleId());
        }
        logger.log(Level.FINE, "Removing RigidBody {0} from physics space.", Long.toHexString(node.getObjectId()));
        this.physicsBodies.remove(node.getObjectId());
        this.removeRigidBody(this.physicsSpaceId, node.getObjectId());
    }

    private void addJoint(PhysicsJoint joint) {
        if (this.physicsJoints.containsKey(joint.getObjectId())) {
            logger.log(Level.WARNING, "Joint {0} already exists in PhysicsSpace, cannot add.", joint);
            return;
        }
        logger.log(Level.FINE, "Adding Joint {0} to physics space.", Long.toHexString(joint.getObjectId()));
        this.physicsJoints.put(joint.getObjectId(), joint);
        this.addConstraintC(this.physicsSpaceId, joint.getObjectId(), !joint.isCollisionBetweenLinkedBodys());
    }

    private void removeJoint(PhysicsJoint joint) {
        if (!this.physicsJoints.containsKey(joint.getObjectId())) {
            logger.log(Level.WARNING, "Joint {0} does not exist in PhysicsSpace, cannot remove.", joint);
            return;
        }
        logger.log(Level.FINE, "Removing Joint {0} from physics space.", Long.toHexString(joint.getObjectId()));
        this.physicsJoints.remove(joint.getObjectId());
        this.removeConstraint(this.physicsSpaceId, joint.getObjectId());
    }

    public Collection<PhysicsRigidBody> getRigidBodyList() {
        return new LinkedList<PhysicsRigidBody>(this.physicsBodies.values());
    }

    public Collection<PhysicsGhostObject> getGhostObjectList() {
        return new LinkedList<PhysicsGhostObject>(this.physicsGhostObjects.values());
    }

    public Collection<PhysicsCharacter> getCharacterList() {
        return new LinkedList<PhysicsCharacter>(this.physicsCharacters.values());
    }

    public Collection<PhysicsJoint> getJointList() {
        return new LinkedList<PhysicsJoint>(this.physicsJoints.values());
    }

    public Collection<PhysicsVehicle> getVehicleList() {
        return new LinkedList<PhysicsVehicle>(this.physicsVehicles.values());
    }

    public void setGravity(Vector3f gravity) {
        this.gravity.set(gravity);
        this.setGravity(this.physicsSpaceId, gravity);
    }

    private native void setGravity(long var1, Vector3f var3);

    public Vector3f getGravity(Vector3f gravity) {
        return gravity.set(this.gravity);
    }

    public void addTickListener(PhysicsTickListener listener) {
        this.tickListeners.add(listener);
    }

    public void removeTickListener(PhysicsTickListener listener) {
        this.tickListeners.remove(listener);
    }

    public void addCollisionListener(PhysicsCollisionListener listener) {
        this.collisionListeners.add(listener);
    }

    public void removeCollisionListener(PhysicsCollisionListener listener) {
        this.collisionListeners.remove(listener);
    }

    public void addCollisionGroupListener(PhysicsCollisionGroupListener listener, int collisionGroup) {
        this.collisionGroupListeners.put(collisionGroup, listener);
    }

    public void removeCollisionGroupListener(int collisionGroup) {
        this.collisionGroupListeners.remove(collisionGroup);
    }

    public List rayTest(Vector3f from, Vector3f to) {
        LinkedList<PhysicsRayTestResult> results = new LinkedList<PhysicsRayTestResult>();
        this.rayTest(from, to, results);
        return results;
    }

    public void SetRayTestFlags(int flags) {
        this.rayTestFlags = flags;
    }

    public int GetRayTestFlags() {
        return this.rayTestFlags;
    }

    public List<PhysicsRayTestResult> rayTest(Vector3f from, Vector3f to, List<PhysicsRayTestResult> results) {
        results.clear();
        this.rayTest_native(from, to, this.physicsSpaceId, results, this.rayTestFlags);
        return results;
    }

    public native void rayTest_native(Vector3f var1, Vector3f var2, long var3, List<PhysicsRayTestResult> var5, int var6);

    public List<PhysicsSweepTestResult> sweepTest(CollisionShape shape, Transform start, Transform end) {
        LinkedList<PhysicsSweepTestResult> results = new LinkedList<PhysicsSweepTestResult>();
        this.sweepTest(shape, start, end, results);
        return results;
    }

    public List<PhysicsSweepTestResult> sweepTest(CollisionShape shape, Transform start, Transform end, List<PhysicsSweepTestResult> results) {
        return this.sweepTest(shape, start, end, results, 0.0f);
    }

    public native void sweepTest_native(long var1, Transform var3, Transform var4, long var5, List<PhysicsSweepTestResult> var7, float var8);

    public List<PhysicsSweepTestResult> sweepTest(CollisionShape shape, Transform start, Transform end, List<PhysicsSweepTestResult> results, float allowedCcdPenetration) {
        results.clear();
        this.sweepTest_native(shape.getObjectId(), start, end, this.physicsSpaceId, results, allowedCcdPenetration);
        return results;
    }

    public void destroy() {
        this.physicsBodies.clear();
        this.physicsJoints.clear();
    }

    public long getSpaceId() {
        return this.physicsSpaceId;
    }

    public BroadphaseType getBroadphaseType() {
        return this.broadphaseType;
    }

    public void setBroadphaseType(BroadphaseType broadphaseType) {
        this.broadphaseType = broadphaseType;
    }

    public void setMaxSubSteps(int steps) {
        this.maxSubSteps = steps;
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(float accuracy) {
        this.accuracy = accuracy;
    }

    public Vector3f getWorldMin() {
        return this.worldMin;
    }

    public void setWorldMin(Vector3f worldMin) {
        this.worldMin.set(worldMin);
    }

    public Vector3f getWorldMax() {
        return this.worldMax;
    }

    public void setWorldMax(Vector3f worldMax) {
        this.worldMax.set(worldMax);
    }

    public void setSolverNumIterations(int numIterations) {
        this.solverNumIterations = numIterations;
        this.setSolverNumIterations(this.physicsSpaceId, numIterations);
    }

    public int getSolverNumIterations() {
        return this.solverNumIterations;
    }

    private native void setSolverNumIterations(long var1, int var3);

    public static native void initNativePhysics();

    protected void finalize() throws Throwable {
        super.finalize();
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Finalizing PhysicsSpace {0}", Long.toHexString(this.physicsSpaceId));
        this.finalizeNative(this.physicsSpaceId);
    }

    private native void finalizeNative(long var1);

    public static enum BroadphaseType {
        SIMPLE,
        AXIS_SWEEP_3,
        AXIS_SWEEP_3_32,
        DBVT;

    }
}

