/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision;

import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.util.EventObject;

public class PhysicsCollisionEvent
extends EventObject {
    public static final int TYPE_ADDED = 0;
    public static final int TYPE_PROCESSED = 1;
    public static final int TYPE_DESTROYED = 2;
    private int type;
    private PhysicsCollisionObject nodeA;
    private PhysicsCollisionObject nodeB;
    private long manifoldPointObjectId = 0L;

    public PhysicsCollisionEvent(int type, PhysicsCollisionObject nodeA, PhysicsCollisionObject nodeB, long manifoldPointObjectId) {
        super(nodeA);
        this.type = type;
        this.nodeA = nodeA;
        this.nodeB = nodeB;
        this.manifoldPointObjectId = manifoldPointObjectId;
    }

    public void clean() {
        this.source = null;
        this.type = 0;
        this.nodeA = null;
        this.nodeB = null;
        this.manifoldPointObjectId = 0L;
    }

    public void refactor(int type, PhysicsCollisionObject source, PhysicsCollisionObject nodeB, long manifoldPointObjectId) {
        this.source = source;
        this.type = type;
        this.nodeA = source;
        this.nodeB = nodeB;
        this.manifoldPointObjectId = manifoldPointObjectId;
    }

    public int getType() {
        return this.type;
    }

    public Spatial getNodeA() {
        if (this.nodeA.getUserObject() instanceof Spatial) {
            return (Spatial)this.nodeA.getUserObject();
        }
        return null;
    }

    public Spatial getNodeB() {
        if (this.nodeB.getUserObject() instanceof Spatial) {
            return (Spatial)this.nodeB.getUserObject();
        }
        return null;
    }

    public PhysicsCollisionObject getObjectA() {
        return this.nodeA;
    }

    public PhysicsCollisionObject getObjectB() {
        return this.nodeB;
    }

    public float getAppliedImpulse() {
        return this.getAppliedImpulse(this.manifoldPointObjectId);
    }

    private native float getAppliedImpulse(long var1);

    public float getAppliedImpulseLateral1() {
        return this.getAppliedImpulseLateral1(this.manifoldPointObjectId);
    }

    private native float getAppliedImpulseLateral1(long var1);

    public float getAppliedImpulseLateral2() {
        return this.getAppliedImpulseLateral2(this.manifoldPointObjectId);
    }

    private native float getAppliedImpulseLateral2(long var1);

    public float getCombinedFriction() {
        return this.getCombinedFriction(this.manifoldPointObjectId);
    }

    private native float getCombinedFriction(long var1);

    public float getCombinedRestitution() {
        return this.getCombinedRestitution(this.manifoldPointObjectId);
    }

    private native float getCombinedRestitution(long var1);

    public float getDistance1() {
        return this.getDistance1(this.manifoldPointObjectId);
    }

    private native float getDistance1(long var1);

    public int getIndex0() {
        return this.getIndex0(this.manifoldPointObjectId);
    }

    private native int getIndex0(long var1);

    public int getIndex1() {
        return this.getIndex1(this.manifoldPointObjectId);
    }

    private native int getIndex1(long var1);

    public Vector3f getLateralFrictionDir1() {
        return this.getLateralFrictionDir1(new Vector3f());
    }

    public Vector3f getLateralFrictionDir1(Vector3f lateralFrictionDir1) {
        this.getLateralFrictionDir1(this.manifoldPointObjectId, lateralFrictionDir1);
        return lateralFrictionDir1;
    }

    private native void getLateralFrictionDir1(long var1, Vector3f var3);

    public Vector3f getLateralFrictionDir2() {
        return this.getLateralFrictionDir2(new Vector3f());
    }

    public Vector3f getLateralFrictionDir2(Vector3f lateralFrictionDir2) {
        this.getLateralFrictionDir2(this.manifoldPointObjectId, lateralFrictionDir2);
        return lateralFrictionDir2;
    }

    private native void getLateralFrictionDir2(long var1, Vector3f var3);

    public boolean isLateralFrictionInitialized() {
        return this.isLateralFrictionInitialized(this.manifoldPointObjectId);
    }

    private native boolean isLateralFrictionInitialized(long var1);

    public int getLifeTime() {
        return this.getLifeTime(this.manifoldPointObjectId);
    }

    private native int getLifeTime(long var1);

    public Vector3f getLocalPointA() {
        return this.getLocalPointA(new Vector3f());
    }

    public Vector3f getLocalPointA(Vector3f localPointA) {
        this.getLocalPointA(this.manifoldPointObjectId, localPointA);
        return localPointA;
    }

    private native void getLocalPointA(long var1, Vector3f var3);

    public Vector3f getLocalPointB() {
        return this.getLocalPointB(new Vector3f());
    }

    public Vector3f getLocalPointB(Vector3f localPointB) {
        this.getLocalPointB(this.manifoldPointObjectId, localPointB);
        return localPointB;
    }

    private native void getLocalPointB(long var1, Vector3f var3);

    public Vector3f getNormalWorldOnB() {
        return this.getNormalWorldOnB(new Vector3f());
    }

    public Vector3f getNormalWorldOnB(Vector3f normalWorldOnB) {
        this.getNormalWorldOnB(this.manifoldPointObjectId, normalWorldOnB);
        return normalWorldOnB;
    }

    private native void getNormalWorldOnB(long var1, Vector3f var3);

    public int getPartId0() {
        return this.getPartId0(this.manifoldPointObjectId);
    }

    private native int getPartId0(long var1);

    public int getPartId1() {
        return this.getPartId1(this.manifoldPointObjectId);
    }

    private native int getPartId1(long var1);

    public Vector3f getPositionWorldOnA() {
        return this.getPositionWorldOnA(new Vector3f());
    }

    public Vector3f getPositionWorldOnA(Vector3f positionWorldOnA) {
        this.getPositionWorldOnA(this.manifoldPointObjectId, positionWorldOnA);
        return positionWorldOnA;
    }

    private native void getPositionWorldOnA(long var1, Vector3f var3);

    public Vector3f getPositionWorldOnB() {
        return this.getPositionWorldOnB(new Vector3f());
    }

    public Vector3f getPositionWorldOnB(Vector3f positionWorldOnB) {
        this.getPositionWorldOnB(this.manifoldPointObjectId, positionWorldOnB);
        return positionWorldOnB;
    }

    private native void getPositionWorldOnB(long var1, Vector3f var3);
}

