/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompoundCollisionShape
extends CollisionShape {
    protected ArrayList<ChildCollisionShape> children = new ArrayList();

    public CompoundCollisionShape() {
        this.objectId = this.createShape();
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Shape {0}", Long.toHexString(this.objectId));
    }

    public void addChildShape(CollisionShape shape, Vector3f location) {
        this.addChildShape(shape, location, new Matrix3f());
    }

    public void addChildShape(CollisionShape shape, Vector3f location, Matrix3f rotation) {
        if (shape instanceof CompoundCollisionShape) {
            throw new IllegalStateException("CompoundCollisionShapes cannot have CompoundCollisionShapes as children!");
        }
        this.children.add(new ChildCollisionShape(location.clone(), rotation.clone(), shape));
        this.addChildShape(this.objectId, shape.getObjectId(), location, rotation);
    }

    private void addChildShapeDirect(CollisionShape shape, Vector3f location, Matrix3f rotation) {
        if (shape instanceof CompoundCollisionShape) {
            throw new IllegalStateException("CompoundCollisionShapes cannot have CompoundCollisionShapes as children!");
        }
        this.addChildShape(this.objectId, shape.getObjectId(), location, rotation);
    }

    public void removeChildShape(CollisionShape shape) {
        this.removeChildShape(this.objectId, shape.getObjectId());
        Iterator<ChildCollisionShape> it = this.children.iterator();
        while (it.hasNext()) {
            ChildCollisionShape childCollisionShape = it.next();
            if (childCollisionShape.shape != shape) continue;
            it.remove();
        }
    }

    public List<ChildCollisionShape> getChildren() {
        return this.children;
    }

    @Override
    public void setScale(Vector3f scale) {
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "CompoundCollisionShape cannot be scaled");
    }

    private native long createShape();

    private native long addChildShape(long var1, long var3, Vector3f var5, Matrix3f var6);

    private native long removeChildShape(long var1, long var3);

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.writeSavableArrayList(this.children, "children", new ArrayList());
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.children = capsule.readSavableArrayList("children", new ArrayList());
        this.setScale(this.scale);
        this.setMargin(this.margin);
        this.loadChildren();
    }

    private void loadChildren() {
        for (ChildCollisionShape child : this.children) {
            this.addChildShapeDirect(child.shape, child.location, child.rotation);
        }
    }
}

